/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.GetResourcesV2Request;
import software.amazon.awssdk.services.securityhub.model.GetResourcesV2Response;
import software.amazon.awssdk.services.securityhub.model.ResourceResult;

public class GetResourcesV2Publisher
implements SdkPublisher<GetResourcesV2Response> {
    private final SecurityHubAsyncClient client;
    private final GetResourcesV2Request firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetResourcesV2Publisher(SecurityHubAsyncClient client, GetResourcesV2Request firstRequest) {
        this(client, firstRequest, false);
    }

    private GetResourcesV2Publisher(SecurityHubAsyncClient client, GetResourcesV2Request firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetResourcesV2ResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetResourcesV2Response> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceResult> resources() {
        Function<GetResourcesV2Response, Iterator> getIterator = response -> {
            if (response != null && response.resources() != null) {
                return response.resources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetResourcesV2ResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetResourcesV2ResponseFetcher
    implements AsyncPageFetcher<GetResourcesV2Response> {
        private GetResourcesV2ResponseFetcher() {
        }

        public boolean hasNextPage(GetResourcesV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetResourcesV2Response> nextPage(GetResourcesV2Response previousPage) {
            if (previousPage == null) {
                return GetResourcesV2Publisher.this.client.getResourcesV2(GetResourcesV2Publisher.this.firstRequest);
            }
            return GetResourcesV2Publisher.this.client.getResourcesV2((GetResourcesV2Request)((Object)GetResourcesV2Publisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

