/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.GetFindingsTrendsV2Request;
import software.amazon.awssdk.services.securityhub.model.GetFindingsTrendsV2Response;
import software.amazon.awssdk.services.securityhub.model.TrendsMetricsResult;

public class GetFindingsTrendsV2Iterable
implements SdkIterable<GetFindingsTrendsV2Response> {
    private final SecurityHubClient client;
    private final GetFindingsTrendsV2Request firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetFindingsTrendsV2Iterable(SecurityHubClient client, GetFindingsTrendsV2Request firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetFindingsTrendsV2ResponseFetcher();
    }

    public Iterator<GetFindingsTrendsV2Response> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TrendsMetricsResult> trendsMetrics() {
        Function<GetFindingsTrendsV2Response, Iterator> getIterator = response -> {
            if (response != null && response.trendsMetrics() != null) {
                return response.trendsMetrics().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetFindingsTrendsV2ResponseFetcher
    implements SyncPageFetcher<GetFindingsTrendsV2Response> {
        private GetFindingsTrendsV2ResponseFetcher() {
        }

        public boolean hasNextPage(GetFindingsTrendsV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetFindingsTrendsV2Response nextPage(GetFindingsTrendsV2Response previousPage) {
            if (previousPage == null) {
                return GetFindingsTrendsV2Iterable.this.client.getFindingsTrendsV2(GetFindingsTrendsV2Iterable.this.firstRequest);
            }
            return GetFindingsTrendsV2Iterable.this.client.getFindingsTrendsV2((GetFindingsTrendsV2Request)((Object)GetFindingsTrendsV2Iterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

