/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.DescribeProductsV2Request;
import software.amazon.awssdk.services.securityhub.model.DescribeProductsV2Response;
import software.amazon.awssdk.services.securityhub.model.ProductV2;

public class DescribeProductsV2Iterable
implements SdkIterable<DescribeProductsV2Response> {
    private final SecurityHubClient client;
    private final DescribeProductsV2Request firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeProductsV2Iterable(SecurityHubClient client, DescribeProductsV2Request firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeProductsV2ResponseFetcher();
    }

    public Iterator<DescribeProductsV2Response> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProductV2> productsV2() {
        Function<DescribeProductsV2Response, Iterator> getIterator = response -> {
            if (response != null && response.productsV2() != null) {
                return response.productsV2().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeProductsV2ResponseFetcher
    implements SyncPageFetcher<DescribeProductsV2Response> {
        private DescribeProductsV2ResponseFetcher() {
        }

        public boolean hasNextPage(DescribeProductsV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeProductsV2Response nextPage(DescribeProductsV2Response previousPage) {
            if (previousPage == null) {
                return DescribeProductsV2Iterable.this.client.describeProductsV2(DescribeProductsV2Iterable.this.firstRequest);
            }
            return DescribeProductsV2Iterable.this.client.describeProductsV2((DescribeProductsV2Request)((Object)DescribeProductsV2Iterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

