/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AllowedOperators;
import software.amazon.awssdk.services.securityhub.model.ResourcesTrendsCompositeFilterListCopier;
import software.amazon.awssdk.services.securityhub.model.ResourcesTrendsStringFilter;
import software.amazon.awssdk.services.securityhub.model.ResourcesTrendsStringFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourcesTrendsCompositeFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourcesTrendsCompositeFilter> {
    private static final SdkField<List<ResourcesTrendsStringFilter>> STRING_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StringFilters").getter(ResourcesTrendsCompositeFilter.getter(ResourcesTrendsCompositeFilter::stringFilters)).setter(ResourcesTrendsCompositeFilter.setter(Builder::stringFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcesTrendsStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourcesTrendsCompositeFilter>> NESTED_COMPOSITE_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NestedCompositeFilters").getter(ResourcesTrendsCompositeFilter.getter(ResourcesTrendsCompositeFilter::nestedCompositeFilters)).setter(ResourcesTrendsCompositeFilter.setter(Builder::nestedCompositeFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NestedCompositeFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcesTrendsCompositeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operator").getter(ResourcesTrendsCompositeFilter.getter(ResourcesTrendsCompositeFilter::operatorAsString)).setter(ResourcesTrendsCompositeFilter.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_FILTERS_FIELD, NESTED_COMPOSITE_FILTERS_FIELD, OPERATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourcesTrendsCompositeFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ResourcesTrendsStringFilter> stringFilters;
    private final List<ResourcesTrendsCompositeFilter> nestedCompositeFilters;
    private final String operator;

    private ResourcesTrendsCompositeFilter(BuilderImpl builder) {
        this.stringFilters = builder.stringFilters;
        this.nestedCompositeFilters = builder.nestedCompositeFilters;
        this.operator = builder.operator;
    }

    public final boolean hasStringFilters() {
        return this.stringFilters != null && !(this.stringFilters instanceof SdkAutoConstructList);
    }

    public final List<ResourcesTrendsStringFilter> stringFilters() {
        return this.stringFilters;
    }

    public final boolean hasNestedCompositeFilters() {
        return this.nestedCompositeFilters != null && !(this.nestedCompositeFilters instanceof SdkAutoConstructList);
    }

    public final List<ResourcesTrendsCompositeFilter> nestedCompositeFilters() {
        return this.nestedCompositeFilters;
    }

    public final AllowedOperators operator() {
        return AllowedOperators.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStringFilters() ? this.stringFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNestedCompositeFilters() ? this.nestedCompositeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcesTrendsCompositeFilter)) {
            return false;
        }
        ResourcesTrendsCompositeFilter other = (ResourcesTrendsCompositeFilter)obj;
        return this.hasStringFilters() == other.hasStringFilters() && Objects.equals(this.stringFilters(), other.stringFilters()) && this.hasNestedCompositeFilters() == other.hasNestedCompositeFilters() && Objects.equals(this.nestedCompositeFilters(), other.nestedCompositeFilters()) && Objects.equals(this.operatorAsString(), other.operatorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ResourcesTrendsCompositeFilter").add("StringFilters", this.hasStringFilters() ? this.stringFilters() : null).add("NestedCompositeFilters", this.hasNestedCompositeFilters() ? this.nestedCompositeFilters() : null).add("Operator", (Object)this.operatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StringFilters": {
                return Optional.ofNullable(clazz.cast(this.stringFilters()));
            }
            case "NestedCompositeFilters": {
                return Optional.ofNullable(clazz.cast(this.nestedCompositeFilters()));
            }
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StringFilters", STRING_FILTERS_FIELD);
        map.put("NestedCompositeFilters", NESTED_COMPOSITE_FILTERS_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourcesTrendsCompositeFilter, T> g) {
        return obj -> g.apply((ResourcesTrendsCompositeFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ResourcesTrendsStringFilter> stringFilters = DefaultSdkAutoConstructList.getInstance();
        private List<ResourcesTrendsCompositeFilter> nestedCompositeFilters = DefaultSdkAutoConstructList.getInstance();
        private String operator;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcesTrendsCompositeFilter model) {
            this.stringFilters(model.stringFilters);
            this.nestedCompositeFilters(model.nestedCompositeFilters);
            this.operator(model.operator);
        }

        public final List<ResourcesTrendsStringFilter.Builder> getStringFilters() {
            List<ResourcesTrendsStringFilter.Builder> result = ResourcesTrendsStringFilterListCopier.copyToBuilder(this.stringFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStringFilters(Collection<ResourcesTrendsStringFilter.BuilderImpl> stringFilters) {
            this.stringFilters = ResourcesTrendsStringFilterListCopier.copyFromBuilder(stringFilters);
        }

        @Override
        public final Builder stringFilters(Collection<ResourcesTrendsStringFilter> stringFilters) {
            this.stringFilters = ResourcesTrendsStringFilterListCopier.copy(stringFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringFilters(ResourcesTrendsStringFilter ... stringFilters) {
            this.stringFilters(Arrays.asList(stringFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringFilters(Consumer<ResourcesTrendsStringFilter.Builder> ... stringFilters) {
            this.stringFilters(Stream.of(stringFilters).map(c -> (ResourcesTrendsStringFilter)((ResourcesTrendsStringFilter.Builder)ResourcesTrendsStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getNestedCompositeFilters() {
            List<Builder> result = ResourcesTrendsCompositeFilterListCopier.copyToBuilder(this.nestedCompositeFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNestedCompositeFilters(Collection<BuilderImpl> nestedCompositeFilters) {
            this.nestedCompositeFilters = ResourcesTrendsCompositeFilterListCopier.copyFromBuilder(nestedCompositeFilters);
        }

        @Override
        public final Builder nestedCompositeFilters(Collection<ResourcesTrendsCompositeFilter> nestedCompositeFilters) {
            this.nestedCompositeFilters = ResourcesTrendsCompositeFilterListCopier.copy(nestedCompositeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nestedCompositeFilters(ResourcesTrendsCompositeFilter ... nestedCompositeFilters) {
            this.nestedCompositeFilters(Arrays.asList(nestedCompositeFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nestedCompositeFilters(Consumer<Builder> ... nestedCompositeFilters) {
            this.nestedCompositeFilters(Stream.of(nestedCompositeFilters).map(c -> (ResourcesTrendsCompositeFilter)((Builder)ResourcesTrendsCompositeFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(AllowedOperators operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public ResourcesTrendsCompositeFilter build() {
            return new ResourcesTrendsCompositeFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourcesTrendsCompositeFilter> {
        public Builder stringFilters(Collection<ResourcesTrendsStringFilter> var1);

        public Builder stringFilters(ResourcesTrendsStringFilter ... var1);

        public Builder stringFilters(Consumer<ResourcesTrendsStringFilter.Builder> ... var1);

        public Builder nestedCompositeFilters(Collection<ResourcesTrendsCompositeFilter> var1);

        public Builder nestedCompositeFilters(ResourcesTrendsCompositeFilter ... var1);

        public Builder nestedCompositeFilters(Consumer<Builder> ... var1);

        public Builder operator(String var1);

        public Builder operator(AllowedOperators var1);
    }
}

