/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OcsfStringField {
    METADATA_UID("metadata.uid"),
    ACTIVITY_NAME("activity_name"),
    CLOUD_ACCOUNT_UID("cloud.account.uid"),
    CLOUD_PROVIDER("cloud.provider"),
    CLOUD_REGION("cloud.region"),
    COMPLIANCE_ASSESSMENTS_CATEGORY("compliance.assessments.category"),
    COMPLIANCE_ASSESSMENTS_NAME("compliance.assessments.name"),
    COMPLIANCE_CONTROL("compliance.control"),
    COMPLIANCE_STATUS("compliance.status"),
    COMPLIANCE_STANDARDS("compliance.standards"),
    FINDING_INFO_DESC("finding_info.desc"),
    FINDING_INFO_SRC_URL("finding_info.src_url"),
    FINDING_INFO_TITLE("finding_info.title"),
    FINDING_INFO_TYPES("finding_info.types"),
    FINDING_INFO_UID("finding_info.uid"),
    FINDING_INFO_RELATED_EVENTS_TRAITS_CATEGORY("finding_info.related_events.traits.category"),
    FINDING_INFO_RELATED_EVENTS_UID("finding_info.related_events.uid"),
    FINDING_INFO_RELATED_EVENTS_PRODUCT_UID("finding_info.related_events.product.uid"),
    FINDING_INFO_RELATED_EVENTS_TITLE("finding_info.related_events.title"),
    METADATA_PRODUCT_NAME("metadata.product.name"),
    METADATA_PRODUCT_UID("metadata.product.uid"),
    METADATA_PRODUCT_VENDOR_NAME("metadata.product.vendor_name"),
    REMEDIATION_DESC("remediation.desc"),
    REMEDIATION_REFERENCES("remediation.references"),
    RESOURCES_CLOUD_PARTITION("resources.cloud_partition"),
    RESOURCES_REGION("resources.region"),
    RESOURCES_TYPE("resources.type"),
    RESOURCES_UID("resources.uid"),
    SEVERITY("severity"),
    STATUS("status"),
    COMMENT("comment"),
    VULNERABILITIES_FIX_COVERAGE("vulnerabilities.fix_coverage"),
    CLASS_NAME("class_name"),
    DATABUCKET_ENCRYPTION_DETAILS_ALGORITHM("databucket.encryption_details.algorithm"),
    DATABUCKET_ENCRYPTION_DETAILS_KEY_UID("databucket.encryption_details.key_uid"),
    DATABUCKET_FILE_DATA_CLASSIFICATIONS_CLASSIFIER_DETAILS_TYPE("databucket.file.data_classifications.classifier_details.type"),
    EVIDENCES_ACTOR_USER_ACCOUNT_UID("evidences.actor.user.account.uid"),
    EVIDENCES_API_OPERATION("evidences.api.operation"),
    EVIDENCES_API_RESPONSE_ERROR_MESSAGE("evidences.api.response.error_message"),
    EVIDENCES_API_SERVICE_NAME("evidences.api.service.name"),
    EVIDENCES_CONNECTION_INFO_DIRECTION("evidences.connection_info.direction"),
    EVIDENCES_CONNECTION_INFO_PROTOCOL_NAME("evidences.connection_info.protocol_name"),
    EVIDENCES_DST_ENDPOINT_AUTONOMOUS_SYSTEM_NAME("evidences.dst_endpoint.autonomous_system.name"),
    EVIDENCES_DST_ENDPOINT_LOCATION_CITY("evidences.dst_endpoint.location.city"),
    EVIDENCES_DST_ENDPOINT_LOCATION_COUNTRY("evidences.dst_endpoint.location.country"),
    EVIDENCES_SRC_ENDPOINT_AUTONOMOUS_SYSTEM_NAME("evidences.src_endpoint.autonomous_system.name"),
    EVIDENCES_SRC_ENDPOINT_HOSTNAME("evidences.src_endpoint.hostname"),
    EVIDENCES_SRC_ENDPOINT_LOCATION_CITY("evidences.src_endpoint.location.city"),
    EVIDENCES_SRC_ENDPOINT_LOCATION_COUNTRY("evidences.src_endpoint.location.country"),
    FINDING_INFO_ANALYTIC_NAME("finding_info.analytic.name"),
    MALWARE_NAME("malware.name"),
    MALWARE_SCAN_INFO_UID("malware_scan_info.uid"),
    MALWARE_SEVERITY("malware.severity"),
    RESOURCES_CLOUD_FUNCTION_LAYERS_UID_ALT("resources.cloud_function.layers.uid_alt"),
    RESOURCES_CLOUD_FUNCTION_RUNTIME("resources.cloud_function.runtime"),
    RESOURCES_CLOUD_FUNCTION_USER_UID("resources.cloud_function.user.uid"),
    RESOURCES_DEVICE_ENCRYPTION_DETAILS_KEY_UID("resources.device.encryption_details.key_uid"),
    RESOURCES_DEVICE_IMAGE_UID("resources.device.image.uid"),
    RESOURCES_IMAGE_ARCHITECTURE("resources.image.architecture"),
    RESOURCES_IMAGE_REGISTRY_UID("resources.image.registry_uid"),
    RESOURCES_IMAGE_REPOSITORY_NAME("resources.image.repository_name"),
    RESOURCES_IMAGE_UID("resources.image.uid"),
    RESOURCES_SUBNET_INFO_UID("resources.subnet_info.uid"),
    RESOURCES_VPC_UID("resources.vpc_uid"),
    VULNERABILITIES_AFFECTED_CODE_FILE_PATH("vulnerabilities.affected_code.file.path"),
    VULNERABILITIES_AFFECTED_PACKAGES_NAME("vulnerabilities.affected_packages.name"),
    VULNERABILITIES_CVE_EPSS_SCORE("vulnerabilities.cve.epss.score"),
    VULNERABILITIES_CVE_UID("vulnerabilities.cve.uid"),
    VULNERABILITIES_RELATED_VULNERABILITIES("vulnerabilities.related_vulnerabilities"),
    CLOUD_ACCOUNT_NAME("cloud.account.name"),
    VENDOR_ATTRIBUTES_SEVERITY("vendor_attributes.severity"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OcsfStringField> VALUE_MAP;
    private final String value;

    private OcsfStringField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OcsfStringField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OcsfStringField> knownValues() {
        EnumSet<OcsfStringField> knownValues = EnumSet.allOf(OcsfStringField.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OcsfStringField.class, OcsfStringField::toString);
    }
}

