/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OcsfMapField {
    RESOURCES_TAGS("resources.tags"),
    COMPLIANCE_CONTROL_PARAMETERS("compliance.control_parameters"),
    DATABUCKET_TAGS("databucket.tags"),
    FINDING_INFO_TAGS("finding_info.tags"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OcsfMapField> VALUE_MAP;
    private final String value;

    private OcsfMapField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OcsfMapField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OcsfMapField> knownValues() {
        EnumSet<OcsfMapField> knownValues = EnumSet.allOf(OcsfMapField.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OcsfMapField.class, OcsfMapField::toString);
    }
}

