/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AllowedOperators;
import software.amazon.awssdk.services.securityhub.model.FindingsTrendsCompositeFilterListCopier;
import software.amazon.awssdk.services.securityhub.model.FindingsTrendsStringFilter;
import software.amazon.awssdk.services.securityhub.model.FindingsTrendsStringFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FindingsTrendsCompositeFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FindingsTrendsCompositeFilter> {
    private static final SdkField<List<FindingsTrendsStringFilter>> STRING_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StringFilters").getter(FindingsTrendsCompositeFilter.getter(FindingsTrendsCompositeFilter::stringFilters)).setter(FindingsTrendsCompositeFilter.setter(Builder::stringFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FindingsTrendsStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FindingsTrendsCompositeFilter>> NESTED_COMPOSITE_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NestedCompositeFilters").getter(FindingsTrendsCompositeFilter.getter(FindingsTrendsCompositeFilter::nestedCompositeFilters)).setter(FindingsTrendsCompositeFilter.setter(Builder::nestedCompositeFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NestedCompositeFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FindingsTrendsCompositeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operator").getter(FindingsTrendsCompositeFilter.getter(FindingsTrendsCompositeFilter::operatorAsString)).setter(FindingsTrendsCompositeFilter.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_FILTERS_FIELD, NESTED_COMPOSITE_FILTERS_FIELD, OPERATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FindingsTrendsCompositeFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<FindingsTrendsStringFilter> stringFilters;
    private final List<FindingsTrendsCompositeFilter> nestedCompositeFilters;
    private final String operator;

    private FindingsTrendsCompositeFilter(BuilderImpl builder) {
        this.stringFilters = builder.stringFilters;
        this.nestedCompositeFilters = builder.nestedCompositeFilters;
        this.operator = builder.operator;
    }

    public final boolean hasStringFilters() {
        return this.stringFilters != null && !(this.stringFilters instanceof SdkAutoConstructList);
    }

    public final List<FindingsTrendsStringFilter> stringFilters() {
        return this.stringFilters;
    }

    public final boolean hasNestedCompositeFilters() {
        return this.nestedCompositeFilters != null && !(this.nestedCompositeFilters instanceof SdkAutoConstructList);
    }

    public final List<FindingsTrendsCompositeFilter> nestedCompositeFilters() {
        return this.nestedCompositeFilters;
    }

    public final AllowedOperators operator() {
        return AllowedOperators.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStringFilters() ? this.stringFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNestedCompositeFilters() ? this.nestedCompositeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingsTrendsCompositeFilter)) {
            return false;
        }
        FindingsTrendsCompositeFilter other = (FindingsTrendsCompositeFilter)obj;
        return this.hasStringFilters() == other.hasStringFilters() && Objects.equals(this.stringFilters(), other.stringFilters()) && this.hasNestedCompositeFilters() == other.hasNestedCompositeFilters() && Objects.equals(this.nestedCompositeFilters(), other.nestedCompositeFilters()) && Objects.equals(this.operatorAsString(), other.operatorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FindingsTrendsCompositeFilter").add("StringFilters", this.hasStringFilters() ? this.stringFilters() : null).add("NestedCompositeFilters", this.hasNestedCompositeFilters() ? this.nestedCompositeFilters() : null).add("Operator", (Object)this.operatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StringFilters": {
                return Optional.ofNullable(clazz.cast(this.stringFilters()));
            }
            case "NestedCompositeFilters": {
                return Optional.ofNullable(clazz.cast(this.nestedCompositeFilters()));
            }
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StringFilters", STRING_FILTERS_FIELD);
        map.put("NestedCompositeFilters", NESTED_COMPOSITE_FILTERS_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingsTrendsCompositeFilter, T> g) {
        return obj -> g.apply((FindingsTrendsCompositeFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FindingsTrendsStringFilter> stringFilters = DefaultSdkAutoConstructList.getInstance();
        private List<FindingsTrendsCompositeFilter> nestedCompositeFilters = DefaultSdkAutoConstructList.getInstance();
        private String operator;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingsTrendsCompositeFilter model) {
            this.stringFilters(model.stringFilters);
            this.nestedCompositeFilters(model.nestedCompositeFilters);
            this.operator(model.operator);
        }

        public final List<FindingsTrendsStringFilter.Builder> getStringFilters() {
            List<FindingsTrendsStringFilter.Builder> result = FindingsTrendsStringFilterListCopier.copyToBuilder(this.stringFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStringFilters(Collection<FindingsTrendsStringFilter.BuilderImpl> stringFilters) {
            this.stringFilters = FindingsTrendsStringFilterListCopier.copyFromBuilder(stringFilters);
        }

        @Override
        public final Builder stringFilters(Collection<FindingsTrendsStringFilter> stringFilters) {
            this.stringFilters = FindingsTrendsStringFilterListCopier.copy(stringFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringFilters(FindingsTrendsStringFilter ... stringFilters) {
            this.stringFilters(Arrays.asList(stringFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringFilters(Consumer<FindingsTrendsStringFilter.Builder> ... stringFilters) {
            this.stringFilters(Stream.of(stringFilters).map(c -> (FindingsTrendsStringFilter)((FindingsTrendsStringFilter.Builder)FindingsTrendsStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getNestedCompositeFilters() {
            List<Builder> result = FindingsTrendsCompositeFilterListCopier.copyToBuilder(this.nestedCompositeFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNestedCompositeFilters(Collection<BuilderImpl> nestedCompositeFilters) {
            this.nestedCompositeFilters = FindingsTrendsCompositeFilterListCopier.copyFromBuilder(nestedCompositeFilters);
        }

        @Override
        public final Builder nestedCompositeFilters(Collection<FindingsTrendsCompositeFilter> nestedCompositeFilters) {
            this.nestedCompositeFilters = FindingsTrendsCompositeFilterListCopier.copy(nestedCompositeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nestedCompositeFilters(FindingsTrendsCompositeFilter ... nestedCompositeFilters) {
            this.nestedCompositeFilters(Arrays.asList(nestedCompositeFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nestedCompositeFilters(Consumer<Builder> ... nestedCompositeFilters) {
            this.nestedCompositeFilters(Stream.of(nestedCompositeFilters).map(c -> (FindingsTrendsCompositeFilter)((Builder)FindingsTrendsCompositeFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(AllowedOperators operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public FindingsTrendsCompositeFilter build() {
            return new FindingsTrendsCompositeFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FindingsTrendsCompositeFilter> {
        public Builder stringFilters(Collection<FindingsTrendsStringFilter> var1);

        public Builder stringFilters(FindingsTrendsStringFilter ... var1);

        public Builder stringFilters(Consumer<FindingsTrendsStringFilter.Builder> ... var1);

        public Builder nestedCompositeFilters(Collection<FindingsTrendsCompositeFilter> var1);

        public Builder nestedCompositeFilters(FindingsTrendsCompositeFilter ... var1);

        public Builder nestedCompositeFilters(Consumer<Builder> ... var1);

        public Builder operator(String var1);

        public Builder operator(AllowedOperators var1);
    }
}

