/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConnectorProviderName {
    JIRA_CLOUD("JIRA_CLOUD"),
    SERVICENOW("SERVICENOW"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConnectorProviderName> VALUE_MAP;
    private final String value;

    private ConnectorProviderName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectorProviderName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectorProviderName> knownValues() {
        EnumSet<ConnectorProviderName> knownValues = EnumSet.allOf(ConnectorProviderName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConnectorProviderName.class, ConnectorProviderName::toString);
    }
}

