/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.AggregatorV2;
import software.amazon.awssdk.services.securityhub.model.ListAggregatorsV2Request;
import software.amazon.awssdk.services.securityhub.model.ListAggregatorsV2Response;

public class ListAggregatorsV2Iterable
implements SdkIterable<ListAggregatorsV2Response> {
    private final SecurityHubClient client;
    private final ListAggregatorsV2Request firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAggregatorsV2Iterable(SecurityHubClient client, ListAggregatorsV2Request firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAggregatorsV2ResponseFetcher();
    }

    public Iterator<ListAggregatorsV2Response> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AggregatorV2> aggregatorsV2() {
        Function<ListAggregatorsV2Response, Iterator> getIterator = response -> {
            if (response != null && response.aggregatorsV2() != null) {
                return response.aggregatorsV2().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAggregatorsV2ResponseFetcher
    implements SyncPageFetcher<ListAggregatorsV2Response> {
        private ListAggregatorsV2ResponseFetcher() {
        }

        public boolean hasNextPage(ListAggregatorsV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAggregatorsV2Response nextPage(ListAggregatorsV2Response previousPage) {
            if (previousPage == null) {
                return ListAggregatorsV2Iterable.this.client.listAggregatorsV2(ListAggregatorsV2Iterable.this.firstRequest);
            }
            return ListAggregatorsV2Iterable.this.client.listAggregatorsV2((ListAggregatorsV2Request)((Object)ListAggregatorsV2Iterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

