/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.ConnectorSummary;
import software.amazon.awssdk.services.securityhub.model.ConnectorSummaryListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConnectorsV2Response
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, ListConnectorsV2Response> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListConnectorsV2Response.getter(ListConnectorsV2Response::nextToken)).setter(ListConnectorsV2Response.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ConnectorSummary>> CONNECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Connectors").getter(ListConnectorsV2Response.getter(ListConnectorsV2Response::connectors)).setter(ListConnectorsV2Response.setter(Builder::connectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConnectorSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CONNECTORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListConnectorsV2Response.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ConnectorSummary> connectors;

    private ListConnectorsV2Response(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.connectors = builder.connectors;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasConnectors() {
        return this.connectors != null && !(this.connectors instanceof SdkAutoConstructList);
    }

    public final List<ConnectorSummary> connectors() {
        return this.connectors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectors() ? this.connectors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectorsV2Response)) {
            return false;
        }
        ListConnectorsV2Response other = (ListConnectorsV2Response)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasConnectors() == other.hasConnectors() && Objects.equals(this.connectors(), other.connectors());
    }

    public final String toString() {
        return ToString.builder((String)"ListConnectorsV2Response").add("NextToken", (Object)this.nextToken()).add("Connectors", this.hasConnectors() ? this.connectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Connectors": {
                return Optional.ofNullable(clazz.cast(this.connectors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Connectors", CONNECTORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConnectorsV2Response, T> g) {
        return obj -> g.apply((ListConnectorsV2Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ConnectorSummary> connectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectorsV2Response model) {
            super(model);
            this.nextToken(model.nextToken);
            this.connectors(model.connectors);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ConnectorSummary.Builder> getConnectors() {
            List<ConnectorSummary.Builder> result = ConnectorSummaryListCopier.copyToBuilder(this.connectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectors(Collection<ConnectorSummary.BuilderImpl> connectors) {
            this.connectors = ConnectorSummaryListCopier.copyFromBuilder(connectors);
        }

        @Override
        public final Builder connectors(Collection<ConnectorSummary> connectors) {
            this.connectors = ConnectorSummaryListCopier.copy(connectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectors(ConnectorSummary ... connectors) {
            this.connectors(Arrays.asList(connectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectors(Consumer<ConnectorSummary.Builder> ... connectors) {
            this.connectors(Stream.of(connectors).map(c -> (ConnectorSummary)((ConnectorSummary.Builder)ConnectorSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListConnectorsV2Response build() {
            return new ListConnectorsV2Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConnectorsV2Response> {
        public Builder nextToken(String var1);

        public Builder connectors(Collection<ConnectorSummary> var1);

        public Builder connectors(ConnectorSummary ... var1);

        public Builder connectors(Consumer<ConnectorSummary.Builder> ... var1);
    }
}

