/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.ConnectorAuthStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JiraCloudDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JiraCloudDetail> {
    private static final SdkField<String> CLOUD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudId").getter(JiraCloudDetail.getter(JiraCloudDetail::cloudId)).setter(JiraCloudDetail.setter(Builder::cloudId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudId").build()}).build();
    private static final SdkField<String> PROJECT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectKey").getter(JiraCloudDetail.getter(JiraCloudDetail::projectKey)).setter(JiraCloudDetail.setter(Builder::projectKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectKey").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(JiraCloudDetail.getter(JiraCloudDetail::domain)).setter(JiraCloudDetail.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> AUTH_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthUrl").getter(JiraCloudDetail.getter(JiraCloudDetail::authUrl)).setter(JiraCloudDetail.setter(Builder::authUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthUrl").build()}).build();
    private static final SdkField<String> AUTH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthStatus").getter(JiraCloudDetail.getter(JiraCloudDetail::authStatusAsString)).setter(JiraCloudDetail.setter(Builder::authStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_ID_FIELD, PROJECT_KEY_FIELD, DOMAIN_FIELD, AUTH_URL_FIELD, AUTH_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JiraCloudDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String cloudId;
    private final String projectKey;
    private final String domain;
    private final String authUrl;
    private final String authStatus;

    private JiraCloudDetail(BuilderImpl builder) {
        this.cloudId = builder.cloudId;
        this.projectKey = builder.projectKey;
        this.domain = builder.domain;
        this.authUrl = builder.authUrl;
        this.authStatus = builder.authStatus;
    }

    public final String cloudId() {
        return this.cloudId;
    }

    public final String projectKey() {
        return this.projectKey;
    }

    public final String domain() {
        return this.domain;
    }

    public final String authUrl() {
        return this.authUrl;
    }

    public final ConnectorAuthStatus authStatus() {
        return ConnectorAuthStatus.fromValue(this.authStatus);
    }

    public final String authStatusAsString() {
        return this.authStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudId());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.authUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.authStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JiraCloudDetail)) {
            return false;
        }
        JiraCloudDetail other = (JiraCloudDetail)obj;
        return Objects.equals(this.cloudId(), other.cloudId()) && Objects.equals(this.projectKey(), other.projectKey()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.authUrl(), other.authUrl()) && Objects.equals(this.authStatusAsString(), other.authStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"JiraCloudDetail").add("CloudId", (Object)this.cloudId()).add("ProjectKey", (Object)this.projectKey()).add("Domain", (Object)this.domain()).add("AuthUrl", (Object)this.authUrl()).add("AuthStatus", (Object)this.authStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudId": {
                return Optional.ofNullable(clazz.cast(this.cloudId()));
            }
            case "ProjectKey": {
                return Optional.ofNullable(clazz.cast(this.projectKey()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "AuthUrl": {
                return Optional.ofNullable(clazz.cast(this.authUrl()));
            }
            case "AuthStatus": {
                return Optional.ofNullable(clazz.cast(this.authStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("CloudId", CLOUD_ID_FIELD);
        map.put("ProjectKey", PROJECT_KEY_FIELD);
        map.put("Domain", DOMAIN_FIELD);
        map.put("AuthUrl", AUTH_URL_FIELD);
        map.put("AuthStatus", AUTH_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JiraCloudDetail, T> g) {
        return obj -> g.apply((JiraCloudDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cloudId;
        private String projectKey;
        private String domain;
        private String authUrl;
        private String authStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(JiraCloudDetail model) {
            this.cloudId(model.cloudId);
            this.projectKey(model.projectKey);
            this.domain(model.domain);
            this.authUrl(model.authUrl);
            this.authStatus(model.authStatus);
        }

        public final String getCloudId() {
            return this.cloudId;
        }

        public final void setCloudId(String cloudId) {
            this.cloudId = cloudId;
        }

        @Override
        public final Builder cloudId(String cloudId) {
            this.cloudId = cloudId;
            return this;
        }

        public final String getProjectKey() {
            return this.projectKey;
        }

        public final void setProjectKey(String projectKey) {
            this.projectKey = projectKey;
        }

        @Override
        public final Builder projectKey(String projectKey) {
            this.projectKey = projectKey;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getAuthUrl() {
            return this.authUrl;
        }

        public final void setAuthUrl(String authUrl) {
            this.authUrl = authUrl;
        }

        @Override
        public final Builder authUrl(String authUrl) {
            this.authUrl = authUrl;
            return this;
        }

        public final String getAuthStatus() {
            return this.authStatus;
        }

        public final void setAuthStatus(String authStatus) {
            this.authStatus = authStatus;
        }

        @Override
        public final Builder authStatus(String authStatus) {
            this.authStatus = authStatus;
            return this;
        }

        @Override
        public final Builder authStatus(ConnectorAuthStatus authStatus) {
            this.authStatus(authStatus == null ? null : authStatus.toString());
            return this;
        }

        public JiraCloudDetail build() {
            return new JiraCloudDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JiraCloudDetail> {
        public Builder cloudId(String var1);

        public Builder projectKey(String var1);

        public Builder domain(String var1);

        public Builder authUrl(String var1);

        public Builder authStatus(String var1);

        public Builder authStatus(ConnectorAuthStatus var1);
    }
}

