/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.SecurityHubFeature;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableOrganizationAdminAccountResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, EnableOrganizationAdminAccountResponse> {
    private static final SdkField<String> ADMIN_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdminAccountId").getter(EnableOrganizationAdminAccountResponse.getter(EnableOrganizationAdminAccountResponse::adminAccountId)).setter(EnableOrganizationAdminAccountResponse.setter(Builder::adminAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminAccountId").build()}).build();
    private static final SdkField<String> FEATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Feature").getter(EnableOrganizationAdminAccountResponse.getter(EnableOrganizationAdminAccountResponse::featureAsString)).setter(EnableOrganizationAdminAccountResponse.setter(Builder::feature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Feature").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_ACCOUNT_ID_FIELD, FEATURE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnableOrganizationAdminAccountResponse.memberNameToFieldInitializer();
    private final String adminAccountId;
    private final String feature;

    private EnableOrganizationAdminAccountResponse(BuilderImpl builder) {
        super(builder);
        this.adminAccountId = builder.adminAccountId;
        this.feature = builder.feature;
    }

    public final String adminAccountId() {
        return this.adminAccountId;
    }

    public final SecurityHubFeature feature() {
        return SecurityHubFeature.fromValue(this.feature);
    }

    public final String featureAsString() {
        return this.feature;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.adminAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableOrganizationAdminAccountResponse)) {
            return false;
        }
        EnableOrganizationAdminAccountResponse other = (EnableOrganizationAdminAccountResponse)((Object)obj);
        return Objects.equals(this.adminAccountId(), other.adminAccountId()) && Objects.equals(this.featureAsString(), other.featureAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EnableOrganizationAdminAccountResponse").add("AdminAccountId", (Object)this.adminAccountId()).add("Feature", (Object)this.featureAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdminAccountId": {
                return Optional.ofNullable(clazz.cast(this.adminAccountId()));
            }
            case "Feature": {
                return Optional.ofNullable(clazz.cast(this.featureAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AdminAccountId", ADMIN_ACCOUNT_ID_FIELD);
        map.put("Feature", FEATURE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableOrganizationAdminAccountResponse, T> g) {
        return obj -> g.apply((EnableOrganizationAdminAccountResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private String adminAccountId;
        private String feature;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableOrganizationAdminAccountResponse model) {
            super(model);
            this.adminAccountId(model.adminAccountId);
            this.feature(model.feature);
        }

        public final String getAdminAccountId() {
            return this.adminAccountId;
        }

        public final void setAdminAccountId(String adminAccountId) {
            this.adminAccountId = adminAccountId;
        }

        @Override
        public final Builder adminAccountId(String adminAccountId) {
            this.adminAccountId = adminAccountId;
            return this;
        }

        public final String getFeature() {
            return this.feature;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        @Override
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public final Builder feature(SecurityHubFeature feature) {
            this.feature(feature == null ? null : feature.toString());
            return this;
        }

        @Override
        public EnableOrganizationAdminAccountResponse build() {
            return new EnableOrganizationAdminAccountResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableOrganizationAdminAccountResponse> {
        public Builder adminAccountId(String var1);

        public Builder feature(String var1);

        public Builder feature(SecurityHubFeature var1);
    }
}

