/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSecurityHubV2Response
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, DescribeSecurityHubV2Response> {
    private static final SdkField<String> HUB_V2_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubV2Arn").getter(DescribeSecurityHubV2Response.getter(DescribeSecurityHubV2Response::hubV2Arn)).setter(DescribeSecurityHubV2Response.setter(Builder::hubV2Arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubV2Arn").build()}).build();
    private static final SdkField<String> SUBSCRIBED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscribedAt").getter(DescribeSecurityHubV2Response.getter(DescribeSecurityHubV2Response::subscribedAt)).setter(DescribeSecurityHubV2Response.setter(Builder::subscribedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscribedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_V2_ARN_FIELD, SUBSCRIBED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeSecurityHubV2Response.memberNameToFieldInitializer();
    private final String hubV2Arn;
    private final String subscribedAt;

    private DescribeSecurityHubV2Response(BuilderImpl builder) {
        super(builder);
        this.hubV2Arn = builder.hubV2Arn;
        this.subscribedAt = builder.subscribedAt;
    }

    public final String hubV2Arn() {
        return this.hubV2Arn;
    }

    public final String subscribedAt() {
        return this.subscribedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hubV2Arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscribedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityHubV2Response)) {
            return false;
        }
        DescribeSecurityHubV2Response other = (DescribeSecurityHubV2Response)((Object)obj);
        return Objects.equals(this.hubV2Arn(), other.hubV2Arn()) && Objects.equals(this.subscribedAt(), other.subscribedAt());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSecurityHubV2Response").add("HubV2Arn", (Object)this.hubV2Arn()).add("SubscribedAt", (Object)this.subscribedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HubV2Arn": {
                return Optional.ofNullable(clazz.cast(this.hubV2Arn()));
            }
            case "SubscribedAt": {
                return Optional.ofNullable(clazz.cast(this.subscribedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("HubV2Arn", HUB_V2_ARN_FIELD);
        map.put("SubscribedAt", SUBSCRIBED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSecurityHubV2Response, T> g) {
        return obj -> g.apply((DescribeSecurityHubV2Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private String hubV2Arn;
        private String subscribedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecurityHubV2Response model) {
            super(model);
            this.hubV2Arn(model.hubV2Arn);
            this.subscribedAt(model.subscribedAt);
        }

        public final String getHubV2Arn() {
            return this.hubV2Arn;
        }

        public final void setHubV2Arn(String hubV2Arn) {
            this.hubV2Arn = hubV2Arn;
        }

        @Override
        public final Builder hubV2Arn(String hubV2Arn) {
            this.hubV2Arn = hubV2Arn;
            return this;
        }

        public final String getSubscribedAt() {
            return this.subscribedAt;
        }

        public final void setSubscribedAt(String subscribedAt) {
            this.subscribedAt = subscribedAt;
        }

        @Override
        public final Builder subscribedAt(String subscribedAt) {
            this.subscribedAt = subscribedAt;
            return this;
        }

        @Override
        public DescribeSecurityHubV2Response build() {
            return new DescribeSecurityHubV2Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSecurityHubV2Response> {
        public Builder hubV2Arn(String var1);

        public Builder subscribedAt(String var1);
    }
}

