/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectorRegistrationsV2Response
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, ConnectorRegistrationsV2Response> {
    private static final SdkField<String> CONNECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorArn").getter(ConnectorRegistrationsV2Response.getter(ConnectorRegistrationsV2Response::connectorArn)).setter(ConnectorRegistrationsV2Response.setter(Builder::connectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorArn").build()}).build();
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorId").getter(ConnectorRegistrationsV2Response.getter(ConnectorRegistrationsV2Response::connectorId)).setter(ConnectorRegistrationsV2Response.setter(Builder::connectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ARN_FIELD, CONNECTOR_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConnectorRegistrationsV2Response.memberNameToFieldInitializer();
    private final String connectorArn;
    private final String connectorId;

    private ConnectorRegistrationsV2Response(BuilderImpl builder) {
        super(builder);
        this.connectorArn = builder.connectorArn;
        this.connectorId = builder.connectorId;
    }

    public final String connectorArn() {
        return this.connectorArn;
    }

    public final String connectorId() {
        return this.connectorId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorRegistrationsV2Response)) {
            return false;
        }
        ConnectorRegistrationsV2Response other = (ConnectorRegistrationsV2Response)((Object)obj);
        return Objects.equals(this.connectorArn(), other.connectorArn()) && Objects.equals(this.connectorId(), other.connectorId());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectorRegistrationsV2Response").add("ConnectorArn", (Object)this.connectorArn()).add("ConnectorId", (Object)this.connectorId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectorArn": {
                return Optional.ofNullable(clazz.cast(this.connectorArn()));
            }
            case "ConnectorId": {
                return Optional.ofNullable(clazz.cast(this.connectorId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ConnectorArn", CONNECTOR_ARN_FIELD);
        map.put("ConnectorId", CONNECTOR_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectorRegistrationsV2Response, T> g) {
        return obj -> g.apply((ConnectorRegistrationsV2Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private String connectorArn;
        private String connectorId;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorRegistrationsV2Response model) {
            super(model);
            this.connectorArn(model.connectorArn);
            this.connectorId(model.connectorId);
        }

        public final String getConnectorArn() {
            return this.connectorArn;
        }

        public final void setConnectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
        }

        @Override
        public final Builder connectorArn(String connectorArn) {
            this.connectorArn = connectorArn;
            return this;
        }

        public final String getConnectorId() {
            return this.connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        @Override
        public ConnectorRegistrationsV2Response build() {
            return new ConnectorRegistrationsV2Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ConnectorRegistrationsV2Response> {
        public Builder connectorArn(String var1);

        public Builder connectorId(String var1);
    }
}

