/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ThreatIntelIndicatorType {
    DOMAIN("DOMAIN"),
    EMAIL_ADDRESS("EMAIL_ADDRESS"),
    HASH_MD5("HASH_MD5"),
    HASH_SHA1("HASH_SHA1"),
    HASH_SHA256("HASH_SHA256"),
    HASH_SHA512("HASH_SHA512"),
    IPV4_ADDRESS("IPV4_ADDRESS"),
    IPV6_ADDRESS("IPV6_ADDRESS"),
    MUTEX("MUTEX"),
    PROCESS("PROCESS"),
    URL("URL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ThreatIntelIndicatorType> VALUE_MAP;
    private final String value;

    private ThreatIntelIndicatorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ThreatIntelIndicatorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ThreatIntelIndicatorType> knownValues() {
        EnumSet<ThreatIntelIndicatorType> knownValues = EnumSet.allOf(ThreatIntelIndicatorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ThreatIntelIndicatorType.class, ThreatIntelIndicatorType::toString);
    }
}

