/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AutomationRulesArnsListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.services.securityhub.model.UnprocessedAutomationRule;
import software.amazon.awssdk.services.securityhub.model.UnprocessedAutomationRulesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteAutomationRulesResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, BatchDeleteAutomationRulesResponse> {
    private static final SdkField<List<String>> PROCESSED_AUTOMATION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProcessedAutomationRules").getter(BatchDeleteAutomationRulesResponse.getter(BatchDeleteAutomationRulesResponse::processedAutomationRules)).setter(BatchDeleteAutomationRulesResponse.setter(Builder::processedAutomationRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedAutomationRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UnprocessedAutomationRule>> UNPROCESSED_AUTOMATION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedAutomationRules").getter(BatchDeleteAutomationRulesResponse.getter(BatchDeleteAutomationRulesResponse::unprocessedAutomationRules)).setter(BatchDeleteAutomationRulesResponse.setter(Builder::unprocessedAutomationRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedAutomationRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnprocessedAutomationRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROCESSED_AUTOMATION_RULES_FIELD, UNPROCESSED_AUTOMATION_RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDeleteAutomationRulesResponse.memberNameToFieldInitializer();
    private final List<String> processedAutomationRules;
    private final List<UnprocessedAutomationRule> unprocessedAutomationRules;

    private BatchDeleteAutomationRulesResponse(BuilderImpl builder) {
        super(builder);
        this.processedAutomationRules = builder.processedAutomationRules;
        this.unprocessedAutomationRules = builder.unprocessedAutomationRules;
    }

    public final boolean hasProcessedAutomationRules() {
        return this.processedAutomationRules != null && !(this.processedAutomationRules instanceof SdkAutoConstructList);
    }

    public final List<String> processedAutomationRules() {
        return this.processedAutomationRules;
    }

    public final boolean hasUnprocessedAutomationRules() {
        return this.unprocessedAutomationRules != null && !(this.unprocessedAutomationRules instanceof SdkAutoConstructList);
    }

    public final List<UnprocessedAutomationRule> unprocessedAutomationRules() {
        return this.unprocessedAutomationRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProcessedAutomationRules() ? this.processedAutomationRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedAutomationRules() ? this.unprocessedAutomationRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteAutomationRulesResponse)) {
            return false;
        }
        BatchDeleteAutomationRulesResponse other = (BatchDeleteAutomationRulesResponse)((Object)obj);
        return this.hasProcessedAutomationRules() == other.hasProcessedAutomationRules() && Objects.equals(this.processedAutomationRules(), other.processedAutomationRules()) && this.hasUnprocessedAutomationRules() == other.hasUnprocessedAutomationRules() && Objects.equals(this.unprocessedAutomationRules(), other.unprocessedAutomationRules());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteAutomationRulesResponse").add("ProcessedAutomationRules", this.hasProcessedAutomationRules() ? this.processedAutomationRules() : null).add("UnprocessedAutomationRules", this.hasUnprocessedAutomationRules() ? this.unprocessedAutomationRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProcessedAutomationRules": {
                return Optional.ofNullable(clazz.cast(this.processedAutomationRules()));
            }
            case "UnprocessedAutomationRules": {
                return Optional.ofNullable(clazz.cast(this.unprocessedAutomationRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProcessedAutomationRules", PROCESSED_AUTOMATION_RULES_FIELD);
        map.put("UnprocessedAutomationRules", UNPROCESSED_AUTOMATION_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteAutomationRulesResponse, T> g) {
        return obj -> g.apply((BatchDeleteAutomationRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<String> processedAutomationRules = DefaultSdkAutoConstructList.getInstance();
        private List<UnprocessedAutomationRule> unprocessedAutomationRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteAutomationRulesResponse model) {
            super(model);
            this.processedAutomationRules(model.processedAutomationRules);
            this.unprocessedAutomationRules(model.unprocessedAutomationRules);
        }

        public final Collection<String> getProcessedAutomationRules() {
            if (this.processedAutomationRules instanceof SdkAutoConstructList) {
                return null;
            }
            return this.processedAutomationRules;
        }

        public final void setProcessedAutomationRules(Collection<String> processedAutomationRules) {
            this.processedAutomationRules = AutomationRulesArnsListCopier.copy(processedAutomationRules);
        }

        @Override
        public final Builder processedAutomationRules(Collection<String> processedAutomationRules) {
            this.processedAutomationRules = AutomationRulesArnsListCopier.copy(processedAutomationRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processedAutomationRules(String ... processedAutomationRules) {
            this.processedAutomationRules(Arrays.asList(processedAutomationRules));
            return this;
        }

        public final List<UnprocessedAutomationRule.Builder> getUnprocessedAutomationRules() {
            List<UnprocessedAutomationRule.Builder> result = UnprocessedAutomationRulesListCopier.copyToBuilder(this.unprocessedAutomationRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedAutomationRules(Collection<UnprocessedAutomationRule.BuilderImpl> unprocessedAutomationRules) {
            this.unprocessedAutomationRules = UnprocessedAutomationRulesListCopier.copyFromBuilder(unprocessedAutomationRules);
        }

        @Override
        public final Builder unprocessedAutomationRules(Collection<UnprocessedAutomationRule> unprocessedAutomationRules) {
            this.unprocessedAutomationRules = UnprocessedAutomationRulesListCopier.copy(unprocessedAutomationRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAutomationRules(UnprocessedAutomationRule ... unprocessedAutomationRules) {
            this.unprocessedAutomationRules(Arrays.asList(unprocessedAutomationRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAutomationRules(Consumer<UnprocessedAutomationRule.Builder> ... unprocessedAutomationRules) {
            this.unprocessedAutomationRules(Stream.of(unprocessedAutomationRules).map(c -> (UnprocessedAutomationRule)((UnprocessedAutomationRule.Builder)UnprocessedAutomationRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDeleteAutomationRulesResponse build() {
            return new BatchDeleteAutomationRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteAutomationRulesResponse> {
        public Builder processedAutomationRules(Collection<String> var1);

        public Builder processedAutomationRules(String ... var1);

        public Builder unprocessedAutomationRules(Collection<UnprocessedAutomationRule> var1);

        public Builder unprocessedAutomationRules(UnprocessedAutomationRule ... var1);

        public Builder unprocessedAutomationRules(Consumer<UnprocessedAutomationRule.Builder> ... var1);
    }
}

