/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsWafRuleGroupRulesDetails;
import software.amazon.awssdk.services.securityhub.model.AwsWafRuleGroupRulesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsWafRuleGroupDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsWafRuleGroupDetails> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(AwsWafRuleGroupDetails.getter(AwsWafRuleGroupDetails::metricName)).setter(AwsWafRuleGroupDetails.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AwsWafRuleGroupDetails.getter(AwsWafRuleGroupDetails::name)).setter(AwsWafRuleGroupDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> RULE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleGroupId").getter(AwsWafRuleGroupDetails.getter(AwsWafRuleGroupDetails::ruleGroupId)).setter(AwsWafRuleGroupDetails.setter(Builder::ruleGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupId").build()}).build();
    private static final SdkField<List<AwsWafRuleGroupRulesDetails>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(AwsWafRuleGroupDetails.getter(AwsWafRuleGroupDetails::rules)).setter(AwsWafRuleGroupDetails.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsWafRuleGroupRulesDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, NAME_FIELD, RULE_GROUP_ID_FIELD, RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsWafRuleGroupDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String metricName;
    private final String name;
    private final String ruleGroupId;
    private final List<AwsWafRuleGroupRulesDetails> rules;

    private AwsWafRuleGroupDetails(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.name = builder.name;
        this.ruleGroupId = builder.ruleGroupId;
        this.rules = builder.rules;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final String name() {
        return this.name;
    }

    public final String ruleGroupId() {
        return this.ruleGroupId;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<AwsWafRuleGroupRulesDetails> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafRuleGroupDetails)) {
            return false;
        }
        AwsWafRuleGroupDetails other = (AwsWafRuleGroupDetails)obj;
        return Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ruleGroupId(), other.ruleGroupId()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules());
    }

    public final String toString() {
        return ToString.builder((String)"AwsWafRuleGroupDetails").add("MetricName", (Object)this.metricName()).add("Name", (Object)this.name()).add("RuleGroupId", (Object)this.ruleGroupId()).add("Rules", this.hasRules() ? this.rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RuleGroupId": {
                return Optional.ofNullable(clazz.cast(this.ruleGroupId()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("RuleGroupId", RULE_GROUP_ID_FIELD);
        map.put("Rules", RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsWafRuleGroupDetails, T> g) {
        return obj -> g.apply((AwsWafRuleGroupDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricName;
        private String name;
        private String ruleGroupId;
        private List<AwsWafRuleGroupRulesDetails> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafRuleGroupDetails model) {
            this.metricName(model.metricName);
            this.name(model.name);
            this.ruleGroupId(model.ruleGroupId);
            this.rules(model.rules);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRuleGroupId() {
            return this.ruleGroupId;
        }

        public final void setRuleGroupId(String ruleGroupId) {
            this.ruleGroupId = ruleGroupId;
        }

        @Override
        public final Builder ruleGroupId(String ruleGroupId) {
            this.ruleGroupId = ruleGroupId;
            return this;
        }

        public final List<AwsWafRuleGroupRulesDetails.Builder> getRules() {
            List<AwsWafRuleGroupRulesDetails.Builder> result = AwsWafRuleGroupRulesListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<AwsWafRuleGroupRulesDetails.BuilderImpl> rules) {
            this.rules = AwsWafRuleGroupRulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<AwsWafRuleGroupRulesDetails> rules) {
            this.rules = AwsWafRuleGroupRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(AwsWafRuleGroupRulesDetails ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<AwsWafRuleGroupRulesDetails.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (AwsWafRuleGroupRulesDetails)((AwsWafRuleGroupRulesDetails.Builder)AwsWafRuleGroupRulesDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AwsWafRuleGroupDetails build() {
            return new AwsWafRuleGroupDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsWafRuleGroupDetails> {
        public Builder metricName(String var1);

        public Builder name(String var1);

        public Builder ruleGroupId(String var1);

        public Builder rules(Collection<AwsWafRuleGroupRulesDetails> var1);

        public Builder rules(AwsWafRuleGroupRulesDetails ... var1);

        public Builder rules(Consumer<AwsWafRuleGroupRulesDetails.Builder> ... var1);
    }
}

