/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsBackupBackupVaultNotificationsDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsBackupBackupVaultNotificationsDetails> {
    private static final SdkField<List<String>> BACKUP_VAULT_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BackupVaultEvents").getter(AwsBackupBackupVaultNotificationsDetails.getter(AwsBackupBackupVaultNotificationsDetails::backupVaultEvents)).setter(AwsBackupBackupVaultNotificationsDetails.setter(Builder::backupVaultEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnsTopicArn").getter(AwsBackupBackupVaultNotificationsDetails.getter(AwsBackupBackupVaultNotificationsDetails::snsTopicArn)).setter(AwsBackupBackupVaultNotificationsDetails.setter(Builder::snsTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_EVENTS_FIELD, SNS_TOPIC_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsBackupBackupVaultNotificationsDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> backupVaultEvents;
    private final String snsTopicArn;

    private AwsBackupBackupVaultNotificationsDetails(BuilderImpl builder) {
        this.backupVaultEvents = builder.backupVaultEvents;
        this.snsTopicArn = builder.snsTopicArn;
    }

    public final boolean hasBackupVaultEvents() {
        return this.backupVaultEvents != null && !(this.backupVaultEvents instanceof SdkAutoConstructList);
    }

    public final List<String> backupVaultEvents() {
        return this.backupVaultEvents;
    }

    public final String snsTopicArn() {
        return this.snsTopicArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBackupVaultEvents() ? this.backupVaultEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsBackupBackupVaultNotificationsDetails)) {
            return false;
        }
        AwsBackupBackupVaultNotificationsDetails other = (AwsBackupBackupVaultNotificationsDetails)obj;
        return this.hasBackupVaultEvents() == other.hasBackupVaultEvents() && Objects.equals(this.backupVaultEvents(), other.backupVaultEvents()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn());
    }

    public final String toString() {
        return ToString.builder((String)"AwsBackupBackupVaultNotificationsDetails").add("BackupVaultEvents", this.hasBackupVaultEvents() ? this.backupVaultEvents() : null).add("SnsTopicArn", (Object)this.snsTopicArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupVaultEvents": {
                return Optional.ofNullable(clazz.cast(this.backupVaultEvents()));
            }
            case "SnsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BackupVaultEvents", BACKUP_VAULT_EVENTS_FIELD);
        map.put("SnsTopicArn", SNS_TOPIC_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsBackupBackupVaultNotificationsDetails, T> g) {
        return obj -> g.apply((AwsBackupBackupVaultNotificationsDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> backupVaultEvents = DefaultSdkAutoConstructList.getInstance();
        private String snsTopicArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsBackupBackupVaultNotificationsDetails model) {
            this.backupVaultEvents(model.backupVaultEvents);
            this.snsTopicArn(model.snsTopicArn);
        }

        public final Collection<String> getBackupVaultEvents() {
            if (this.backupVaultEvents instanceof SdkAutoConstructList) {
                return null;
            }
            return this.backupVaultEvents;
        }

        public final void setBackupVaultEvents(Collection<String> backupVaultEvents) {
            this.backupVaultEvents = NonEmptyStringListCopier.copy(backupVaultEvents);
        }

        @Override
        public final Builder backupVaultEvents(Collection<String> backupVaultEvents) {
            this.backupVaultEvents = NonEmptyStringListCopier.copy(backupVaultEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupVaultEvents(String ... backupVaultEvents) {
            this.backupVaultEvents(Arrays.asList(backupVaultEvents));
            return this;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public AwsBackupBackupVaultNotificationsDetails build() {
            return new AwsBackupBackupVaultNotificationsDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsBackupBackupVaultNotificationsDetails> {
        public Builder backupVaultEvents(Collection<String> var1);

        public Builder backupVaultEvents(String ... var1);

        public Builder snsTopicArn(String var1);
    }
}

