/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.AwsApiGatewayAccessLogSettings;
import software.amazon.awssdk.services.securityhub.model.AwsApiGatewayCanarySettings;
import software.amazon.awssdk.services.securityhub.model.AwsApiGatewayMethodSettings;
import software.amazon.awssdk.services.securityhub.model.AwsApiGatewayMethodSettingsListCopier;
import software.amazon.awssdk.services.securityhub.model.FieldMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsApiGatewayStageDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsApiGatewayStageDetails> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentId").getter(AwsApiGatewayStageDetails.getter(AwsApiGatewayStageDetails::deploymentId)).setter(AwsApiGatewayStageDetails.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentId").build()}).build();
    private static final SdkField<String> CLIENT_CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientCertificateId").getter(AwsApiGatewayStageDetails.getter(AwsApiGatewayStageDetails::clientCertificateId)).setter(AwsApiGatewayStageDetails.setter(Builder::clientCertificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCertificateId").build()}).build();
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StageName").getter(AwsApiGatewayStageDetails.getter(AwsApiGatewayStageDetails::stageName)).setter(AwsApiGatewayStageDetails.setter(Builder::stageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AwsApiGatewayStageDetails.getter(AwsApiGatewayStageDetails::description)).setter(AwsApiGatewayStageDetails.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> CACHE_CLUSTER_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CacheClusterEnabled").getter(AwsApiGatewayStageDetails.getter(AwsApiGatewayStageDetails::cacheClusterEnabled)).setter(AwsApiGatewayStageDetails.setter(Builder::cacheClusterEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterEnabled").build()}).build();
    private static final SdkField<String> CACHE_CLUSTER_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheClusterSize").getter(AwsApiGatewayStageDetails.getter(AwsApiGatewayStageDetails::cacheClusterSize)).setter(AwsApiGatewayStageDetails.setter(Builder::cacheClusterSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterSize").build()}).build();
    private static final SdkField<String> CACHE_CLUSTER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheClusterStatus").getter(AwsApiGatewayStageDetails.getter(AwsApiGatewayStageDetails::cacheClusterStatus)).setter(AwsApiGatewayStageDetails.setter(Builder::cacheClusterStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheClusterStatus").build()}).build();
    private static final SdkField<List<AwsApiGatewayMethodSettings>> METHOD_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MethodSettings").getter(AwsApiGatewayStageDetails.getter(AwsApiGatewayStageDetails::methodSettings)).setter(AwsApiGatewayStageDetails.setter(Builder::methodSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MethodSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsApiGatewayMethodSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Variables").getter(AwsApiGatewayStageDetails.getter(AwsApiGatewayStageDetails::variables)).setter(AwsApiGatewayStageDetails.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Variables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DOCUMENTATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentationVersion").getter(AwsApiGatewayStageDetails.getter(AwsApiGatewayStageDetails::documentationVersion)).setter(AwsApiGatewayStageDetails.setter(Builder::documentationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentationVersion").build()}).build();
    private static final SdkField<AwsApiGatewayAccessLogSettings> ACCESS_LOG_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessLogSettings").getter(AwsApiGatewayStageDetails.getter(AwsApiGatewayStageDetails::accessLogSettings)).setter(AwsApiGatewayStageDetails.setter(Builder::accessLogSettings)).constructor(AwsApiGatewayAccessLogSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessLogSettings").build()}).build();
    private static final SdkField<AwsApiGatewayCanarySettings> CANARY_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CanarySettings").getter(AwsApiGatewayStageDetails.getter(AwsApiGatewayStageDetails::canarySettings)).setter(AwsApiGatewayStageDetails.setter(Builder::canarySettings)).constructor(AwsApiGatewayCanarySettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanarySettings").build()}).build();
    private static final SdkField<Boolean> TRACING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TracingEnabled").getter(AwsApiGatewayStageDetails.getter(AwsApiGatewayStageDetails::tracingEnabled)).setter(AwsApiGatewayStageDetails.setter(Builder::tracingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TracingEnabled").build()}).build();
    private static final SdkField<String> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedDate").getter(AwsApiGatewayStageDetails.getter(AwsApiGatewayStageDetails::createdDate)).setter(AwsApiGatewayStageDetails.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<String> LAST_UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUpdatedDate").getter(AwsApiGatewayStageDetails.getter(AwsApiGatewayStageDetails::lastUpdatedDate)).setter(AwsApiGatewayStageDetails.setter(Builder::lastUpdatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDate").build()}).build();
    private static final SdkField<String> WEB_ACL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebAclArn").getter(AwsApiGatewayStageDetails.getter(AwsApiGatewayStageDetails::webAclArn)).setter(AwsApiGatewayStageDetails.setter(Builder::webAclArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAclArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD, CLIENT_CERTIFICATE_ID_FIELD, STAGE_NAME_FIELD, DESCRIPTION_FIELD, CACHE_CLUSTER_ENABLED_FIELD, CACHE_CLUSTER_SIZE_FIELD, CACHE_CLUSTER_STATUS_FIELD, METHOD_SETTINGS_FIELD, VARIABLES_FIELD, DOCUMENTATION_VERSION_FIELD, ACCESS_LOG_SETTINGS_FIELD, CANARY_SETTINGS_FIELD, TRACING_ENABLED_FIELD, CREATED_DATE_FIELD, LAST_UPDATED_DATE_FIELD, WEB_ACL_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsApiGatewayStageDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String deploymentId;
    private final String clientCertificateId;
    private final String stageName;
    private final String description;
    private final Boolean cacheClusterEnabled;
    private final String cacheClusterSize;
    private final String cacheClusterStatus;
    private final List<AwsApiGatewayMethodSettings> methodSettings;
    private final Map<String, String> variables;
    private final String documentationVersion;
    private final AwsApiGatewayAccessLogSettings accessLogSettings;
    private final AwsApiGatewayCanarySettings canarySettings;
    private final Boolean tracingEnabled;
    private final String createdDate;
    private final String lastUpdatedDate;
    private final String webAclArn;

    private AwsApiGatewayStageDetails(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.clientCertificateId = builder.clientCertificateId;
        this.stageName = builder.stageName;
        this.description = builder.description;
        this.cacheClusterEnabled = builder.cacheClusterEnabled;
        this.cacheClusterSize = builder.cacheClusterSize;
        this.cacheClusterStatus = builder.cacheClusterStatus;
        this.methodSettings = builder.methodSettings;
        this.variables = builder.variables;
        this.documentationVersion = builder.documentationVersion;
        this.accessLogSettings = builder.accessLogSettings;
        this.canarySettings = builder.canarySettings;
        this.tracingEnabled = builder.tracingEnabled;
        this.createdDate = builder.createdDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.webAclArn = builder.webAclArn;
    }

    public final String deploymentId() {
        return this.deploymentId;
    }

    public final String clientCertificateId() {
        return this.clientCertificateId;
    }

    public final String stageName() {
        return this.stageName;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean cacheClusterEnabled() {
        return this.cacheClusterEnabled;
    }

    public final String cacheClusterSize() {
        return this.cacheClusterSize;
    }

    public final String cacheClusterStatus() {
        return this.cacheClusterStatus;
    }

    public final boolean hasMethodSettings() {
        return this.methodSettings != null && !(this.methodSettings instanceof SdkAutoConstructList);
    }

    public final List<AwsApiGatewayMethodSettings> methodSettings() {
        return this.methodSettings;
    }

    public final boolean hasVariables() {
        return this.variables != null && !(this.variables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> variables() {
        return this.variables;
    }

    public final String documentationVersion() {
        return this.documentationVersion;
    }

    public final AwsApiGatewayAccessLogSettings accessLogSettings() {
        return this.accessLogSettings;
    }

    public final AwsApiGatewayCanarySettings canarySettings() {
        return this.canarySettings;
    }

    public final Boolean tracingEnabled() {
        return this.tracingEnabled;
    }

    public final String createdDate() {
        return this.createdDate;
    }

    public final String lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public final String webAclArn() {
        return this.webAclArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheClusterStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMethodSettings() ? this.methodSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariables() ? this.variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.documentationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessLogSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.canarySettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.tracingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.webAclArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsApiGatewayStageDetails)) {
            return false;
        }
        AwsApiGatewayStageDetails other = (AwsApiGatewayStageDetails)obj;
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.clientCertificateId(), other.clientCertificateId()) && Objects.equals(this.stageName(), other.stageName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.cacheClusterEnabled(), other.cacheClusterEnabled()) && Objects.equals(this.cacheClusterSize(), other.cacheClusterSize()) && Objects.equals(this.cacheClusterStatus(), other.cacheClusterStatus()) && this.hasMethodSettings() == other.hasMethodSettings() && Objects.equals(this.methodSettings(), other.methodSettings()) && this.hasVariables() == other.hasVariables() && Objects.equals(this.variables(), other.variables()) && Objects.equals(this.documentationVersion(), other.documentationVersion()) && Objects.equals(this.accessLogSettings(), other.accessLogSettings()) && Objects.equals(this.canarySettings(), other.canarySettings()) && Objects.equals(this.tracingEnabled(), other.tracingEnabled()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate()) && Objects.equals(this.webAclArn(), other.webAclArn());
    }

    public final String toString() {
        return ToString.builder((String)"AwsApiGatewayStageDetails").add("DeploymentId", (Object)this.deploymentId()).add("ClientCertificateId", (Object)this.clientCertificateId()).add("StageName", (Object)this.stageName()).add("Description", (Object)this.description()).add("CacheClusterEnabled", (Object)this.cacheClusterEnabled()).add("CacheClusterSize", (Object)this.cacheClusterSize()).add("CacheClusterStatus", (Object)this.cacheClusterStatus()).add("MethodSettings", this.hasMethodSettings() ? this.methodSettings() : null).add("Variables", this.hasVariables() ? this.variables() : null).add("DocumentationVersion", (Object)this.documentationVersion()).add("AccessLogSettings", (Object)this.accessLogSettings()).add("CanarySettings", (Object)this.canarySettings()).add("TracingEnabled", (Object)this.tracingEnabled()).add("CreatedDate", (Object)this.createdDate()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).add("WebAclArn", (Object)this.webAclArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "ClientCertificateId": {
                return Optional.ofNullable(clazz.cast(this.clientCertificateId()));
            }
            case "StageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CacheClusterEnabled": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterEnabled()));
            }
            case "CacheClusterSize": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterSize()));
            }
            case "CacheClusterStatus": {
                return Optional.ofNullable(clazz.cast(this.cacheClusterStatus()));
            }
            case "MethodSettings": {
                return Optional.ofNullable(clazz.cast(this.methodSettings()));
            }
            case "Variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
            case "DocumentationVersion": {
                return Optional.ofNullable(clazz.cast(this.documentationVersion()));
            }
            case "AccessLogSettings": {
                return Optional.ofNullable(clazz.cast(this.accessLogSettings()));
            }
            case "CanarySettings": {
                return Optional.ofNullable(clazz.cast(this.canarySettings()));
            }
            case "TracingEnabled": {
                return Optional.ofNullable(clazz.cast(this.tracingEnabled()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "LastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
            case "WebAclArn": {
                return Optional.ofNullable(clazz.cast(this.webAclArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DeploymentId", DEPLOYMENT_ID_FIELD);
        map.put("ClientCertificateId", CLIENT_CERTIFICATE_ID_FIELD);
        map.put("StageName", STAGE_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CacheClusterEnabled", CACHE_CLUSTER_ENABLED_FIELD);
        map.put("CacheClusterSize", CACHE_CLUSTER_SIZE_FIELD);
        map.put("CacheClusterStatus", CACHE_CLUSTER_STATUS_FIELD);
        map.put("MethodSettings", METHOD_SETTINGS_FIELD);
        map.put("Variables", VARIABLES_FIELD);
        map.put("DocumentationVersion", DOCUMENTATION_VERSION_FIELD);
        map.put("AccessLogSettings", ACCESS_LOG_SETTINGS_FIELD);
        map.put("CanarySettings", CANARY_SETTINGS_FIELD);
        map.put("TracingEnabled", TRACING_ENABLED_FIELD);
        map.put("CreatedDate", CREATED_DATE_FIELD);
        map.put("LastUpdatedDate", LAST_UPDATED_DATE_FIELD);
        map.put("WebAclArn", WEB_ACL_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsApiGatewayStageDetails, T> g) {
        return obj -> g.apply((AwsApiGatewayStageDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentId;
        private String clientCertificateId;
        private String stageName;
        private String description;
        private Boolean cacheClusterEnabled;
        private String cacheClusterSize;
        private String cacheClusterStatus;
        private List<AwsApiGatewayMethodSettings> methodSettings = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> variables = DefaultSdkAutoConstructMap.getInstance();
        private String documentationVersion;
        private AwsApiGatewayAccessLogSettings accessLogSettings;
        private AwsApiGatewayCanarySettings canarySettings;
        private Boolean tracingEnabled;
        private String createdDate;
        private String lastUpdatedDate;
        private String webAclArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsApiGatewayStageDetails model) {
            this.deploymentId(model.deploymentId);
            this.clientCertificateId(model.clientCertificateId);
            this.stageName(model.stageName);
            this.description(model.description);
            this.cacheClusterEnabled(model.cacheClusterEnabled);
            this.cacheClusterSize(model.cacheClusterSize);
            this.cacheClusterStatus(model.cacheClusterStatus);
            this.methodSettings(model.methodSettings);
            this.variables(model.variables);
            this.documentationVersion(model.documentationVersion);
            this.accessLogSettings(model.accessLogSettings);
            this.canarySettings(model.canarySettings);
            this.tracingEnabled(model.tracingEnabled);
            this.createdDate(model.createdDate);
            this.lastUpdatedDate(model.lastUpdatedDate);
            this.webAclArn(model.webAclArn);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getClientCertificateId() {
            return this.clientCertificateId;
        }

        public final void setClientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
        }

        @Override
        public final Builder clientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        public final String getStageName() {
            return this.stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getCacheClusterEnabled() {
            return this.cacheClusterEnabled;
        }

        public final void setCacheClusterEnabled(Boolean cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
        }

        @Override
        public final Builder cacheClusterEnabled(Boolean cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
            return this;
        }

        public final String getCacheClusterSize() {
            return this.cacheClusterSize;
        }

        public final void setCacheClusterSize(String cacheClusterSize) {
            this.cacheClusterSize = cacheClusterSize;
        }

        @Override
        public final Builder cacheClusterSize(String cacheClusterSize) {
            this.cacheClusterSize = cacheClusterSize;
            return this;
        }

        public final String getCacheClusterStatus() {
            return this.cacheClusterStatus;
        }

        public final void setCacheClusterStatus(String cacheClusterStatus) {
            this.cacheClusterStatus = cacheClusterStatus;
        }

        @Override
        public final Builder cacheClusterStatus(String cacheClusterStatus) {
            this.cacheClusterStatus = cacheClusterStatus;
            return this;
        }

        public final List<AwsApiGatewayMethodSettings.Builder> getMethodSettings() {
            List<AwsApiGatewayMethodSettings.Builder> result = AwsApiGatewayMethodSettingsListCopier.copyToBuilder(this.methodSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMethodSettings(Collection<AwsApiGatewayMethodSettings.BuilderImpl> methodSettings) {
            this.methodSettings = AwsApiGatewayMethodSettingsListCopier.copyFromBuilder(methodSettings);
        }

        @Override
        public final Builder methodSettings(Collection<AwsApiGatewayMethodSettings> methodSettings) {
            this.methodSettings = AwsApiGatewayMethodSettingsListCopier.copy(methodSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder methodSettings(AwsApiGatewayMethodSettings ... methodSettings) {
            this.methodSettings(Arrays.asList(methodSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder methodSettings(Consumer<AwsApiGatewayMethodSettings.Builder> ... methodSettings) {
            this.methodSettings(Stream.of(methodSettings).map(c -> (AwsApiGatewayMethodSettings)((AwsApiGatewayMethodSettings.Builder)AwsApiGatewayMethodSettings.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getVariables() {
            if (this.variables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.variables;
        }

        public final void setVariables(Map<String, String> variables) {
            this.variables = FieldMapCopier.copy(variables);
        }

        @Override
        public final Builder variables(Map<String, String> variables) {
            this.variables = FieldMapCopier.copy(variables);
            return this;
        }

        public final String getDocumentationVersion() {
            return this.documentationVersion;
        }

        public final void setDocumentationVersion(String documentationVersion) {
            this.documentationVersion = documentationVersion;
        }

        @Override
        public final Builder documentationVersion(String documentationVersion) {
            this.documentationVersion = documentationVersion;
            return this;
        }

        public final AwsApiGatewayAccessLogSettings.Builder getAccessLogSettings() {
            return this.accessLogSettings != null ? this.accessLogSettings.toBuilder() : null;
        }

        public final void setAccessLogSettings(AwsApiGatewayAccessLogSettings.BuilderImpl accessLogSettings) {
            this.accessLogSettings = accessLogSettings != null ? accessLogSettings.build() : null;
        }

        @Override
        public final Builder accessLogSettings(AwsApiGatewayAccessLogSettings accessLogSettings) {
            this.accessLogSettings = accessLogSettings;
            return this;
        }

        public final AwsApiGatewayCanarySettings.Builder getCanarySettings() {
            return this.canarySettings != null ? this.canarySettings.toBuilder() : null;
        }

        public final void setCanarySettings(AwsApiGatewayCanarySettings.BuilderImpl canarySettings) {
            this.canarySettings = canarySettings != null ? canarySettings.build() : null;
        }

        @Override
        public final Builder canarySettings(AwsApiGatewayCanarySettings canarySettings) {
            this.canarySettings = canarySettings;
            return this;
        }

        public final Boolean getTracingEnabled() {
            return this.tracingEnabled;
        }

        public final void setTracingEnabled(Boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
        }

        @Override
        public final Builder tracingEnabled(Boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
            return this;
        }

        public final String getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        public final void setLastUpdatedDate(String lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(String lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final String getWebAclArn() {
            return this.webAclArn;
        }

        public final void setWebAclArn(String webAclArn) {
            this.webAclArn = webAclArn;
        }

        @Override
        public final Builder webAclArn(String webAclArn) {
            this.webAclArn = webAclArn;
            return this;
        }

        public AwsApiGatewayStageDetails build() {
            return new AwsApiGatewayStageDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsApiGatewayStageDetails> {
        public Builder deploymentId(String var1);

        public Builder clientCertificateId(String var1);

        public Builder stageName(String var1);

        public Builder description(String var1);

        public Builder cacheClusterEnabled(Boolean var1);

        public Builder cacheClusterSize(String var1);

        public Builder cacheClusterStatus(String var1);

        public Builder methodSettings(Collection<AwsApiGatewayMethodSettings> var1);

        public Builder methodSettings(AwsApiGatewayMethodSettings ... var1);

        public Builder methodSettings(Consumer<AwsApiGatewayMethodSettings.Builder> ... var1);

        public Builder variables(Map<String, String> var1);

        public Builder documentationVersion(String var1);

        public Builder accessLogSettings(AwsApiGatewayAccessLogSettings var1);

        default public Builder accessLogSettings(Consumer<AwsApiGatewayAccessLogSettings.Builder> accessLogSettings) {
            return this.accessLogSettings((AwsApiGatewayAccessLogSettings)((AwsApiGatewayAccessLogSettings.Builder)AwsApiGatewayAccessLogSettings.builder().applyMutation(accessLogSettings)).build());
        }

        public Builder canarySettings(AwsApiGatewayCanarySettings var1);

        default public Builder canarySettings(Consumer<AwsApiGatewayCanarySettings.Builder> canarySettings) {
            return this.canarySettings((AwsApiGatewayCanarySettings)((AwsApiGatewayCanarySettings.Builder)AwsApiGatewayCanarySettings.builder().applyMutation(canarySettings)).build());
        }

        public Builder tracingEnabled(Boolean var1);

        public Builder createdDate(String var1);

        public Builder lastUpdatedDate(String var1);

        public Builder webAclArn(String var1);
    }
}

