/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.NetworkPathComponentDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkHeader
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkHeader> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(NetworkHeader.getter(NetworkHeader::protocol)).setter(NetworkHeader.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<NetworkPathComponentDetails> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(NetworkHeader.getter(NetworkHeader::destination)).setter(NetworkHeader.setter(Builder::destination)).constructor(NetworkPathComponentDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<NetworkPathComponentDetails> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(NetworkHeader.getter(NetworkHeader::source)).setter(NetworkHeader.setter(Builder::source)).constructor(NetworkPathComponentDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD, DESTINATION_FIELD, SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkHeader.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String protocol;
    private final NetworkPathComponentDetails destination;
    private final NetworkPathComponentDetails source;

    private NetworkHeader(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.destination = builder.destination;
        this.source = builder.source;
    }

    public final String protocol() {
        return this.protocol;
    }

    public final NetworkPathComponentDetails destination() {
        return this.destination;
    }

    public final NetworkPathComponentDetails source() {
        return this.source;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkHeader)) {
            return false;
        }
        NetworkHeader other = (NetworkHeader)obj;
        return Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.source(), other.source());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkHeader").add("Protocol", (Object)this.protocol()).add("Destination", (Object)this.destination()).add("Source", (Object)this.source()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Protocol", PROTOCOL_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        map.put("Source", SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkHeader, T> g) {
        return obj -> g.apply((NetworkHeader)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String protocol;
        private NetworkPathComponentDetails destination;
        private NetworkPathComponentDetails source;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkHeader model) {
            this.protocol(model.protocol);
            this.destination(model.destination);
            this.source(model.source);
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final NetworkPathComponentDetails.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(NetworkPathComponentDetails.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(NetworkPathComponentDetails destination) {
            this.destination = destination;
            return this;
        }

        public final NetworkPathComponentDetails.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(NetworkPathComponentDetails.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(NetworkPathComponentDetails source) {
            this.source = source;
            return this;
        }

        public NetworkHeader build() {
            return new NetworkHeader(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkHeader> {
        public Builder protocol(String var1);

        public Builder destination(NetworkPathComponentDetails var1);

        default public Builder destination(Consumer<NetworkPathComponentDetails.Builder> destination) {
            return this.destination((NetworkPathComponentDetails)((NetworkPathComponentDetails.Builder)NetworkPathComponentDetails.builder().applyMutation(destination)).build());
        }

        public Builder source(NetworkPathComponentDetails var1);

        default public Builder source(Consumer<NetworkPathComponentDetails.Builder> source) {
            return this.source((NetworkPathComponentDetails)((NetworkPathComponentDetails.Builder)NetworkPathComponentDetails.builder().applyMutation(source)).build());
        }
    }
}

