/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.FindingAggregator;
import software.amazon.awssdk.services.securityhub.model.FindingAggregatorListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFindingAggregatorsResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, ListFindingAggregatorsResponse> {
    private static final SdkField<List<FindingAggregator>> FINDING_AGGREGATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FindingAggregators").getter(ListFindingAggregatorsResponse.getter(ListFindingAggregatorsResponse::findingAggregators)).setter(ListFindingAggregatorsResponse.setter(Builder::findingAggregators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingAggregators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FindingAggregator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFindingAggregatorsResponse.getter(ListFindingAggregatorsResponse::nextToken)).setter(ListFindingAggregatorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_AGGREGATORS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("FindingAggregators", FINDING_AGGREGATORS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<FindingAggregator> findingAggregators;
    private final String nextToken;

    private ListFindingAggregatorsResponse(BuilderImpl builder) {
        super(builder);
        this.findingAggregators = builder.findingAggregators;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasFindingAggregators() {
        return this.findingAggregators != null && !(this.findingAggregators instanceof SdkAutoConstructList);
    }

    public final List<FindingAggregator> findingAggregators() {
        return this.findingAggregators;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindingAggregators() ? this.findingAggregators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingAggregatorsResponse)) {
            return false;
        }
        ListFindingAggregatorsResponse other = (ListFindingAggregatorsResponse)((Object)obj);
        return this.hasFindingAggregators() == other.hasFindingAggregators() && Objects.equals(this.findingAggregators(), other.findingAggregators()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFindingAggregatorsResponse").add("FindingAggregators", this.hasFindingAggregators() ? this.findingAggregators() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FindingAggregators": {
                return Optional.ofNullable(clazz.cast(this.findingAggregators()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListFindingAggregatorsResponse, T> g) {
        return obj -> g.apply((ListFindingAggregatorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<FindingAggregator> findingAggregators = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFindingAggregatorsResponse model) {
            super(model);
            this.findingAggregators(model.findingAggregators);
            this.nextToken(model.nextToken);
        }

        public final List<FindingAggregator.Builder> getFindingAggregators() {
            List<FindingAggregator.Builder> result = FindingAggregatorListCopier.copyToBuilder(this.findingAggregators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindingAggregators(Collection<FindingAggregator.BuilderImpl> findingAggregators) {
            this.findingAggregators = FindingAggregatorListCopier.copyFromBuilder(findingAggregators);
        }

        @Override
        public final Builder findingAggregators(Collection<FindingAggregator> findingAggregators) {
            this.findingAggregators = FindingAggregatorListCopier.copy(findingAggregators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingAggregators(FindingAggregator ... findingAggregators) {
            this.findingAggregators(Arrays.asList(findingAggregators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingAggregators(Consumer<FindingAggregator.Builder> ... findingAggregators) {
            this.findingAggregators(Stream.of(findingAggregators).map(c -> (FindingAggregator)((FindingAggregator.Builder)FindingAggregator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFindingAggregatorsResponse build() {
            return new ListFindingAggregatorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFindingAggregatorsResponse> {
        public Builder findingAggregators(Collection<FindingAggregator> var1);

        public Builder findingAggregators(FindingAggregator ... var1);

        public Builder findingAggregators(Consumer<FindingAggregator.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

