/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.ActionListCopier;
import software.amazon.awssdk.services.securityhub.model.AutomationRulesAction;
import software.amazon.awssdk.services.securityhub.model.AutomationRulesFindingFilters;
import software.amazon.awssdk.services.securityhub.model.RuleStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomationRulesConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomationRulesConfig> {
    private static final SdkField<String> RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleArn").getter(AutomationRulesConfig.getter(AutomationRulesConfig::ruleArn)).setter(AutomationRulesConfig.setter(Builder::ruleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArn").build()}).build();
    private static final SdkField<String> RULE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleStatus").getter(AutomationRulesConfig.getter(AutomationRulesConfig::ruleStatusAsString)).setter(AutomationRulesConfig.setter(Builder::ruleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleStatus").build()}).build();
    private static final SdkField<Integer> RULE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RuleOrder").getter(AutomationRulesConfig.getter(AutomationRulesConfig::ruleOrder)).setter(AutomationRulesConfig.setter(Builder::ruleOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleOrder").build()}).build();
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleName").getter(AutomationRulesConfig.getter(AutomationRulesConfig::ruleName)).setter(AutomationRulesConfig.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AutomationRulesConfig.getter(AutomationRulesConfig::description)).setter(AutomationRulesConfig.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> IS_TERMINAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsTerminal").getter(AutomationRulesConfig.getter(AutomationRulesConfig::isTerminal)).setter(AutomationRulesConfig.setter(Builder::isTerminal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTerminal").build()}).build();
    private static final SdkField<AutomationRulesFindingFilters> CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Criteria").getter(AutomationRulesConfig.getter(AutomationRulesConfig::criteria)).setter(AutomationRulesConfig.setter(Builder::criteria)).constructor(AutomationRulesFindingFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criteria").build()}).build();
    private static final SdkField<List<AutomationRulesAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(AutomationRulesConfig.getter(AutomationRulesConfig::actions)).setter(AutomationRulesConfig.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomationRulesAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(AutomationRulesConfig.getter(AutomationRulesConfig::createdAt)).setter(AutomationRulesConfig.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(AutomationRulesConfig.getter(AutomationRulesConfig::updatedAt)).setter(AutomationRulesConfig.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(AutomationRulesConfig.getter(AutomationRulesConfig::createdBy)).setter(AutomationRulesConfig.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ARN_FIELD, RULE_STATUS_FIELD, RULE_ORDER_FIELD, RULE_NAME_FIELD, DESCRIPTION_FIELD, IS_TERMINAL_FIELD, CRITERIA_FIELD, ACTIONS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, CREATED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RuleArn", RULE_ARN_FIELD);
            this.put("RuleStatus", RULE_STATUS_FIELD);
            this.put("RuleOrder", RULE_ORDER_FIELD);
            this.put("RuleName", RULE_NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("IsTerminal", IS_TERMINAL_FIELD);
            this.put("Criteria", CRITERIA_FIELD);
            this.put("Actions", ACTIONS_FIELD);
            this.put("CreatedAt", CREATED_AT_FIELD);
            this.put("UpdatedAt", UPDATED_AT_FIELD);
            this.put("CreatedBy", CREATED_BY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String ruleArn;
    private final String ruleStatus;
    private final Integer ruleOrder;
    private final String ruleName;
    private final String description;
    private final Boolean isTerminal;
    private final AutomationRulesFindingFilters criteria;
    private final List<AutomationRulesAction> actions;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String createdBy;

    private AutomationRulesConfig(BuilderImpl builder) {
        this.ruleArn = builder.ruleArn;
        this.ruleStatus = builder.ruleStatus;
        this.ruleOrder = builder.ruleOrder;
        this.ruleName = builder.ruleName;
        this.description = builder.description;
        this.isTerminal = builder.isTerminal;
        this.criteria = builder.criteria;
        this.actions = builder.actions;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.createdBy = builder.createdBy;
    }

    public final String ruleArn() {
        return this.ruleArn;
    }

    public final RuleStatus ruleStatus() {
        return RuleStatus.fromValue(this.ruleStatus);
    }

    public final String ruleStatusAsString() {
        return this.ruleStatus;
    }

    public final Integer ruleOrder() {
        return this.ruleOrder;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean isTerminal() {
        return this.isTerminal;
    }

    public final AutomationRulesFindingFilters criteria() {
        return this.criteria;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<AutomationRulesAction> actions() {
        return this.actions;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTerminal());
        hashCode = 31 * hashCode + Objects.hashCode(this.criteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationRulesConfig)) {
            return false;
        }
        AutomationRulesConfig other = (AutomationRulesConfig)obj;
        return Objects.equals(this.ruleArn(), other.ruleArn()) && Objects.equals(this.ruleStatusAsString(), other.ruleStatusAsString()) && Objects.equals(this.ruleOrder(), other.ruleOrder()) && Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.isTerminal(), other.isTerminal()) && Objects.equals(this.criteria(), other.criteria()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.createdBy(), other.createdBy());
    }

    public final String toString() {
        return ToString.builder((String)"AutomationRulesConfig").add("RuleArn", (Object)this.ruleArn()).add("RuleStatus", (Object)this.ruleStatusAsString()).add("RuleOrder", (Object)this.ruleOrder()).add("RuleName", (Object)this.ruleName()).add("Description", (Object)this.description()).add("IsTerminal", (Object)this.isTerminal()).add("Criteria", (Object)this.criteria()).add("Actions", this.hasActions() ? this.actions() : null).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("CreatedBy", (Object)this.createdBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleArn": {
                return Optional.ofNullable(clazz.cast(this.ruleArn()));
            }
            case "RuleStatus": {
                return Optional.ofNullable(clazz.cast(this.ruleStatusAsString()));
            }
            case "RuleOrder": {
                return Optional.ofNullable(clazz.cast(this.ruleOrder()));
            }
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "IsTerminal": {
                return Optional.ofNullable(clazz.cast(this.isTerminal()));
            }
            case "Criteria": {
                return Optional.ofNullable(clazz.cast(this.criteria()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AutomationRulesConfig, T> g) {
        return obj -> g.apply((AutomationRulesConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleArn;
        private String ruleStatus;
        private Integer ruleOrder;
        private String ruleName;
        private String description;
        private Boolean isTerminal;
        private AutomationRulesFindingFilters criteria;
        private List<AutomationRulesAction> actions = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Instant updatedAt;
        private String createdBy;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationRulesConfig model) {
            this.ruleArn(model.ruleArn);
            this.ruleStatus(model.ruleStatus);
            this.ruleOrder(model.ruleOrder);
            this.ruleName(model.ruleName);
            this.description(model.description);
            this.isTerminal(model.isTerminal);
            this.criteria(model.criteria);
            this.actions(model.actions);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.createdBy(model.createdBy);
        }

        public final String getRuleArn() {
            return this.ruleArn;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final String getRuleStatus() {
            return this.ruleStatus;
        }

        public final void setRuleStatus(String ruleStatus) {
            this.ruleStatus = ruleStatus;
        }

        @Override
        public final Builder ruleStatus(String ruleStatus) {
            this.ruleStatus = ruleStatus;
            return this;
        }

        @Override
        public final Builder ruleStatus(RuleStatus ruleStatus) {
            this.ruleStatus(ruleStatus == null ? null : ruleStatus.toString());
            return this;
        }

        public final Integer getRuleOrder() {
            return this.ruleOrder;
        }

        public final void setRuleOrder(Integer ruleOrder) {
            this.ruleOrder = ruleOrder;
        }

        @Override
        public final Builder ruleOrder(Integer ruleOrder) {
            this.ruleOrder = ruleOrder;
            return this;
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIsTerminal() {
            return this.isTerminal;
        }

        public final void setIsTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
        }

        @Override
        public final Builder isTerminal(Boolean isTerminal) {
            this.isTerminal = isTerminal;
            return this;
        }

        public final AutomationRulesFindingFilters.Builder getCriteria() {
            return this.criteria != null ? this.criteria.toBuilder() : null;
        }

        public final void setCriteria(AutomationRulesFindingFilters.BuilderImpl criteria) {
            this.criteria = criteria != null ? criteria.build() : null;
        }

        @Override
        public final Builder criteria(AutomationRulesFindingFilters criteria) {
            this.criteria = criteria;
            return this;
        }

        public final List<AutomationRulesAction.Builder> getActions() {
            List<AutomationRulesAction.Builder> result = ActionListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<AutomationRulesAction.BuilderImpl> actions) {
            this.actions = ActionListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<AutomationRulesAction> actions) {
            this.actions = ActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(AutomationRulesAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<AutomationRulesAction.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (AutomationRulesAction)((AutomationRulesAction.Builder)AutomationRulesAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public AutomationRulesConfig build() {
            return new AutomationRulesConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomationRulesConfig> {
        public Builder ruleArn(String var1);

        public Builder ruleStatus(String var1);

        public Builder ruleStatus(RuleStatus var1);

        public Builder ruleOrder(Integer var1);

        public Builder ruleName(String var1);

        public Builder description(String var1);

        public Builder isTerminal(Boolean var1);

        public Builder criteria(AutomationRulesFindingFilters var1);

        default public Builder criteria(Consumer<AutomationRulesFindingFilters.Builder> criteria) {
            return this.criteria((AutomationRulesFindingFilters)((AutomationRulesFindingFilters.Builder)AutomationRulesFindingFilters.builder().applyMutation(criteria)).build());
        }

        public Builder actions(Collection<AutomationRulesAction> var1);

        public Builder actions(AutomationRulesAction ... var1);

        public Builder actions(Consumer<AutomationRulesAction.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder createdBy(String var1);
    }
}

