/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsLambdaLayerVersionDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsLambdaLayerVersionDetails> {
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Version").getter(AwsLambdaLayerVersionDetails.getter(AwsLambdaLayerVersionDetails::version)).setter(AwsLambdaLayerVersionDetails.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<List<String>> COMPATIBLE_RUNTIMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CompatibleRuntimes").getter(AwsLambdaLayerVersionDetails.getter(AwsLambdaLayerVersionDetails::compatibleRuntimes)).setter(AwsLambdaLayerVersionDetails.setter(Builder::compatibleRuntimes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompatibleRuntimes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedDate").getter(AwsLambdaLayerVersionDetails.getter(AwsLambdaLayerVersionDetails::createdDate)).setter(AwsLambdaLayerVersionDetails.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, COMPATIBLE_RUNTIMES_FIELD, CREATED_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Version", VERSION_FIELD);
            this.put("CompatibleRuntimes", COMPATIBLE_RUNTIMES_FIELD);
            this.put("CreatedDate", CREATED_DATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Long version;
    private final List<String> compatibleRuntimes;
    private final String createdDate;

    private AwsLambdaLayerVersionDetails(BuilderImpl builder) {
        this.version = builder.version;
        this.compatibleRuntimes = builder.compatibleRuntimes;
        this.createdDate = builder.createdDate;
    }

    public final Long version() {
        return this.version;
    }

    public final boolean hasCompatibleRuntimes() {
        return this.compatibleRuntimes != null && !(this.compatibleRuntimes instanceof SdkAutoConstructList);
    }

    public final List<String> compatibleRuntimes() {
        return this.compatibleRuntimes;
    }

    public final String createdDate() {
        return this.createdDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompatibleRuntimes() ? this.compatibleRuntimes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsLambdaLayerVersionDetails)) {
            return false;
        }
        AwsLambdaLayerVersionDetails other = (AwsLambdaLayerVersionDetails)obj;
        return Objects.equals(this.version(), other.version()) && this.hasCompatibleRuntimes() == other.hasCompatibleRuntimes() && Objects.equals(this.compatibleRuntimes(), other.compatibleRuntimes()) && Objects.equals(this.createdDate(), other.createdDate());
    }

    public final String toString() {
        return ToString.builder((String)"AwsLambdaLayerVersionDetails").add("Version", (Object)this.version()).add("CompatibleRuntimes", this.hasCompatibleRuntimes() ? this.compatibleRuntimes() : null).add("CreatedDate", (Object)this.createdDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "CompatibleRuntimes": {
                return Optional.ofNullable(clazz.cast(this.compatibleRuntimes()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsLambdaLayerVersionDetails, T> g) {
        return obj -> g.apply((AwsLambdaLayerVersionDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long version;
        private List<String> compatibleRuntimes = DefaultSdkAutoConstructList.getInstance();
        private String createdDate;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsLambdaLayerVersionDetails model) {
            this.version(model.version);
            this.compatibleRuntimes(model.compatibleRuntimes);
            this.createdDate(model.createdDate);
        }

        public final Long getVersion() {
            return this.version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final Collection<String> getCompatibleRuntimes() {
            if (this.compatibleRuntimes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.compatibleRuntimes;
        }

        public final void setCompatibleRuntimes(Collection<String> compatibleRuntimes) {
            this.compatibleRuntimes = NonEmptyStringListCopier.copy(compatibleRuntimes);
        }

        @Override
        public final Builder compatibleRuntimes(Collection<String> compatibleRuntimes) {
            this.compatibleRuntimes = NonEmptyStringListCopier.copy(compatibleRuntimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleRuntimes(String ... compatibleRuntimes) {
            this.compatibleRuntimes(Arrays.asList(compatibleRuntimes));
            return this;
        }

        public final String getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public AwsLambdaLayerVersionDetails build() {
            return new AwsLambdaLayerVersionDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsLambdaLayerVersionDetails> {
        public Builder version(Long var1);

        public Builder compatibleRuntimes(Collection<String> var1);

        public Builder compatibleRuntimes(String ... var1);

        public Builder createdDate(String var1);
    }
}

