/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AssociatedStandard;
import software.amazon.awssdk.services.securityhub.model.AssociatedStandardsListCopier;
import software.amazon.awssdk.services.securityhub.model.ComplianceStatus;
import software.amazon.awssdk.services.securityhub.model.RelatedRequirementsListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityControlParameter;
import software.amazon.awssdk.services.securityhub.model.SecurityControlParametersListCopier;
import software.amazon.awssdk.services.securityhub.model.StatusReason;
import software.amazon.awssdk.services.securityhub.model.StatusReasonsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Compliance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Compliance> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Compliance.getter(Compliance::statusAsString)).setter(Compliance.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<String>> RELATED_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RelatedRequirements").getter(Compliance.getter(Compliance::relatedRequirements)).setter(Compliance.setter(Builder::relatedRequirements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedRequirements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StatusReason>> STATUS_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatusReasons").getter(Compliance.getter(Compliance::statusReasons)).setter(Compliance.setter(Builder::statusReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StatusReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SECURITY_CONTROL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityControlId").getter(Compliance.getter(Compliance::securityControlId)).setter(Compliance.setter(Builder::securityControlId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityControlId").build()}).build();
    private static final SdkField<List<AssociatedStandard>> ASSOCIATED_STANDARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedStandards").getter(Compliance.getter(Compliance::associatedStandards)).setter(Compliance.setter(Builder::associatedStandards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedStandards").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociatedStandard::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SecurityControlParameter>> SECURITY_CONTROL_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityControlParameters").getter(Compliance.getter(Compliance::securityControlParameters)).setter(Compliance.setter(Builder::securityControlParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityControlParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityControlParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, RELATED_REQUIREMENTS_FIELD, STATUS_REASONS_FIELD, SECURITY_CONTROL_ID_FIELD, ASSOCIATED_STANDARDS_FIELD, SECURITY_CONTROL_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Status", STATUS_FIELD);
            this.put("RelatedRequirements", RELATED_REQUIREMENTS_FIELD);
            this.put("StatusReasons", STATUS_REASONS_FIELD);
            this.put("SecurityControlId", SECURITY_CONTROL_ID_FIELD);
            this.put("AssociatedStandards", ASSOCIATED_STANDARDS_FIELD);
            this.put("SecurityControlParameters", SECURITY_CONTROL_PARAMETERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String status;
    private final List<String> relatedRequirements;
    private final List<StatusReason> statusReasons;
    private final String securityControlId;
    private final List<AssociatedStandard> associatedStandards;
    private final List<SecurityControlParameter> securityControlParameters;

    private Compliance(BuilderImpl builder) {
        this.status = builder.status;
        this.relatedRequirements = builder.relatedRequirements;
        this.statusReasons = builder.statusReasons;
        this.securityControlId = builder.securityControlId;
        this.associatedStandards = builder.associatedStandards;
        this.securityControlParameters = builder.securityControlParameters;
    }

    public final ComplianceStatus status() {
        return ComplianceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasRelatedRequirements() {
        return this.relatedRequirements != null && !(this.relatedRequirements instanceof SdkAutoConstructList);
    }

    public final List<String> relatedRequirements() {
        return this.relatedRequirements;
    }

    public final boolean hasStatusReasons() {
        return this.statusReasons != null && !(this.statusReasons instanceof SdkAutoConstructList);
    }

    public final List<StatusReason> statusReasons() {
        return this.statusReasons;
    }

    public final String securityControlId() {
        return this.securityControlId;
    }

    public final boolean hasAssociatedStandards() {
        return this.associatedStandards != null && !(this.associatedStandards instanceof SdkAutoConstructList);
    }

    public final List<AssociatedStandard> associatedStandards() {
        return this.associatedStandards;
    }

    public final boolean hasSecurityControlParameters() {
        return this.securityControlParameters != null && !(this.securityControlParameters instanceof SdkAutoConstructList);
    }

    public final List<SecurityControlParameter> securityControlParameters() {
        return this.securityControlParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedRequirements() ? this.relatedRequirements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusReasons() ? this.statusReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.securityControlId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedStandards() ? this.associatedStandards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityControlParameters() ? this.securityControlParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Compliance)) {
            return false;
        }
        Compliance other = (Compliance)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasRelatedRequirements() == other.hasRelatedRequirements() && Objects.equals(this.relatedRequirements(), other.relatedRequirements()) && this.hasStatusReasons() == other.hasStatusReasons() && Objects.equals(this.statusReasons(), other.statusReasons()) && Objects.equals(this.securityControlId(), other.securityControlId()) && this.hasAssociatedStandards() == other.hasAssociatedStandards() && Objects.equals(this.associatedStandards(), other.associatedStandards()) && this.hasSecurityControlParameters() == other.hasSecurityControlParameters() && Objects.equals(this.securityControlParameters(), other.securityControlParameters());
    }

    public final String toString() {
        return ToString.builder((String)"Compliance").add("Status", (Object)this.statusAsString()).add("RelatedRequirements", this.hasRelatedRequirements() ? this.relatedRequirements() : null).add("StatusReasons", this.hasStatusReasons() ? this.statusReasons() : null).add("SecurityControlId", (Object)this.securityControlId()).add("AssociatedStandards", this.hasAssociatedStandards() ? this.associatedStandards() : null).add("SecurityControlParameters", this.hasSecurityControlParameters() ? this.securityControlParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "RelatedRequirements": {
                return Optional.ofNullable(clazz.cast(this.relatedRequirements()));
            }
            case "StatusReasons": {
                return Optional.ofNullable(clazz.cast(this.statusReasons()));
            }
            case "SecurityControlId": {
                return Optional.ofNullable(clazz.cast(this.securityControlId()));
            }
            case "AssociatedStandards": {
                return Optional.ofNullable(clazz.cast(this.associatedStandards()));
            }
            case "SecurityControlParameters": {
                return Optional.ofNullable(clazz.cast(this.securityControlParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Compliance, T> g) {
        return obj -> g.apply((Compliance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private List<String> relatedRequirements = DefaultSdkAutoConstructList.getInstance();
        private List<StatusReason> statusReasons = DefaultSdkAutoConstructList.getInstance();
        private String securityControlId;
        private List<AssociatedStandard> associatedStandards = DefaultSdkAutoConstructList.getInstance();
        private List<SecurityControlParameter> securityControlParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Compliance model) {
            this.status(model.status);
            this.relatedRequirements(model.relatedRequirements);
            this.statusReasons(model.statusReasons);
            this.securityControlId(model.securityControlId);
            this.associatedStandards(model.associatedStandards);
            this.securityControlParameters(model.securityControlParameters);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ComplianceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getRelatedRequirements() {
            if (this.relatedRequirements instanceof SdkAutoConstructList) {
                return null;
            }
            return this.relatedRequirements;
        }

        public final void setRelatedRequirements(Collection<String> relatedRequirements) {
            this.relatedRequirements = RelatedRequirementsListCopier.copy(relatedRequirements);
        }

        @Override
        public final Builder relatedRequirements(Collection<String> relatedRequirements) {
            this.relatedRequirements = RelatedRequirementsListCopier.copy(relatedRequirements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedRequirements(String ... relatedRequirements) {
            this.relatedRequirements(Arrays.asList(relatedRequirements));
            return this;
        }

        public final List<StatusReason.Builder> getStatusReasons() {
            List<StatusReason.Builder> result = StatusReasonsListCopier.copyToBuilder(this.statusReasons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatusReasons(Collection<StatusReason.BuilderImpl> statusReasons) {
            this.statusReasons = StatusReasonsListCopier.copyFromBuilder(statusReasons);
        }

        @Override
        public final Builder statusReasons(Collection<StatusReason> statusReasons) {
            this.statusReasons = StatusReasonsListCopier.copy(statusReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusReasons(StatusReason ... statusReasons) {
            this.statusReasons(Arrays.asList(statusReasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusReasons(Consumer<StatusReason.Builder> ... statusReasons) {
            this.statusReasons(Stream.of(statusReasons).map(c -> (StatusReason)((StatusReason.Builder)StatusReason.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSecurityControlId() {
            return this.securityControlId;
        }

        public final void setSecurityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
        }

        @Override
        public final Builder securityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
            return this;
        }

        public final List<AssociatedStandard.Builder> getAssociatedStandards() {
            List<AssociatedStandard.Builder> result = AssociatedStandardsListCopier.copyToBuilder(this.associatedStandards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociatedStandards(Collection<AssociatedStandard.BuilderImpl> associatedStandards) {
            this.associatedStandards = AssociatedStandardsListCopier.copyFromBuilder(associatedStandards);
        }

        @Override
        public final Builder associatedStandards(Collection<AssociatedStandard> associatedStandards) {
            this.associatedStandards = AssociatedStandardsListCopier.copy(associatedStandards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedStandards(AssociatedStandard ... associatedStandards) {
            this.associatedStandards(Arrays.asList(associatedStandards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedStandards(Consumer<AssociatedStandard.Builder> ... associatedStandards) {
            this.associatedStandards(Stream.of(associatedStandards).map(c -> (AssociatedStandard)((AssociatedStandard.Builder)AssociatedStandard.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SecurityControlParameter.Builder> getSecurityControlParameters() {
            List<SecurityControlParameter.Builder> result = SecurityControlParametersListCopier.copyToBuilder(this.securityControlParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityControlParameters(Collection<SecurityControlParameter.BuilderImpl> securityControlParameters) {
            this.securityControlParameters = SecurityControlParametersListCopier.copyFromBuilder(securityControlParameters);
        }

        @Override
        public final Builder securityControlParameters(Collection<SecurityControlParameter> securityControlParameters) {
            this.securityControlParameters = SecurityControlParametersListCopier.copy(securityControlParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityControlParameters(SecurityControlParameter ... securityControlParameters) {
            this.securityControlParameters(Arrays.asList(securityControlParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityControlParameters(Consumer<SecurityControlParameter.Builder> ... securityControlParameters) {
            this.securityControlParameters(Stream.of(securityControlParameters).map(c -> (SecurityControlParameter)((SecurityControlParameter.Builder)SecurityControlParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Compliance build() {
            return new Compliance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Compliance> {
        public Builder status(String var1);

        public Builder status(ComplianceStatus var1);

        public Builder relatedRequirements(Collection<String> var1);

        public Builder relatedRequirements(String ... var1);

        public Builder statusReasons(Collection<StatusReason> var1);

        public Builder statusReasons(StatusReason ... var1);

        public Builder statusReasons(Consumer<StatusReason.Builder> ... var1);

        public Builder securityControlId(String var1);

        public Builder associatedStandards(Collection<AssociatedStandard> var1);

        public Builder associatedStandards(AssociatedStandard ... var1);

        public Builder associatedStandards(Consumer<AssociatedStandard.Builder> ... var1);

        public Builder securityControlParameters(Collection<SecurityControlParameter> var1);

        public Builder securityControlParameters(SecurityControlParameter ... var1);

        public Builder securityControlParameters(Consumer<SecurityControlParameter.Builder> ... var1);
    }
}

