/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsElbAppCookieStickinessPoliciesCopier;
import software.amazon.awssdk.services.securityhub.model.AwsElbAppCookieStickinessPolicy;
import software.amazon.awssdk.services.securityhub.model.AwsElbLbCookieStickinessPoliciesCopier;
import software.amazon.awssdk.services.securityhub.model.AwsElbLbCookieStickinessPolicy;
import software.amazon.awssdk.services.securityhub.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsElbLoadBalancerPolicies
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsElbLoadBalancerPolicies> {
    private static final SdkField<List<AwsElbAppCookieStickinessPolicy>> APP_COOKIE_STICKINESS_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AppCookieStickinessPolicies").getter(AwsElbLoadBalancerPolicies.getter(AwsElbLoadBalancerPolicies::appCookieStickinessPolicies)).setter(AwsElbLoadBalancerPolicies.setter(Builder::appCookieStickinessPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppCookieStickinessPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsElbAppCookieStickinessPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AwsElbLbCookieStickinessPolicy>> LB_COOKIE_STICKINESS_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LbCookieStickinessPolicies").getter(AwsElbLoadBalancerPolicies.getter(AwsElbLoadBalancerPolicies::lbCookieStickinessPolicies)).setter(AwsElbLoadBalancerPolicies.setter(Builder::lbCookieStickinessPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LbCookieStickinessPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsElbLbCookieStickinessPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OTHER_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OtherPolicies").getter(AwsElbLoadBalancerPolicies.getter(AwsElbLoadBalancerPolicies::otherPolicies)).setter(AwsElbLoadBalancerPolicies.setter(Builder::otherPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_COOKIE_STICKINESS_POLICIES_FIELD, LB_COOKIE_STICKINESS_POLICIES_FIELD, OTHER_POLICIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AppCookieStickinessPolicies", APP_COOKIE_STICKINESS_POLICIES_FIELD);
            this.put("LbCookieStickinessPolicies", LB_COOKIE_STICKINESS_POLICIES_FIELD);
            this.put("OtherPolicies", OTHER_POLICIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<AwsElbAppCookieStickinessPolicy> appCookieStickinessPolicies;
    private final List<AwsElbLbCookieStickinessPolicy> lbCookieStickinessPolicies;
    private final List<String> otherPolicies;

    private AwsElbLoadBalancerPolicies(BuilderImpl builder) {
        this.appCookieStickinessPolicies = builder.appCookieStickinessPolicies;
        this.lbCookieStickinessPolicies = builder.lbCookieStickinessPolicies;
        this.otherPolicies = builder.otherPolicies;
    }

    public final boolean hasAppCookieStickinessPolicies() {
        return this.appCookieStickinessPolicies != null && !(this.appCookieStickinessPolicies instanceof SdkAutoConstructList);
    }

    public final List<AwsElbAppCookieStickinessPolicy> appCookieStickinessPolicies() {
        return this.appCookieStickinessPolicies;
    }

    public final boolean hasLbCookieStickinessPolicies() {
        return this.lbCookieStickinessPolicies != null && !(this.lbCookieStickinessPolicies instanceof SdkAutoConstructList);
    }

    public final List<AwsElbLbCookieStickinessPolicy> lbCookieStickinessPolicies() {
        return this.lbCookieStickinessPolicies;
    }

    public final boolean hasOtherPolicies() {
        return this.otherPolicies != null && !(this.otherPolicies instanceof SdkAutoConstructList);
    }

    public final List<String> otherPolicies() {
        return this.otherPolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppCookieStickinessPolicies() ? this.appCookieStickinessPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLbCookieStickinessPolicies() ? this.lbCookieStickinessPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOtherPolicies() ? this.otherPolicies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElbLoadBalancerPolicies)) {
            return false;
        }
        AwsElbLoadBalancerPolicies other = (AwsElbLoadBalancerPolicies)obj;
        return this.hasAppCookieStickinessPolicies() == other.hasAppCookieStickinessPolicies() && Objects.equals(this.appCookieStickinessPolicies(), other.appCookieStickinessPolicies()) && this.hasLbCookieStickinessPolicies() == other.hasLbCookieStickinessPolicies() && Objects.equals(this.lbCookieStickinessPolicies(), other.lbCookieStickinessPolicies()) && this.hasOtherPolicies() == other.hasOtherPolicies() && Objects.equals(this.otherPolicies(), other.otherPolicies());
    }

    public final String toString() {
        return ToString.builder((String)"AwsElbLoadBalancerPolicies").add("AppCookieStickinessPolicies", this.hasAppCookieStickinessPolicies() ? this.appCookieStickinessPolicies() : null).add("LbCookieStickinessPolicies", this.hasLbCookieStickinessPolicies() ? this.lbCookieStickinessPolicies() : null).add("OtherPolicies", this.hasOtherPolicies() ? this.otherPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppCookieStickinessPolicies": {
                return Optional.ofNullable(clazz.cast(this.appCookieStickinessPolicies()));
            }
            case "LbCookieStickinessPolicies": {
                return Optional.ofNullable(clazz.cast(this.lbCookieStickinessPolicies()));
            }
            case "OtherPolicies": {
                return Optional.ofNullable(clazz.cast(this.otherPolicies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsElbLoadBalancerPolicies, T> g) {
        return obj -> g.apply((AwsElbLoadBalancerPolicies)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AwsElbAppCookieStickinessPolicy> appCookieStickinessPolicies = DefaultSdkAutoConstructList.getInstance();
        private List<AwsElbLbCookieStickinessPolicy> lbCookieStickinessPolicies = DefaultSdkAutoConstructList.getInstance();
        private List<String> otherPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElbLoadBalancerPolicies model) {
            this.appCookieStickinessPolicies(model.appCookieStickinessPolicies);
            this.lbCookieStickinessPolicies(model.lbCookieStickinessPolicies);
            this.otherPolicies(model.otherPolicies);
        }

        public final List<AwsElbAppCookieStickinessPolicy.Builder> getAppCookieStickinessPolicies() {
            List<AwsElbAppCookieStickinessPolicy.Builder> result = AwsElbAppCookieStickinessPoliciesCopier.copyToBuilder(this.appCookieStickinessPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppCookieStickinessPolicies(Collection<AwsElbAppCookieStickinessPolicy.BuilderImpl> appCookieStickinessPolicies) {
            this.appCookieStickinessPolicies = AwsElbAppCookieStickinessPoliciesCopier.copyFromBuilder(appCookieStickinessPolicies);
        }

        @Override
        public final Builder appCookieStickinessPolicies(Collection<AwsElbAppCookieStickinessPolicy> appCookieStickinessPolicies) {
            this.appCookieStickinessPolicies = AwsElbAppCookieStickinessPoliciesCopier.copy(appCookieStickinessPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appCookieStickinessPolicies(AwsElbAppCookieStickinessPolicy ... appCookieStickinessPolicies) {
            this.appCookieStickinessPolicies(Arrays.asList(appCookieStickinessPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appCookieStickinessPolicies(Consumer<AwsElbAppCookieStickinessPolicy.Builder> ... appCookieStickinessPolicies) {
            this.appCookieStickinessPolicies(Stream.of(appCookieStickinessPolicies).map(c -> (AwsElbAppCookieStickinessPolicy)((AwsElbAppCookieStickinessPolicy.Builder)AwsElbAppCookieStickinessPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AwsElbLbCookieStickinessPolicy.Builder> getLbCookieStickinessPolicies() {
            List<AwsElbLbCookieStickinessPolicy.Builder> result = AwsElbLbCookieStickinessPoliciesCopier.copyToBuilder(this.lbCookieStickinessPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLbCookieStickinessPolicies(Collection<AwsElbLbCookieStickinessPolicy.BuilderImpl> lbCookieStickinessPolicies) {
            this.lbCookieStickinessPolicies = AwsElbLbCookieStickinessPoliciesCopier.copyFromBuilder(lbCookieStickinessPolicies);
        }

        @Override
        public final Builder lbCookieStickinessPolicies(Collection<AwsElbLbCookieStickinessPolicy> lbCookieStickinessPolicies) {
            this.lbCookieStickinessPolicies = AwsElbLbCookieStickinessPoliciesCopier.copy(lbCookieStickinessPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lbCookieStickinessPolicies(AwsElbLbCookieStickinessPolicy ... lbCookieStickinessPolicies) {
            this.lbCookieStickinessPolicies(Arrays.asList(lbCookieStickinessPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lbCookieStickinessPolicies(Consumer<AwsElbLbCookieStickinessPolicy.Builder> ... lbCookieStickinessPolicies) {
            this.lbCookieStickinessPolicies(Stream.of(lbCookieStickinessPolicies).map(c -> (AwsElbLbCookieStickinessPolicy)((AwsElbLbCookieStickinessPolicy.Builder)AwsElbLbCookieStickinessPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getOtherPolicies() {
            if (this.otherPolicies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.otherPolicies;
        }

        public final void setOtherPolicies(Collection<String> otherPolicies) {
            this.otherPolicies = StringListCopier.copy(otherPolicies);
        }

        @Override
        public final Builder otherPolicies(Collection<String> otherPolicies) {
            this.otherPolicies = StringListCopier.copy(otherPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder otherPolicies(String ... otherPolicies) {
            this.otherPolicies(Arrays.asList(otherPolicies));
            return this;
        }

        public AwsElbLoadBalancerPolicies build() {
            return new AwsElbLoadBalancerPolicies(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsElbLoadBalancerPolicies> {
        public Builder appCookieStickinessPolicies(Collection<AwsElbAppCookieStickinessPolicy> var1);

        public Builder appCookieStickinessPolicies(AwsElbAppCookieStickinessPolicy ... var1);

        public Builder appCookieStickinessPolicies(Consumer<AwsElbAppCookieStickinessPolicy.Builder> ... var1);

        public Builder lbCookieStickinessPolicies(Collection<AwsElbLbCookieStickinessPolicy> var1);

        public Builder lbCookieStickinessPolicies(AwsElbLbCookieStickinessPolicy ... var1);

        public Builder lbCookieStickinessPolicies(Consumer<AwsElbLbCookieStickinessPolicy.Builder> ... var1);

        public Builder otherPolicies(Collection<String> var1);

        public Builder otherPolicies(String ... var1);
    }
}

