/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.SecurityHubPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Policy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Policy> {
    private static final SdkField<SecurityHubPolicy> SECURITY_HUB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecurityHub").getter(Policy.getter(Policy::securityHub)).setter(Policy.setter(Builder::securityHub)).constructor(SecurityHubPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityHub").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_HUB_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SecurityHub", SECURITY_HUB_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final SecurityHubPolicy securityHub;
    private final Type type;

    private Policy(BuilderImpl builder) {
        this.securityHub = builder.securityHub;
        this.type = builder.type;
    }

    public final SecurityHubPolicy securityHub() {
        return this.securityHub;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.securityHub());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Policy)) {
            return false;
        }
        Policy other = (Policy)obj;
        return Objects.equals(this.securityHub(), other.securityHub());
    }

    public final String toString() {
        return ToString.builder((String)"Policy").add("SecurityHub", (Object)this.securityHub()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityHub": {
                return Optional.ofNullable(clazz.cast(this.securityHub()));
            }
        }
        return Optional.empty();
    }

    public static Policy fromSecurityHub(SecurityHubPolicy securityHub) {
        return (Policy)Policy.builder().securityHub(securityHub).build();
    }

    public static Policy fromSecurityHub(Consumer<SecurityHubPolicy.Builder> securityHub) {
        SecurityHubPolicy.Builder builder = SecurityHubPolicy.builder();
        securityHub.accept(builder);
        return Policy.fromSecurityHub((SecurityHubPolicy)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Policy, T> g) {
        return obj -> g.apply((Policy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SECURITY_HUB,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SecurityHubPolicy securityHub;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Policy model) {
            this.securityHub(model.securityHub);
        }

        public final SecurityHubPolicy.Builder getSecurityHub() {
            return this.securityHub != null ? this.securityHub.toBuilder() : null;
        }

        public final void setSecurityHub(SecurityHubPolicy.BuilderImpl securityHub) {
            SecurityHubPolicy oldValue = this.securityHub;
            this.securityHub = securityHub != null ? securityHub.build() : null;
            this.handleUnionValueChange(Type.SECURITY_HUB, oldValue, this.securityHub);
        }

        @Override
        public final Builder securityHub(SecurityHubPolicy securityHub) {
            SecurityHubPolicy oldValue = this.securityHub;
            this.securityHub = securityHub;
            this.handleUnionValueChange(Type.SECURITY_HUB, oldValue, this.securityHub);
            return this;
        }

        public Policy build() {
            return new Policy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Policy> {
        public Builder securityHub(SecurityHubPolicy var1);

        default public Builder securityHub(Consumer<SecurityHubPolicy.Builder> securityHub) {
            return this.securityHub((SecurityHubPolicy)((SecurityHubPolicy.Builder)SecurityHubPolicy.builder().applyMutation(securityHub)).build());
        }
    }
}

