/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsEc2ClientVpnEndpointAuthenticationOptionsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEc2ClientVpnEndpointAuthenticationOptionsListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsEc2ClientVpnEndpointClientConnectOptionsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEc2ClientVpnEndpointConnectionLogOptionsDetails;
import software.amazon.awssdk.services.securityhub.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2ClientVpnEndpointDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2ClientVpnEndpointDetails> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientVpnEndpointId").getter(AwsEc2ClientVpnEndpointDetails.getter(AwsEc2ClientVpnEndpointDetails::clientVpnEndpointId)).setter(AwsEc2ClientVpnEndpointDetails.setter(Builder::clientVpnEndpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AwsEc2ClientVpnEndpointDetails.getter(AwsEc2ClientVpnEndpointDetails::description)).setter(AwsEc2ClientVpnEndpointDetails.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CLIENT_CIDR_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientCidrBlock").getter(AwsEc2ClientVpnEndpointDetails.getter(AwsEc2ClientVpnEndpointDetails::clientCidrBlock)).setter(AwsEc2ClientVpnEndpointDetails.setter(Builder::clientCidrBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCidrBlock").build()}).build();
    private static final SdkField<List<String>> DNS_SERVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DnsServer").getter(AwsEc2ClientVpnEndpointDetails.getter(AwsEc2ClientVpnEndpointDetails::dnsServer)).setter(AwsEc2ClientVpnEndpointDetails.setter(Builder::dnsServer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsServer").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SPLIT_TUNNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SplitTunnel").getter(AwsEc2ClientVpnEndpointDetails.getter(AwsEc2ClientVpnEndpointDetails::splitTunnel)).setter(AwsEc2ClientVpnEndpointDetails.setter(Builder::splitTunnel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SplitTunnel").build()}).build();
    private static final SdkField<String> TRANSPORT_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransportProtocol").getter(AwsEc2ClientVpnEndpointDetails.getter(AwsEc2ClientVpnEndpointDetails::transportProtocol)).setter(AwsEc2ClientVpnEndpointDetails.setter(Builder::transportProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransportProtocol").build()}).build();
    private static final SdkField<Integer> VPN_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VpnPort").getter(AwsEc2ClientVpnEndpointDetails.getter(AwsEc2ClientVpnEndpointDetails::vpnPort)).setter(AwsEc2ClientVpnEndpointDetails.setter(Builder::vpnPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnPort").build()}).build();
    private static final SdkField<String> SERVER_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerCertificateArn").getter(AwsEc2ClientVpnEndpointDetails.getter(AwsEc2ClientVpnEndpointDetails::serverCertificateArn)).setter(AwsEc2ClientVpnEndpointDetails.setter(Builder::serverCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificateArn").build()}).build();
    private static final SdkField<List<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails>> AUTHENTICATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthenticationOptions").getter(AwsEc2ClientVpnEndpointDetails.getter(AwsEc2ClientVpnEndpointDetails::authenticationOptions)).setter(AwsEc2ClientVpnEndpointDetails.setter(Builder::authenticationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEc2ClientVpnEndpointAuthenticationOptionsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AwsEc2ClientVpnEndpointConnectionLogOptionsDetails> CONNECTION_LOG_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionLogOptions").getter(AwsEc2ClientVpnEndpointDetails.getter(AwsEc2ClientVpnEndpointDetails::connectionLogOptions)).setter(AwsEc2ClientVpnEndpointDetails.setter(Builder::connectionLogOptions)).constructor(AwsEc2ClientVpnEndpointConnectionLogOptionsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionLogOptions").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_ID_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIdSet").getter(AwsEc2ClientVpnEndpointDetails.getter(AwsEc2ClientVpnEndpointDetails::securityGroupIdSet)).setter(AwsEc2ClientVpnEndpointDetails.setter(Builder::securityGroupIdSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIdSet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(AwsEc2ClientVpnEndpointDetails.getter(AwsEc2ClientVpnEndpointDetails::vpcId)).setter(AwsEc2ClientVpnEndpointDetails.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> SELF_SERVICE_PORTAL_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelfServicePortalUrl").getter(AwsEc2ClientVpnEndpointDetails.getter(AwsEc2ClientVpnEndpointDetails::selfServicePortalUrl)).setter(AwsEc2ClientVpnEndpointDetails.setter(Builder::selfServicePortalUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfServicePortalUrl").build()}).build();
    private static final SdkField<AwsEc2ClientVpnEndpointClientConnectOptionsDetails> CLIENT_CONNECT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClientConnectOptions").getter(AwsEc2ClientVpnEndpointDetails.getter(AwsEc2ClientVpnEndpointDetails::clientConnectOptions)).setter(AwsEc2ClientVpnEndpointDetails.setter(Builder::clientConnectOptions)).constructor(AwsEc2ClientVpnEndpointClientConnectOptionsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientConnectOptions").build()}).build();
    private static final SdkField<Integer> SESSION_TIMEOUT_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SessionTimeoutHours").getter(AwsEc2ClientVpnEndpointDetails.getter(AwsEc2ClientVpnEndpointDetails::sessionTimeoutHours)).setter(AwsEc2ClientVpnEndpointDetails.setter(Builder::sessionTimeoutHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionTimeoutHours").build()}).build();
    private static final SdkField<AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails> CLIENT_LOGIN_BANNER_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClientLoginBannerOptions").getter(AwsEc2ClientVpnEndpointDetails.getter(AwsEc2ClientVpnEndpointDetails::clientLoginBannerOptions)).setter(AwsEc2ClientVpnEndpointDetails.setter(Builder::clientLoginBannerOptions)).constructor(AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientLoginBannerOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD, DESCRIPTION_FIELD, CLIENT_CIDR_BLOCK_FIELD, DNS_SERVER_FIELD, SPLIT_TUNNEL_FIELD, TRANSPORT_PROTOCOL_FIELD, VPN_PORT_FIELD, SERVER_CERTIFICATE_ARN_FIELD, AUTHENTICATION_OPTIONS_FIELD, CONNECTION_LOG_OPTIONS_FIELD, SECURITY_GROUP_ID_SET_FIELD, VPC_ID_FIELD, SELF_SERVICE_PORTAL_URL_FIELD, CLIENT_CONNECT_OPTIONS_FIELD, SESSION_TIMEOUT_HOURS_FIELD, CLIENT_LOGIN_BANNER_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clientVpnEndpointId;
    private final String description;
    private final String clientCidrBlock;
    private final List<String> dnsServer;
    private final Boolean splitTunnel;
    private final String transportProtocol;
    private final Integer vpnPort;
    private final String serverCertificateArn;
    private final List<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails> authenticationOptions;
    private final AwsEc2ClientVpnEndpointConnectionLogOptionsDetails connectionLogOptions;
    private final List<String> securityGroupIdSet;
    private final String vpcId;
    private final String selfServicePortalUrl;
    private final AwsEc2ClientVpnEndpointClientConnectOptionsDetails clientConnectOptions;
    private final Integer sessionTimeoutHours;
    private final AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails clientLoginBannerOptions;

    private AwsEc2ClientVpnEndpointDetails(BuilderImpl builder) {
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.description = builder.description;
        this.clientCidrBlock = builder.clientCidrBlock;
        this.dnsServer = builder.dnsServer;
        this.splitTunnel = builder.splitTunnel;
        this.transportProtocol = builder.transportProtocol;
        this.vpnPort = builder.vpnPort;
        this.serverCertificateArn = builder.serverCertificateArn;
        this.authenticationOptions = builder.authenticationOptions;
        this.connectionLogOptions = builder.connectionLogOptions;
        this.securityGroupIdSet = builder.securityGroupIdSet;
        this.vpcId = builder.vpcId;
        this.selfServicePortalUrl = builder.selfServicePortalUrl;
        this.clientConnectOptions = builder.clientConnectOptions;
        this.sessionTimeoutHours = builder.sessionTimeoutHours;
        this.clientLoginBannerOptions = builder.clientLoginBannerOptions;
    }

    public final String clientVpnEndpointId() {
        return this.clientVpnEndpointId;
    }

    public final String description() {
        return this.description;
    }

    public final String clientCidrBlock() {
        return this.clientCidrBlock;
    }

    public final boolean hasDnsServer() {
        return this.dnsServer != null && !(this.dnsServer instanceof SdkAutoConstructList);
    }

    public final List<String> dnsServer() {
        return this.dnsServer;
    }

    public final Boolean splitTunnel() {
        return this.splitTunnel;
    }

    public final String transportProtocol() {
        return this.transportProtocol;
    }

    public final Integer vpnPort() {
        return this.vpnPort;
    }

    public final String serverCertificateArn() {
        return this.serverCertificateArn;
    }

    public final boolean hasAuthenticationOptions() {
        return this.authenticationOptions != null && !(this.authenticationOptions instanceof SdkAutoConstructList);
    }

    public final List<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails> authenticationOptions() {
        return this.authenticationOptions;
    }

    public final AwsEc2ClientVpnEndpointConnectionLogOptionsDetails connectionLogOptions() {
        return this.connectionLogOptions;
    }

    public final boolean hasSecurityGroupIdSet() {
        return this.securityGroupIdSet != null && !(this.securityGroupIdSet instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIdSet() {
        return this.securityGroupIdSet;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String selfServicePortalUrl() {
        return this.selfServicePortalUrl;
    }

    public final AwsEc2ClientVpnEndpointClientConnectOptionsDetails clientConnectOptions() {
        return this.clientConnectOptions;
    }

    public final Integer sessionTimeoutHours() {
        return this.sessionTimeoutHours;
    }

    public final AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails clientLoginBannerOptions() {
        return this.clientLoginBannerOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDnsServer() ? this.dnsServer() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.splitTunnel());
        hashCode = 31 * hashCode + Objects.hashCode(this.transportProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthenticationOptions() ? this.authenticationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionLogOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIdSet() ? this.securityGroupIdSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.selfServicePortalUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientConnectOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionTimeoutHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientLoginBannerOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2ClientVpnEndpointDetails)) {
            return false;
        }
        AwsEc2ClientVpnEndpointDetails other = (AwsEc2ClientVpnEndpointDetails)obj;
        return Objects.equals(this.clientVpnEndpointId(), other.clientVpnEndpointId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientCidrBlock(), other.clientCidrBlock()) && this.hasDnsServer() == other.hasDnsServer() && Objects.equals(this.dnsServer(), other.dnsServer()) && Objects.equals(this.splitTunnel(), other.splitTunnel()) && Objects.equals(this.transportProtocol(), other.transportProtocol()) && Objects.equals(this.vpnPort(), other.vpnPort()) && Objects.equals(this.serverCertificateArn(), other.serverCertificateArn()) && this.hasAuthenticationOptions() == other.hasAuthenticationOptions() && Objects.equals(this.authenticationOptions(), other.authenticationOptions()) && Objects.equals(this.connectionLogOptions(), other.connectionLogOptions()) && this.hasSecurityGroupIdSet() == other.hasSecurityGroupIdSet() && Objects.equals(this.securityGroupIdSet(), other.securityGroupIdSet()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.selfServicePortalUrl(), other.selfServicePortalUrl()) && Objects.equals(this.clientConnectOptions(), other.clientConnectOptions()) && Objects.equals(this.sessionTimeoutHours(), other.sessionTimeoutHours()) && Objects.equals(this.clientLoginBannerOptions(), other.clientLoginBannerOptions());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEc2ClientVpnEndpointDetails").add("ClientVpnEndpointId", (Object)this.clientVpnEndpointId()).add("Description", (Object)this.description()).add("ClientCidrBlock", (Object)this.clientCidrBlock()).add("DnsServer", this.hasDnsServer() ? this.dnsServer() : null).add("SplitTunnel", (Object)this.splitTunnel()).add("TransportProtocol", (Object)this.transportProtocol()).add("VpnPort", (Object)this.vpnPort()).add("ServerCertificateArn", (Object)this.serverCertificateArn()).add("AuthenticationOptions", this.hasAuthenticationOptions() ? this.authenticationOptions() : null).add("ConnectionLogOptions", (Object)this.connectionLogOptions()).add("SecurityGroupIdSet", this.hasSecurityGroupIdSet() ? this.securityGroupIdSet() : null).add("VpcId", (Object)this.vpcId()).add("SelfServicePortalUrl", (Object)this.selfServicePortalUrl()).add("ClientConnectOptions", (Object)this.clientConnectOptions()).add("SessionTimeoutHours", (Object)this.sessionTimeoutHours()).add("ClientLoginBannerOptions", (Object)this.clientLoginBannerOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientVpnEndpointId": {
                return Optional.ofNullable(clazz.cast(this.clientVpnEndpointId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ClientCidrBlock": {
                return Optional.ofNullable(clazz.cast(this.clientCidrBlock()));
            }
            case "DnsServer": {
                return Optional.ofNullable(clazz.cast(this.dnsServer()));
            }
            case "SplitTunnel": {
                return Optional.ofNullable(clazz.cast(this.splitTunnel()));
            }
            case "TransportProtocol": {
                return Optional.ofNullable(clazz.cast(this.transportProtocol()));
            }
            case "VpnPort": {
                return Optional.ofNullable(clazz.cast(this.vpnPort()));
            }
            case "ServerCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.serverCertificateArn()));
            }
            case "AuthenticationOptions": {
                return Optional.ofNullable(clazz.cast(this.authenticationOptions()));
            }
            case "ConnectionLogOptions": {
                return Optional.ofNullable(clazz.cast(this.connectionLogOptions()));
            }
            case "SecurityGroupIdSet": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIdSet()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SelfServicePortalUrl": {
                return Optional.ofNullable(clazz.cast(this.selfServicePortalUrl()));
            }
            case "ClientConnectOptions": {
                return Optional.ofNullable(clazz.cast(this.clientConnectOptions()));
            }
            case "SessionTimeoutHours": {
                return Optional.ofNullable(clazz.cast(this.sessionTimeoutHours()));
            }
            case "ClientLoginBannerOptions": {
                return Optional.ofNullable(clazz.cast(this.clientLoginBannerOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2ClientVpnEndpointDetails, T> g) {
        return obj -> g.apply((AwsEc2ClientVpnEndpointDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientVpnEndpointId;
        private String description;
        private String clientCidrBlock;
        private List<String> dnsServer = DefaultSdkAutoConstructList.getInstance();
        private Boolean splitTunnel;
        private String transportProtocol;
        private Integer vpnPort;
        private String serverCertificateArn;
        private List<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails> authenticationOptions = DefaultSdkAutoConstructList.getInstance();
        private AwsEc2ClientVpnEndpointConnectionLogOptionsDetails connectionLogOptions;
        private List<String> securityGroupIdSet = DefaultSdkAutoConstructList.getInstance();
        private String vpcId;
        private String selfServicePortalUrl;
        private AwsEc2ClientVpnEndpointClientConnectOptionsDetails clientConnectOptions;
        private Integer sessionTimeoutHours;
        private AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails clientLoginBannerOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2ClientVpnEndpointDetails model) {
            this.clientVpnEndpointId(model.clientVpnEndpointId);
            this.description(model.description);
            this.clientCidrBlock(model.clientCidrBlock);
            this.dnsServer(model.dnsServer);
            this.splitTunnel(model.splitTunnel);
            this.transportProtocol(model.transportProtocol);
            this.vpnPort(model.vpnPort);
            this.serverCertificateArn(model.serverCertificateArn);
            this.authenticationOptions(model.authenticationOptions);
            this.connectionLogOptions(model.connectionLogOptions);
            this.securityGroupIdSet(model.securityGroupIdSet);
            this.vpcId(model.vpcId);
            this.selfServicePortalUrl(model.selfServicePortalUrl);
            this.clientConnectOptions(model.clientConnectOptions);
            this.sessionTimeoutHours(model.sessionTimeoutHours);
            this.clientLoginBannerOptions(model.clientLoginBannerOptions);
        }

        public final String getClientVpnEndpointId() {
            return this.clientVpnEndpointId;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientCidrBlock() {
            return this.clientCidrBlock;
        }

        public final void setClientCidrBlock(String clientCidrBlock) {
            this.clientCidrBlock = clientCidrBlock;
        }

        @Override
        public final Builder clientCidrBlock(String clientCidrBlock) {
            this.clientCidrBlock = clientCidrBlock;
            return this;
        }

        public final Collection<String> getDnsServer() {
            if (this.dnsServer instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dnsServer;
        }

        public final void setDnsServer(Collection<String> dnsServer) {
            this.dnsServer = StringListCopier.copy(dnsServer);
        }

        @Override
        public final Builder dnsServer(Collection<String> dnsServer) {
            this.dnsServer = StringListCopier.copy(dnsServer);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsServer(String ... dnsServer) {
            this.dnsServer(Arrays.asList(dnsServer));
            return this;
        }

        public final Boolean getSplitTunnel() {
            return this.splitTunnel;
        }

        public final void setSplitTunnel(Boolean splitTunnel) {
            this.splitTunnel = splitTunnel;
        }

        @Override
        public final Builder splitTunnel(Boolean splitTunnel) {
            this.splitTunnel = splitTunnel;
            return this;
        }

        public final String getTransportProtocol() {
            return this.transportProtocol;
        }

        public final void setTransportProtocol(String transportProtocol) {
            this.transportProtocol = transportProtocol;
        }

        @Override
        public final Builder transportProtocol(String transportProtocol) {
            this.transportProtocol = transportProtocol;
            return this;
        }

        public final Integer getVpnPort() {
            return this.vpnPort;
        }

        public final void setVpnPort(Integer vpnPort) {
            this.vpnPort = vpnPort;
        }

        @Override
        public final Builder vpnPort(Integer vpnPort) {
            this.vpnPort = vpnPort;
            return this;
        }

        public final String getServerCertificateArn() {
            return this.serverCertificateArn;
        }

        public final void setServerCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
        }

        @Override
        public final Builder serverCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
            return this;
        }

        public final List<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails.Builder> getAuthenticationOptions() {
            List<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails.Builder> result = AwsEc2ClientVpnEndpointAuthenticationOptionsListCopier.copyToBuilder(this.authenticationOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthenticationOptions(Collection<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails.BuilderImpl> authenticationOptions) {
            this.authenticationOptions = AwsEc2ClientVpnEndpointAuthenticationOptionsListCopier.copyFromBuilder(authenticationOptions);
        }

        @Override
        public final Builder authenticationOptions(Collection<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails> authenticationOptions) {
            this.authenticationOptions = AwsEc2ClientVpnEndpointAuthenticationOptionsListCopier.copy(authenticationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationOptions(AwsEc2ClientVpnEndpointAuthenticationOptionsDetails ... authenticationOptions) {
            this.authenticationOptions(Arrays.asList(authenticationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationOptions(Consumer<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails.Builder> ... authenticationOptions) {
            this.authenticationOptions(Stream.of(authenticationOptions).map(c -> (AwsEc2ClientVpnEndpointAuthenticationOptionsDetails)((AwsEc2ClientVpnEndpointAuthenticationOptionsDetails.Builder)AwsEc2ClientVpnEndpointAuthenticationOptionsDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AwsEc2ClientVpnEndpointConnectionLogOptionsDetails.Builder getConnectionLogOptions() {
            return this.connectionLogOptions != null ? this.connectionLogOptions.toBuilder() : null;
        }

        public final void setConnectionLogOptions(AwsEc2ClientVpnEndpointConnectionLogOptionsDetails.BuilderImpl connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions != null ? connectionLogOptions.build() : null;
        }

        @Override
        public final Builder connectionLogOptions(AwsEc2ClientVpnEndpointConnectionLogOptionsDetails connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions;
            return this;
        }

        public final Collection<String> getSecurityGroupIdSet() {
            if (this.securityGroupIdSet instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIdSet;
        }

        public final void setSecurityGroupIdSet(Collection<String> securityGroupIdSet) {
            this.securityGroupIdSet = StringListCopier.copy(securityGroupIdSet);
        }

        @Override
        public final Builder securityGroupIdSet(Collection<String> securityGroupIdSet) {
            this.securityGroupIdSet = StringListCopier.copy(securityGroupIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIdSet(String ... securityGroupIdSet) {
            this.securityGroupIdSet(Arrays.asList(securityGroupIdSet));
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getSelfServicePortalUrl() {
            return this.selfServicePortalUrl;
        }

        public final void setSelfServicePortalUrl(String selfServicePortalUrl) {
            this.selfServicePortalUrl = selfServicePortalUrl;
        }

        @Override
        public final Builder selfServicePortalUrl(String selfServicePortalUrl) {
            this.selfServicePortalUrl = selfServicePortalUrl;
            return this;
        }

        public final AwsEc2ClientVpnEndpointClientConnectOptionsDetails.Builder getClientConnectOptions() {
            return this.clientConnectOptions != null ? this.clientConnectOptions.toBuilder() : null;
        }

        public final void setClientConnectOptions(AwsEc2ClientVpnEndpointClientConnectOptionsDetails.BuilderImpl clientConnectOptions) {
            this.clientConnectOptions = clientConnectOptions != null ? clientConnectOptions.build() : null;
        }

        @Override
        public final Builder clientConnectOptions(AwsEc2ClientVpnEndpointClientConnectOptionsDetails clientConnectOptions) {
            this.clientConnectOptions = clientConnectOptions;
            return this;
        }

        public final Integer getSessionTimeoutHours() {
            return this.sessionTimeoutHours;
        }

        public final void setSessionTimeoutHours(Integer sessionTimeoutHours) {
            this.sessionTimeoutHours = sessionTimeoutHours;
        }

        @Override
        public final Builder sessionTimeoutHours(Integer sessionTimeoutHours) {
            this.sessionTimeoutHours = sessionTimeoutHours;
            return this;
        }

        public final AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails.Builder getClientLoginBannerOptions() {
            return this.clientLoginBannerOptions != null ? this.clientLoginBannerOptions.toBuilder() : null;
        }

        public final void setClientLoginBannerOptions(AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails.BuilderImpl clientLoginBannerOptions) {
            this.clientLoginBannerOptions = clientLoginBannerOptions != null ? clientLoginBannerOptions.build() : null;
        }

        @Override
        public final Builder clientLoginBannerOptions(AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails clientLoginBannerOptions) {
            this.clientLoginBannerOptions = clientLoginBannerOptions;
            return this;
        }

        public AwsEc2ClientVpnEndpointDetails build() {
            return new AwsEc2ClientVpnEndpointDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2ClientVpnEndpointDetails> {
        public Builder clientVpnEndpointId(String var1);

        public Builder description(String var1);

        public Builder clientCidrBlock(String var1);

        public Builder dnsServer(Collection<String> var1);

        public Builder dnsServer(String ... var1);

        public Builder splitTunnel(Boolean var1);

        public Builder transportProtocol(String var1);

        public Builder vpnPort(Integer var1);

        public Builder serverCertificateArn(String var1);

        public Builder authenticationOptions(Collection<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails> var1);

        public Builder authenticationOptions(AwsEc2ClientVpnEndpointAuthenticationOptionsDetails ... var1);

        public Builder authenticationOptions(Consumer<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails.Builder> ... var1);

        public Builder connectionLogOptions(AwsEc2ClientVpnEndpointConnectionLogOptionsDetails var1);

        default public Builder connectionLogOptions(Consumer<AwsEc2ClientVpnEndpointConnectionLogOptionsDetails.Builder> connectionLogOptions) {
            return this.connectionLogOptions((AwsEc2ClientVpnEndpointConnectionLogOptionsDetails)((AwsEc2ClientVpnEndpointConnectionLogOptionsDetails.Builder)AwsEc2ClientVpnEndpointConnectionLogOptionsDetails.builder().applyMutation(connectionLogOptions)).build());
        }

        public Builder securityGroupIdSet(Collection<String> var1);

        public Builder securityGroupIdSet(String ... var1);

        public Builder vpcId(String var1);

        public Builder selfServicePortalUrl(String var1);

        public Builder clientConnectOptions(AwsEc2ClientVpnEndpointClientConnectOptionsDetails var1);

        default public Builder clientConnectOptions(Consumer<AwsEc2ClientVpnEndpointClientConnectOptionsDetails.Builder> clientConnectOptions) {
            return this.clientConnectOptions((AwsEc2ClientVpnEndpointClientConnectOptionsDetails)((AwsEc2ClientVpnEndpointClientConnectOptionsDetails.Builder)AwsEc2ClientVpnEndpointClientConnectOptionsDetails.builder().applyMutation(clientConnectOptions)).build());
        }

        public Builder sessionTimeoutHours(Integer var1);

        public Builder clientLoginBannerOptions(AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails var1);

        default public Builder clientLoginBannerOptions(Consumer<AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails.Builder> clientLoginBannerOptions) {
            return this.clientLoginBannerOptions((AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails)((AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails.Builder)AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails.builder().applyMutation(clientLoginBannerOptions)).build());
        }
    }
}

