/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A stateless rule in the rule group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleGroupSourceStatelessRulesDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleGroupSourceStatelessRulesDetails.Builder, RuleGroupSourceStatelessRulesDetails> {
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(RuleGroupSourceStatelessRulesDetails::priority))
            .setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<RuleGroupSourceStatelessRuleDefinition> RULE_DEFINITION_FIELD = SdkField
            .<RuleGroupSourceStatelessRuleDefinition> builder(MarshallingType.SDK_POJO).memberName("RuleDefinition")
            .getter(getter(RuleGroupSourceStatelessRulesDetails::ruleDefinition)).setter(setter(Builder::ruleDefinition))
            .constructor(RuleGroupSourceStatelessRuleDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIORITY_FIELD,
            RULE_DEFINITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer priority;

    private final RuleGroupSourceStatelessRuleDefinition ruleDefinition;

    private RuleGroupSourceStatelessRulesDetails(BuilderImpl builder) {
        this.priority = builder.priority;
        this.ruleDefinition = builder.ruleDefinition;
    }

    /**
     * <p>
     * Indicates the order in which to run this rule relative to all of the rules in the stateless rule group.
     * </p>
     * 
     * @return Indicates the order in which to run this rule relative to all of the rules in the stateless rule group.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * Provides the definition of the stateless rule.
     * </p>
     * 
     * @return Provides the definition of the stateless rule.
     */
    public final RuleGroupSourceStatelessRuleDefinition ruleDefinition() {
        return ruleDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(ruleDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupSourceStatelessRulesDetails)) {
            return false;
        }
        RuleGroupSourceStatelessRulesDetails other = (RuleGroupSourceStatelessRulesDetails) obj;
        return Objects.equals(priority(), other.priority()) && Objects.equals(ruleDefinition(), other.ruleDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleGroupSourceStatelessRulesDetails").add("Priority", priority())
                .add("RuleDefinition", ruleDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "RuleDefinition":
            return Optional.ofNullable(clazz.cast(ruleDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupSourceStatelessRulesDetails, T> g) {
        return obj -> g.apply((RuleGroupSourceStatelessRulesDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleGroupSourceStatelessRulesDetails> {
        /**
         * <p>
         * Indicates the order in which to run this rule relative to all of the rules in the stateless rule group.
         * </p>
         * 
         * @param priority
         *        Indicates the order in which to run this rule relative to all of the rules in the stateless rule
         *        group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * Provides the definition of the stateless rule.
         * </p>
         * 
         * @param ruleDefinition
         *        Provides the definition of the stateless rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleDefinition(RuleGroupSourceStatelessRuleDefinition ruleDefinition);

        /**
         * <p>
         * Provides the definition of the stateless rule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RuleGroupSourceStatelessRuleDefinition.Builder} avoiding the need to create one manually via
         * {@link RuleGroupSourceStatelessRuleDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleGroupSourceStatelessRuleDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #ruleDefinition(RuleGroupSourceStatelessRuleDefinition)}.
         * 
         * @param ruleDefinition
         *        a consumer that will call methods on {@link RuleGroupSourceStatelessRuleDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleDefinition(RuleGroupSourceStatelessRuleDefinition)
         */
        default Builder ruleDefinition(Consumer<RuleGroupSourceStatelessRuleDefinition.Builder> ruleDefinition) {
            return ruleDefinition(RuleGroupSourceStatelessRuleDefinition.builder().applyMutation(ruleDefinition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer priority;

        private RuleGroupSourceStatelessRuleDefinition ruleDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupSourceStatelessRulesDetails model) {
            priority(model.priority);
            ruleDefinition(model.ruleDefinition);
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final RuleGroupSourceStatelessRuleDefinition.Builder getRuleDefinition() {
            return ruleDefinition != null ? ruleDefinition.toBuilder() : null;
        }

        public final void setRuleDefinition(RuleGroupSourceStatelessRuleDefinition.BuilderImpl ruleDefinition) {
            this.ruleDefinition = ruleDefinition != null ? ruleDefinition.build() : null;
        }

        @Override
        public final Builder ruleDefinition(RuleGroupSourceStatelessRuleDefinition ruleDefinition) {
            this.ruleDefinition = ruleDefinition;
            return this;
        }

        @Override
        public RuleGroupSourceStatelessRulesDetails build() {
            return new RuleGroupSourceStatelessRulesDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
