/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An IAM role that is associated with the Amazon RDS DB cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRdsDbClusterAssociatedRole implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRdsDbClusterAssociatedRole.Builder, AwsRdsDbClusterAssociatedRole> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(AwsRdsDbClusterAssociatedRole::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsRdsDbClusterAssociatedRole::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String status;

    private AwsRdsDbClusterAssociatedRole(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ARN of the IAM role.
     * </p>
     * 
     * @return The ARN of the IAM role.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The status of the association between the IAM role and the DB cluster. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INVALID</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the association between the IAM role and the DB cluster. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INVALID</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code>
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsDbClusterAssociatedRole)) {
            return false;
        }
        AwsRdsDbClusterAssociatedRole other = (AwsRdsDbClusterAssociatedRole) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRdsDbClusterAssociatedRole").add("RoleArn", roleArn()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsDbClusterAssociatedRole, T> g) {
        return obj -> g.apply((AwsRdsDbClusterAssociatedRole) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRdsDbClusterAssociatedRole> {
        /**
         * <p>
         * The ARN of the IAM role.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The status of the association between the IAM role and the DB cluster. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INVALID</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the association between the IAM role and the DB cluster. Valid values are as
         *        follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INVALID</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsDbClusterAssociatedRole model) {
            roleArn(model.roleArn);
            status(model.status);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public AwsRdsDbClusterAssociatedRole build() {
            return new AwsRdsDbClusterAssociatedRole(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
