/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information to include in an Amazon Elastic Compute Cloud (Amazon EC2) launch template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2LaunchTemplateDataDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2LaunchTemplateDataDetails.Builder, AwsEc2LaunchTemplateDataDetails> {
    private static final SdkField<List<AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails>> BLOCK_DEVICE_MAPPING_SET_FIELD = SdkField
            .<List<AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails>> builder(MarshallingType.LIST)
            .memberName("BlockDeviceMappingSet")
            .getter(getter(AwsEc2LaunchTemplateDataDetails::blockDeviceMappingSet))
            .setter(setter(Builder::blockDeviceMappingSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMappingSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails> CAPACITY_RESERVATION_SPECIFICATION_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("CapacityReservationSpecification")
            .getter(getter(AwsEc2LaunchTemplateDataDetails::capacityReservationSpecification))
            .setter(setter(Builder::capacityReservationSpecification))
            .constructor(AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationSpecification")
                    .build()).build();

    private static final SdkField<AwsEc2LaunchTemplateDataCpuOptionsDetails> CPU_OPTIONS_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataCpuOptionsDetails> builder(MarshallingType.SDK_POJO).memberName("CpuOptions")
            .getter(getter(AwsEc2LaunchTemplateDataDetails::cpuOptions)).setter(setter(Builder::cpuOptions))
            .constructor(AwsEc2LaunchTemplateDataCpuOptionsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuOptions").build()).build();

    private static final SdkField<AwsEc2LaunchTemplateDataCreditSpecificationDetails> CREDIT_SPECIFICATION_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataCreditSpecificationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("CreditSpecification").getter(getter(AwsEc2LaunchTemplateDataDetails::creditSpecification))
            .setter(setter(Builder::creditSpecification))
            .constructor(AwsEc2LaunchTemplateDataCreditSpecificationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreditSpecification").build())
            .build();

    private static final SdkField<Boolean> DISABLE_API_STOP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableApiStop").getter(getter(AwsEc2LaunchTemplateDataDetails::disableApiStop))
            .setter(setter(Builder::disableApiStop))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableApiStop").build()).build();

    private static final SdkField<Boolean> DISABLE_API_TERMINATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DisableApiTermination").getter(getter(AwsEc2LaunchTemplateDataDetails::disableApiTermination))
            .setter(setter(Builder::disableApiTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableApiTermination").build())
            .build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsOptimized").getter(getter(AwsEc2LaunchTemplateDataDetails::ebsOptimized))
            .setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").build()).build();

    private static final SdkField<List<AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails>> ELASTIC_GPU_SPECIFICATION_SET_FIELD = SdkField
            .<List<AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails>> builder(MarshallingType.LIST)
            .memberName("ElasticGpuSpecificationSet")
            .getter(getter(AwsEc2LaunchTemplateDataDetails::elasticGpuSpecificationSet))
            .setter(setter(Builder::elasticGpuSpecificationSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuSpecificationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails>> ELASTIC_INFERENCE_ACCELERATOR_SET_FIELD = SdkField
            .<List<AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails>> builder(MarshallingType.LIST)
            .memberName("ElasticInferenceAcceleratorSet")
            .getter(getter(AwsEc2LaunchTemplateDataDetails::elasticInferenceAcceleratorSet))
            .setter(setter(Builder::elasticInferenceAcceleratorSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticInferenceAcceleratorSet")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsEc2LaunchTemplateDataEnclaveOptionsDetails> ENCLAVE_OPTIONS_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataEnclaveOptionsDetails> builder(MarshallingType.SDK_POJO).memberName("EnclaveOptions")
            .getter(getter(AwsEc2LaunchTemplateDataDetails::enclaveOptions)).setter(setter(Builder::enclaveOptions))
            .constructor(AwsEc2LaunchTemplateDataEnclaveOptionsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnclaveOptions").build()).build();

    private static final SdkField<AwsEc2LaunchTemplateDataHibernationOptionsDetails> HIBERNATION_OPTIONS_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataHibernationOptionsDetails> builder(MarshallingType.SDK_POJO)
            .memberName("HibernationOptions").getter(getter(AwsEc2LaunchTemplateDataDetails::hibernationOptions))
            .setter(setter(Builder::hibernationOptions)).constructor(AwsEc2LaunchTemplateDataHibernationOptionsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HibernationOptions").build())
            .build();

    private static final SdkField<AwsEc2LaunchTemplateDataIamInstanceProfileDetails> IAM_INSTANCE_PROFILE_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataIamInstanceProfileDetails> builder(MarshallingType.SDK_POJO)
            .memberName("IamInstanceProfile").getter(getter(AwsEc2LaunchTemplateDataDetails::iamInstanceProfile))
            .setter(setter(Builder::iamInstanceProfile)).constructor(AwsEc2LaunchTemplateDataIamInstanceProfileDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile").build())
            .build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageId").getter(getter(AwsEc2LaunchTemplateDataDetails::imageId)).setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()).build();

    private static final SdkField<String> INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceInitiatedShutdownBehavior")
            .getter(getter(AwsEc2LaunchTemplateDataDetails::instanceInitiatedShutdownBehavior))
            .setter(setter(Builder::instanceInitiatedShutdownBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInitiatedShutdownBehavior")
                    .build()).build();

    private static final SdkField<AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails> INSTANCE_MARKET_OPTIONS_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceMarketOptions").getter(getter(AwsEc2LaunchTemplateDataDetails::instanceMarketOptions))
            .setter(setter(Builder::instanceMarketOptions))
            .constructor(AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMarketOptions").build())
            .build();

    private static final SdkField<AwsEc2LaunchTemplateDataInstanceRequirementsDetails> INSTANCE_REQUIREMENTS_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataInstanceRequirementsDetails> builder(MarshallingType.SDK_POJO)
            .memberName("InstanceRequirements").getter(getter(AwsEc2LaunchTemplateDataDetails::instanceRequirements))
            .setter(setter(Builder::instanceRequirements))
            .constructor(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRequirements").build())
            .build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(AwsEc2LaunchTemplateDataDetails::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> KERNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KernelId").getter(getter(AwsEc2LaunchTemplateDataDetails::kernelId)).setter(setter(Builder::kernelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId").build()).build();

    private static final SdkField<String> KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyName").getter(getter(AwsEc2LaunchTemplateDataDetails::keyName)).setter(setter(Builder::keyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").build()).build();

    private static final SdkField<List<AwsEc2LaunchTemplateDataLicenseSetDetails>> LICENSE_SET_FIELD = SdkField
            .<List<AwsEc2LaunchTemplateDataLicenseSetDetails>> builder(MarshallingType.LIST)
            .memberName("LicenseSet")
            .getter(getter(AwsEc2LaunchTemplateDataDetails::licenseSet))
            .setter(setter(Builder::licenseSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2LaunchTemplateDataLicenseSetDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2LaunchTemplateDataLicenseSetDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsEc2LaunchTemplateDataMaintenanceOptionsDetails> MAINTENANCE_OPTIONS_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataMaintenanceOptionsDetails> builder(MarshallingType.SDK_POJO)
            .memberName("MaintenanceOptions").getter(getter(AwsEc2LaunchTemplateDataDetails::maintenanceOptions))
            .setter(setter(Builder::maintenanceOptions)).constructor(AwsEc2LaunchTemplateDataMaintenanceOptionsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceOptions").build())
            .build();

    private static final SdkField<AwsEc2LaunchTemplateDataMetadataOptionsDetails> METADATA_OPTIONS_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataMetadataOptionsDetails> builder(MarshallingType.SDK_POJO).memberName("MetadataOptions")
            .getter(getter(AwsEc2LaunchTemplateDataDetails::metadataOptions)).setter(setter(Builder::metadataOptions))
            .constructor(AwsEc2LaunchTemplateDataMetadataOptionsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataOptions").build()).build();

    private static final SdkField<AwsEc2LaunchTemplateDataMonitoringDetails> MONITORING_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataMonitoringDetails> builder(MarshallingType.SDK_POJO).memberName("Monitoring")
            .getter(getter(AwsEc2LaunchTemplateDataDetails::monitoring)).setter(setter(Builder::monitoring))
            .constructor(AwsEc2LaunchTemplateDataMonitoringDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitoring").build()).build();

    private static final SdkField<List<AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails>> NETWORK_INTERFACE_SET_FIELD = SdkField
            .<List<AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails>> builder(MarshallingType.LIST)
            .memberName("NetworkInterfaceSet")
            .getter(getter(AwsEc2LaunchTemplateDataDetails::networkInterfaceSet))
            .setter(setter(Builder::networkInterfaceSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsEc2LaunchTemplateDataPlacementDetails> PLACEMENT_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataPlacementDetails> builder(MarshallingType.SDK_POJO).memberName("Placement")
            .getter(getter(AwsEc2LaunchTemplateDataDetails::placement)).setter(setter(Builder::placement))
            .constructor(AwsEc2LaunchTemplateDataPlacementDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").build()).build();

    private static final SdkField<AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails> PRIVATE_DNS_NAME_OPTIONS_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails> builder(MarshallingType.SDK_POJO)
            .memberName("PrivateDnsNameOptions").getter(getter(AwsEc2LaunchTemplateDataDetails::privateDnsNameOptions))
            .setter(setter(Builder::privateDnsNameOptions))
            .constructor(AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsNameOptions").build())
            .build();

    private static final SdkField<String> RAM_DISK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RamDiskId").getter(getter(AwsEc2LaunchTemplateDataDetails::ramDiskId))
            .setter(setter(Builder::ramDiskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamDiskId").build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_ID_SET_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIdSet")
            .getter(getter(AwsEc2LaunchTemplateDataDetails::securityGroupIdSet))
            .setter(setter(Builder::securityGroupIdSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIdSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_SET_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupSet")
            .getter(getter(AwsEc2LaunchTemplateDataDetails::securityGroupSet))
            .setter(setter(Builder::securityGroupSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USER_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserData").getter(getter(AwsEc2LaunchTemplateDataDetails::userData)).setter(setter(Builder::userData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BLOCK_DEVICE_MAPPING_SET_FIELD, CAPACITY_RESERVATION_SPECIFICATION_FIELD, CPU_OPTIONS_FIELD,
            CREDIT_SPECIFICATION_FIELD, DISABLE_API_STOP_FIELD, DISABLE_API_TERMINATION_FIELD, EBS_OPTIMIZED_FIELD,
            ELASTIC_GPU_SPECIFICATION_SET_FIELD, ELASTIC_INFERENCE_ACCELERATOR_SET_FIELD, ENCLAVE_OPTIONS_FIELD,
            HIBERNATION_OPTIONS_FIELD, IAM_INSTANCE_PROFILE_FIELD, IMAGE_ID_FIELD, INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD,
            INSTANCE_MARKET_OPTIONS_FIELD, INSTANCE_REQUIREMENTS_FIELD, INSTANCE_TYPE_FIELD, KERNEL_ID_FIELD, KEY_NAME_FIELD,
            LICENSE_SET_FIELD, MAINTENANCE_OPTIONS_FIELD, METADATA_OPTIONS_FIELD, MONITORING_FIELD, NETWORK_INTERFACE_SET_FIELD,
            PLACEMENT_FIELD, PRIVATE_DNS_NAME_OPTIONS_FIELD, RAM_DISK_ID_FIELD, SECURITY_GROUP_ID_SET_FIELD,
            SECURITY_GROUP_SET_FIELD, USER_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails> blockDeviceMappingSet;

    private final AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails capacityReservationSpecification;

    private final AwsEc2LaunchTemplateDataCpuOptionsDetails cpuOptions;

    private final AwsEc2LaunchTemplateDataCreditSpecificationDetails creditSpecification;

    private final Boolean disableApiStop;

    private final Boolean disableApiTermination;

    private final Boolean ebsOptimized;

    private final List<AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails> elasticGpuSpecificationSet;

    private final List<AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails> elasticInferenceAcceleratorSet;

    private final AwsEc2LaunchTemplateDataEnclaveOptionsDetails enclaveOptions;

    private final AwsEc2LaunchTemplateDataHibernationOptionsDetails hibernationOptions;

    private final AwsEc2LaunchTemplateDataIamInstanceProfileDetails iamInstanceProfile;

    private final String imageId;

    private final String instanceInitiatedShutdownBehavior;

    private final AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails instanceMarketOptions;

    private final AwsEc2LaunchTemplateDataInstanceRequirementsDetails instanceRequirements;

    private final String instanceType;

    private final String kernelId;

    private final String keyName;

    private final List<AwsEc2LaunchTemplateDataLicenseSetDetails> licenseSet;

    private final AwsEc2LaunchTemplateDataMaintenanceOptionsDetails maintenanceOptions;

    private final AwsEc2LaunchTemplateDataMetadataOptionsDetails metadataOptions;

    private final AwsEc2LaunchTemplateDataMonitoringDetails monitoring;

    private final List<AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails> networkInterfaceSet;

    private final AwsEc2LaunchTemplateDataPlacementDetails placement;

    private final AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails privateDnsNameOptions;

    private final String ramDiskId;

    private final List<String> securityGroupIdSet;

    private final List<String> securityGroupSet;

    private final String userData;

    private AwsEc2LaunchTemplateDataDetails(BuilderImpl builder) {
        this.blockDeviceMappingSet = builder.blockDeviceMappingSet;
        this.capacityReservationSpecification = builder.capacityReservationSpecification;
        this.cpuOptions = builder.cpuOptions;
        this.creditSpecification = builder.creditSpecification;
        this.disableApiStop = builder.disableApiStop;
        this.disableApiTermination = builder.disableApiTermination;
        this.ebsOptimized = builder.ebsOptimized;
        this.elasticGpuSpecificationSet = builder.elasticGpuSpecificationSet;
        this.elasticInferenceAcceleratorSet = builder.elasticInferenceAcceleratorSet;
        this.enclaveOptions = builder.enclaveOptions;
        this.hibernationOptions = builder.hibernationOptions;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.imageId = builder.imageId;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.instanceMarketOptions = builder.instanceMarketOptions;
        this.instanceRequirements = builder.instanceRequirements;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.keyName = builder.keyName;
        this.licenseSet = builder.licenseSet;
        this.maintenanceOptions = builder.maintenanceOptions;
        this.metadataOptions = builder.metadataOptions;
        this.monitoring = builder.monitoring;
        this.networkInterfaceSet = builder.networkInterfaceSet;
        this.placement = builder.placement;
        this.privateDnsNameOptions = builder.privateDnsNameOptions;
        this.ramDiskId = builder.ramDiskId;
        this.securityGroupIdSet = builder.securityGroupIdSet;
        this.securityGroupSet = builder.securityGroupSet;
        this.userData = builder.userData;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockDeviceMappingSet property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBlockDeviceMappingSet() {
        return blockDeviceMappingSet != null && !(blockDeviceMappingSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about a block device mapping for an Amazon EC2 launch template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockDeviceMappingSet} method.
     * </p>
     * 
     * @return Information about a block device mapping for an Amazon EC2 launch template.
     */
    public final List<AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails> blockDeviceMappingSet() {
        return blockDeviceMappingSet;
    }

    /**
     * <p>
     * Specifies an instance's Capacity Reservation targeting option. You can specify only one option at a time.
     * </p>
     * 
     * @return Specifies an instance's Capacity Reservation targeting option. You can specify only one option at a time.
     */
    public final AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails capacityReservationSpecification() {
        return capacityReservationSpecification;
    }

    /**
     * <p>
     * Specifies the CPU options for an instance. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU options</a> in
     * the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Specifies the CPU options for an instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU
     *         options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public final AwsEc2LaunchTemplateDataCpuOptionsDetails cpuOptions() {
        return cpuOptions;
    }

    /**
     * <p>
     * Specifies the credit option for CPU usage of a T2, T3, or T3a instance.
     * </p>
     * 
     * @return Specifies the credit option for CPU usage of a T2, T3, or T3a instance.
     */
    public final AwsEc2LaunchTemplateDataCreditSpecificationDetails creditSpecification() {
        return creditSpecification;
    }

    /**
     * <p>
     * Indicates whether to enable the instance for stop protection. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection">Enable stop
     * protection</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return Indicates whether to enable the instance for stop protection. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection">Enable
     *         stop protection</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final Boolean disableApiStop() {
        return disableApiStop;
    }

    /**
     * <p>
     * If you set this parameter to <code>true</code>, you can't terminate the instance using the Amazon EC2 console,
     * CLI, or API. If set to <code>true</code>, you can.
     * </p>
     * 
     * @return If you set this parameter to <code>true</code>, you can't terminate the instance using the Amazon EC2
     *         console, CLI, or API. If set to <code>true</code>, you can.
     */
    public final Boolean disableApiTermination() {
        return disableApiTermination;
    }

    /**
     * <p>
     * Indicates whether the instance is optimized for Amazon EBS I/O.
     * </p>
     * 
     * @return Indicates whether the instance is optimized for Amazon EBS I/O.
     */
    public final Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * For responses, this returns true if the service returned a value for the ElasticGpuSpecificationSet property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasElasticGpuSpecificationSet() {
        return elasticGpuSpecificationSet != null && !(elasticGpuSpecificationSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides details about Elastic Graphics accelerators to associate with the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasElasticGpuSpecificationSet} method.
     * </p>
     * 
     * @return Provides details about Elastic Graphics accelerators to associate with the instance.
     */
    public final List<AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails> elasticGpuSpecificationSet() {
        return elasticGpuSpecificationSet;
    }

    /**
     * For responses, this returns true if the service returned a value for the ElasticInferenceAcceleratorSet property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasElasticInferenceAcceleratorSet() {
        return elasticInferenceAcceleratorSet != null && !(elasticInferenceAcceleratorSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Elastic Inference accelerator for the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasElasticInferenceAcceleratorSet} method.
     * </p>
     * 
     * @return The Amazon Elastic Inference accelerator for the instance.
     */
    public final List<AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails> elasticInferenceAcceleratorSet() {
        return elasticInferenceAcceleratorSet;
    }

    /**
     * <p>
     * Indicates whether the Amazon EC2 instance is enabled for Amazon Web Services Nitro Enclaves.
     * </p>
     * 
     * @return Indicates whether the Amazon EC2 instance is enabled for Amazon Web Services Nitro Enclaves.
     */
    public final AwsEc2LaunchTemplateDataEnclaveOptionsDetails enclaveOptions() {
        return enclaveOptions;
    }

    /**
     * <p>
     * Specifies whether your Amazon EC2 instance is configured for hibernation.
     * </p>
     * 
     * @return Specifies whether your Amazon EC2 instance is configured for hibernation.
     */
    public final AwsEc2LaunchTemplateDataHibernationOptionsDetails hibernationOptions() {
        return hibernationOptions;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of an IAM instance profile.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of an IAM instance profile.
     */
    public final AwsEc2LaunchTemplateDataIamInstanceProfileDetails iamInstanceProfile() {
        return iamInstanceProfile;
    }

    /**
     * <p>
     * The ID of the Amazon Machine Image (AMI).
     * </p>
     * 
     * @return The ID of the Amazon Machine Image (AMI).
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * Provides the options for specifying the instance initiated shutdown behavior.
     * </p>
     * 
     * @return Provides the options for specifying the instance initiated shutdown behavior.
     */
    public final String instanceInitiatedShutdownBehavior() {
        return instanceInitiatedShutdownBehavior;
    }

    /**
     * <p>
     * Specifies the market (purchasing) option for an instance.
     * </p>
     * 
     * @return Specifies the market (purchasing) option for an instance.
     */
    public final AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails instanceMarketOptions() {
        return instanceMarketOptions;
    }

    /**
     * <p>
     * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify instance
     * types with these attributes. If you specify <code>InstanceRequirements</code>, you can't specify
     * <code>InstanceType</code>.
     * </p>
     * 
     * @return The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
     *         instance types with these attributes. If you specify <code>InstanceRequirements</code>, you can't specify
     *         <code>InstanceType</code>.
     */
    public final AwsEc2LaunchTemplateDataInstanceRequirementsDetails instanceRequirements() {
        return instanceRequirements;
    }

    /**
     * <p>
     * The instance type. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     * <i>Amazon EC2 User Guide</i>. If you specify <code>InstanceType</code>, you can't specify
     * <code>InstanceRequirements</code>.
     * </p>
     * 
     * @return The instance type. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
     *         <i>Amazon EC2 User Guide</i>. If you specify <code>InstanceType</code>, you can't specify
     *         <code>InstanceRequirements</code>.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The ID of the kernel.
     * </p>
     * 
     * @return The ID of the kernel.
     */
    public final String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The name of the key pair that allows users to connect to the instance.
     * </p>
     * 
     * @return The name of the key pair that allows users to connect to the instance.
     */
    public final String keyName() {
        return keyName;
    }

    /**
     * For responses, this returns true if the service returned a value for the LicenseSet property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLicenseSet() {
        return licenseSet != null && !(licenseSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies a license configuration for an instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLicenseSet} method.
     * </p>
     * 
     * @return Specifies a license configuration for an instance.
     */
    public final List<AwsEc2LaunchTemplateDataLicenseSetDetails> licenseSet() {
        return licenseSet;
    }

    /**
     * <p>
     * The maintenance options of your instance.
     * </p>
     * 
     * @return The maintenance options of your instance.
     */
    public final AwsEc2LaunchTemplateDataMaintenanceOptionsDetails maintenanceOptions() {
        return maintenanceOptions;
    }

    /**
     * <p>
     * The metadata options for the instance. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user
     * data</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return The metadata options for the instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata
     *         and user data</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final AwsEc2LaunchTemplateDataMetadataOptionsDetails metadataOptions() {
        return metadataOptions;
    }

    /**
     * <p>
     * The monitoring for the instance.
     * </p>
     * 
     * @return The monitoring for the instance.
     */
    public final AwsEc2LaunchTemplateDataMonitoringDetails monitoring() {
        return monitoring;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkInterfaceSet property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkInterfaceSet() {
        return networkInterfaceSet != null && !(networkInterfaceSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the parameters for a network interface that is attached to the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkInterfaceSet} method.
     * </p>
     * 
     * @return Specifies the parameters for a network interface that is attached to the instance.
     */
    public final List<AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails> networkInterfaceSet() {
        return networkInterfaceSet;
    }

    /**
     * <p>
     * Specifies the placement of an instance.
     * </p>
     * 
     * @return Specifies the placement of an instance.
     */
    public final AwsEc2LaunchTemplateDataPlacementDetails placement() {
        return placement;
    }

    /**
     * <p>
     * The options for the instance hostname.
     * </p>
     * 
     * @return The options for the instance hostname.
     */
    public final AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails privateDnsNameOptions() {
        return privateDnsNameOptions;
    }

    /**
     * <p>
     * The ID of the RAM disk.
     * </p>
     * 
     * @return The ID of the RAM disk.
     */
    public final String ramDiskId() {
        return ramDiskId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIdSet property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIdSet() {
        return securityGroupIdSet != null && !(securityGroupIdSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more security group IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIdSet} method.
     * </p>
     * 
     * @return One or more security group IDs.
     */
    public final List<String> securityGroupIdSet() {
        return securityGroupIdSet;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupSet property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupSet() {
        return securityGroupSet != null && !(securityGroupSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more security group names. For a nondefault VPC, you must use security group IDs instead. You cannot
     * specify both a security group ID and security name in the same request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupSet} method.
     * </p>
     * 
     * @return One or more security group names. For a nondefault VPC, you must use security group IDs instead. You
     *         cannot specify both a security group ID and security name in the same request.
     */
    public final List<String> securityGroupSet() {
        return securityGroupSet;
    }

    /**
     * <p>
     * The user data to make available to the instance.
     * </p>
     * 
     * @return The user data to make available to the instance.
     */
    public final String userData() {
        return userData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockDeviceMappingSet() ? blockDeviceMappingSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(cpuOptions());
        hashCode = 31 * hashCode + Objects.hashCode(creditSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(disableApiStop());
        hashCode = 31 * hashCode + Objects.hashCode(disableApiTermination());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(hasElasticGpuSpecificationSet() ? elasticGpuSpecificationSet() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasElasticInferenceAcceleratorSet() ? elasticInferenceAcceleratorSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enclaveOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hibernationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceInitiatedShutdownBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(instanceMarketOptions());
        hashCode = 31 * hashCode + Objects.hashCode(instanceRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        hashCode = 31 * hashCode + Objects.hashCode(hasLicenseSet() ? licenseSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceOptions());
        hashCode = 31 * hashCode + Objects.hashCode(metadataOptions());
        hashCode = 31 * hashCode + Objects.hashCode(monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkInterfaceSet() ? networkInterfaceSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(placement());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsNameOptions());
        hashCode = 31 * hashCode + Objects.hashCode(ramDiskId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIdSet() ? securityGroupIdSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupSet() ? securityGroupSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2LaunchTemplateDataDetails)) {
            return false;
        }
        AwsEc2LaunchTemplateDataDetails other = (AwsEc2LaunchTemplateDataDetails) obj;
        return hasBlockDeviceMappingSet() == other.hasBlockDeviceMappingSet()
                && Objects.equals(blockDeviceMappingSet(), other.blockDeviceMappingSet())
                && Objects.equals(capacityReservationSpecification(), other.capacityReservationSpecification())
                && Objects.equals(cpuOptions(), other.cpuOptions())
                && Objects.equals(creditSpecification(), other.creditSpecification())
                && Objects.equals(disableApiStop(), other.disableApiStop())
                && Objects.equals(disableApiTermination(), other.disableApiTermination())
                && Objects.equals(ebsOptimized(), other.ebsOptimized())
                && hasElasticGpuSpecificationSet() == other.hasElasticGpuSpecificationSet()
                && Objects.equals(elasticGpuSpecificationSet(), other.elasticGpuSpecificationSet())
                && hasElasticInferenceAcceleratorSet() == other.hasElasticInferenceAcceleratorSet()
                && Objects.equals(elasticInferenceAcceleratorSet(), other.elasticInferenceAcceleratorSet())
                && Objects.equals(enclaveOptions(), other.enclaveOptions())
                && Objects.equals(hibernationOptions(), other.hibernationOptions())
                && Objects.equals(iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(imageId(), other.imageId())
                && Objects.equals(instanceInitiatedShutdownBehavior(), other.instanceInitiatedShutdownBehavior())
                && Objects.equals(instanceMarketOptions(), other.instanceMarketOptions())
                && Objects.equals(instanceRequirements(), other.instanceRequirements())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(kernelId(), other.kernelId())
                && Objects.equals(keyName(), other.keyName()) && hasLicenseSet() == other.hasLicenseSet()
                && Objects.equals(licenseSet(), other.licenseSet())
                && Objects.equals(maintenanceOptions(), other.maintenanceOptions())
                && Objects.equals(metadataOptions(), other.metadataOptions()) && Objects.equals(monitoring(), other.monitoring())
                && hasNetworkInterfaceSet() == other.hasNetworkInterfaceSet()
                && Objects.equals(networkInterfaceSet(), other.networkInterfaceSet())
                && Objects.equals(placement(), other.placement())
                && Objects.equals(privateDnsNameOptions(), other.privateDnsNameOptions())
                && Objects.equals(ramDiskId(), other.ramDiskId()) && hasSecurityGroupIdSet() == other.hasSecurityGroupIdSet()
                && Objects.equals(securityGroupIdSet(), other.securityGroupIdSet())
                && hasSecurityGroupSet() == other.hasSecurityGroupSet()
                && Objects.equals(securityGroupSet(), other.securityGroupSet()) && Objects.equals(userData(), other.userData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AwsEc2LaunchTemplateDataDetails")
                .add("BlockDeviceMappingSet", hasBlockDeviceMappingSet() ? blockDeviceMappingSet() : null)
                .add("CapacityReservationSpecification", capacityReservationSpecification())
                .add("CpuOptions", cpuOptions())
                .add("CreditSpecification", creditSpecification())
                .add("DisableApiStop", disableApiStop())
                .add("DisableApiTermination", disableApiTermination())
                .add("EbsOptimized", ebsOptimized())
                .add("ElasticGpuSpecificationSet", hasElasticGpuSpecificationSet() ? elasticGpuSpecificationSet() : null)
                .add("ElasticInferenceAcceleratorSet",
                        hasElasticInferenceAcceleratorSet() ? elasticInferenceAcceleratorSet() : null)
                .add("EnclaveOptions", enclaveOptions()).add("HibernationOptions", hibernationOptions())
                .add("IamInstanceProfile", iamInstanceProfile()).add("ImageId", imageId())
                .add("InstanceInitiatedShutdownBehavior", instanceInitiatedShutdownBehavior())
                .add("InstanceMarketOptions", instanceMarketOptions()).add("InstanceRequirements", instanceRequirements())
                .add("InstanceType", instanceType()).add("KernelId", kernelId()).add("KeyName", keyName())
                .add("LicenseSet", hasLicenseSet() ? licenseSet() : null).add("MaintenanceOptions", maintenanceOptions())
                .add("MetadataOptions", metadataOptions()).add("Monitoring", monitoring())
                .add("NetworkInterfaceSet", hasNetworkInterfaceSet() ? networkInterfaceSet() : null)
                .add("Placement", placement()).add("PrivateDnsNameOptions", privateDnsNameOptions())
                .add("RamDiskId", ramDiskId()).add("SecurityGroupIdSet", hasSecurityGroupIdSet() ? securityGroupIdSet() : null)
                .add("SecurityGroupSet", hasSecurityGroupSet() ? securityGroupSet() : null).add("UserData", userData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlockDeviceMappingSet":
            return Optional.ofNullable(clazz.cast(blockDeviceMappingSet()));
        case "CapacityReservationSpecification":
            return Optional.ofNullable(clazz.cast(capacityReservationSpecification()));
        case "CpuOptions":
            return Optional.ofNullable(clazz.cast(cpuOptions()));
        case "CreditSpecification":
            return Optional.ofNullable(clazz.cast(creditSpecification()));
        case "DisableApiStop":
            return Optional.ofNullable(clazz.cast(disableApiStop()));
        case "DisableApiTermination":
            return Optional.ofNullable(clazz.cast(disableApiTermination()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "ElasticGpuSpecificationSet":
            return Optional.ofNullable(clazz.cast(elasticGpuSpecificationSet()));
        case "ElasticInferenceAcceleratorSet":
            return Optional.ofNullable(clazz.cast(elasticInferenceAcceleratorSet()));
        case "EnclaveOptions":
            return Optional.ofNullable(clazz.cast(enclaveOptions()));
        case "HibernationOptions":
            return Optional.ofNullable(clazz.cast(hibernationOptions()));
        case "IamInstanceProfile":
            return Optional.ofNullable(clazz.cast(iamInstanceProfile()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "InstanceInitiatedShutdownBehavior":
            return Optional.ofNullable(clazz.cast(instanceInitiatedShutdownBehavior()));
        case "InstanceMarketOptions":
            return Optional.ofNullable(clazz.cast(instanceMarketOptions()));
        case "InstanceRequirements":
            return Optional.ofNullable(clazz.cast(instanceRequirements()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "KernelId":
            return Optional.ofNullable(clazz.cast(kernelId()));
        case "KeyName":
            return Optional.ofNullable(clazz.cast(keyName()));
        case "LicenseSet":
            return Optional.ofNullable(clazz.cast(licenseSet()));
        case "MaintenanceOptions":
            return Optional.ofNullable(clazz.cast(maintenanceOptions()));
        case "MetadataOptions":
            return Optional.ofNullable(clazz.cast(metadataOptions()));
        case "Monitoring":
            return Optional.ofNullable(clazz.cast(monitoring()));
        case "NetworkInterfaceSet":
            return Optional.ofNullable(clazz.cast(networkInterfaceSet()));
        case "Placement":
            return Optional.ofNullable(clazz.cast(placement()));
        case "PrivateDnsNameOptions":
            return Optional.ofNullable(clazz.cast(privateDnsNameOptions()));
        case "RamDiskId":
            return Optional.ofNullable(clazz.cast(ramDiskId()));
        case "SecurityGroupIdSet":
            return Optional.ofNullable(clazz.cast(securityGroupIdSet()));
        case "SecurityGroupSet":
            return Optional.ofNullable(clazz.cast(securityGroupSet()));
        case "UserData":
            return Optional.ofNullable(clazz.cast(userData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2LaunchTemplateDataDetails, T> g) {
        return obj -> g.apply((AwsEc2LaunchTemplateDataDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2LaunchTemplateDataDetails> {
        /**
         * <p>
         * Information about a block device mapping for an Amazon EC2 launch template.
         * </p>
         * 
         * @param blockDeviceMappingSet
         *        Information about a block device mapping for an Amazon EC2 launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappingSet(Collection<AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails> blockDeviceMappingSet);

        /**
         * <p>
         * Information about a block device mapping for an Amazon EC2 launch template.
         * </p>
         * 
         * @param blockDeviceMappingSet
         *        Information about a block device mapping for an Amazon EC2 launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappingSet(AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails... blockDeviceMappingSet);

        /**
         * <p>
         * Information about a block device mapping for an Amazon EC2 launch template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #blockDeviceMappingSet(List<AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails>)}.
         * 
         * @param blockDeviceMappingSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappingSet(java.util.Collection<AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails>)
         */
        Builder blockDeviceMappingSet(
                Consumer<AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails.Builder>... blockDeviceMappingSet);

        /**
         * <p>
         * Specifies an instance's Capacity Reservation targeting option. You can specify only one option at a time.
         * </p>
         * 
         * @param capacityReservationSpecification
         *        Specifies an instance's Capacity Reservation targeting option. You can specify only one option at a
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationSpecification(
                AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails capacityReservationSpecification);

        /**
         * <p>
         * Specifies an instance's Capacity Reservation targeting option. You can specify only one option at a time.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails.Builder} avoiding the need to create
         * one manually via {@link AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails.Builder#build()} is called immediately
         * and its result is passed to
         * {@link #capacityReservationSpecification(AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails)}.
         * 
         * @param capacityReservationSpecification
         *        a consumer that will call methods on
         *        {@link AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservationSpecification(AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails)
         */
        default Builder capacityReservationSpecification(
                Consumer<AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails.Builder> capacityReservationSpecification) {
            return capacityReservationSpecification(AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails.builder()
                    .applyMutation(capacityReservationSpecification).build());
        }

        /**
         * <p>
         * Specifies the CPU options for an instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU
         * options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param cpuOptions
         *        Specifies the CPU options for an instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU
         *        options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuOptions(AwsEc2LaunchTemplateDataCpuOptionsDetails cpuOptions);

        /**
         * <p>
         * Specifies the CPU options for an instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-optimize-cpu.html">Optimize CPU
         * options</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataCpuOptionsDetails.Builder} avoiding the need to create one manually via
         * {@link AwsEc2LaunchTemplateDataCpuOptionsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2LaunchTemplateDataCpuOptionsDetails.Builder#build()} is
         * called immediately and its result is passed to {@link #cpuOptions(AwsEc2LaunchTemplateDataCpuOptionsDetails)}.
         * 
         * @param cpuOptions
         *        a consumer that will call methods on {@link AwsEc2LaunchTemplateDataCpuOptionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cpuOptions(AwsEc2LaunchTemplateDataCpuOptionsDetails)
         */
        default Builder cpuOptions(Consumer<AwsEc2LaunchTemplateDataCpuOptionsDetails.Builder> cpuOptions) {
            return cpuOptions(AwsEc2LaunchTemplateDataCpuOptionsDetails.builder().applyMutation(cpuOptions).build());
        }

        /**
         * <p>
         * Specifies the credit option for CPU usage of a T2, T3, or T3a instance.
         * </p>
         * 
         * @param creditSpecification
         *        Specifies the credit option for CPU usage of a T2, T3, or T3a instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creditSpecification(AwsEc2LaunchTemplateDataCreditSpecificationDetails creditSpecification);

        /**
         * <p>
         * Specifies the credit option for CPU usage of a T2, T3, or T3a instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataCreditSpecificationDetails.Builder} avoiding the need to create one manually
         * via {@link AwsEc2LaunchTemplateDataCreditSpecificationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2LaunchTemplateDataCreditSpecificationDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #creditSpecification(AwsEc2LaunchTemplateDataCreditSpecificationDetails)}.
         * 
         * @param creditSpecification
         *        a consumer that will call methods on
         *        {@link AwsEc2LaunchTemplateDataCreditSpecificationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #creditSpecification(AwsEc2LaunchTemplateDataCreditSpecificationDetails)
         */
        default Builder creditSpecification(
                Consumer<AwsEc2LaunchTemplateDataCreditSpecificationDetails.Builder> creditSpecification) {
            return creditSpecification(AwsEc2LaunchTemplateDataCreditSpecificationDetails.builder()
                    .applyMutation(creditSpecification).build());
        }

        /**
         * <p>
         * Indicates whether to enable the instance for stop protection. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection">Enable stop
         * protection</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param disableApiStop
         *        Indicates whether to enable the instance for stop protection. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection">Enable
         *        stop protection</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableApiStop(Boolean disableApiStop);

        /**
         * <p>
         * If you set this parameter to <code>true</code>, you can't terminate the instance using the Amazon EC2
         * console, CLI, or API. If set to <code>true</code>, you can.
         * </p>
         * 
         * @param disableApiTermination
         *        If you set this parameter to <code>true</code>, you can't terminate the instance using the Amazon EC2
         *        console, CLI, or API. If set to <code>true</code>, you can.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableApiTermination(Boolean disableApiTermination);

        /**
         * <p>
         * Indicates whether the instance is optimized for Amazon EBS I/O.
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the instance is optimized for Amazon EBS I/O.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * Provides details about Elastic Graphics accelerators to associate with the instance.
         * </p>
         * 
         * @param elasticGpuSpecificationSet
         *        Provides details about Elastic Graphics accelerators to associate with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuSpecificationSet(
                Collection<AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails> elasticGpuSpecificationSet);

        /**
         * <p>
         * Provides details about Elastic Graphics accelerators to associate with the instance.
         * </p>
         * 
         * @param elasticGpuSpecificationSet
         *        Provides details about Elastic Graphics accelerators to associate with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuSpecificationSet(
                AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails... elasticGpuSpecificationSet);

        /**
         * <p>
         * Provides details about Elastic Graphics accelerators to associate with the instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #elasticGpuSpecificationSet(List<AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails>)}.
         * 
         * @param elasticGpuSpecificationSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see 
         *      #elasticGpuSpecificationSet(java.util.Collection<AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails
         *      >)
         */
        Builder elasticGpuSpecificationSet(
                Consumer<AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails.Builder>... elasticGpuSpecificationSet);

        /**
         * <p>
         * The Amazon Elastic Inference accelerator for the instance.
         * </p>
         * 
         * @param elasticInferenceAcceleratorSet
         *        The Amazon Elastic Inference accelerator for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticInferenceAcceleratorSet(
                Collection<AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails> elasticInferenceAcceleratorSet);

        /**
         * <p>
         * The Amazon Elastic Inference accelerator for the instance.
         * </p>
         * 
         * @param elasticInferenceAcceleratorSet
         *        The Amazon Elastic Inference accelerator for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticInferenceAcceleratorSet(
                AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails... elasticInferenceAcceleratorSet);

        /**
         * <p>
         * The Amazon Elastic Inference accelerator for the instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #elasticInferenceAcceleratorSet(List<AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails>)}.
         * 
         * @param elasticInferenceAcceleratorSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticInferenceAcceleratorSet(java.util.Collection<
         *      AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails>)
         */
        Builder elasticInferenceAcceleratorSet(
                Consumer<AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails.Builder>... elasticInferenceAcceleratorSet);

        /**
         * <p>
         * Indicates whether the Amazon EC2 instance is enabled for Amazon Web Services Nitro Enclaves.
         * </p>
         * 
         * @param enclaveOptions
         *        Indicates whether the Amazon EC2 instance is enabled for Amazon Web Services Nitro Enclaves.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enclaveOptions(AwsEc2LaunchTemplateDataEnclaveOptionsDetails enclaveOptions);

        /**
         * <p>
         * Indicates whether the Amazon EC2 instance is enabled for Amazon Web Services Nitro Enclaves.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataEnclaveOptionsDetails.Builder} avoiding the need to create one manually via
         * {@link AwsEc2LaunchTemplateDataEnclaveOptionsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2LaunchTemplateDataEnclaveOptionsDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #enclaveOptions(AwsEc2LaunchTemplateDataEnclaveOptionsDetails)}.
         * 
         * @param enclaveOptions
         *        a consumer that will call methods on {@link AwsEc2LaunchTemplateDataEnclaveOptionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enclaveOptions(AwsEc2LaunchTemplateDataEnclaveOptionsDetails)
         */
        default Builder enclaveOptions(Consumer<AwsEc2LaunchTemplateDataEnclaveOptionsDetails.Builder> enclaveOptions) {
            return enclaveOptions(AwsEc2LaunchTemplateDataEnclaveOptionsDetails.builder().applyMutation(enclaveOptions).build());
        }

        /**
         * <p>
         * Specifies whether your Amazon EC2 instance is configured for hibernation.
         * </p>
         * 
         * @param hibernationOptions
         *        Specifies whether your Amazon EC2 instance is configured for hibernation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hibernationOptions(AwsEc2LaunchTemplateDataHibernationOptionsDetails hibernationOptions);

        /**
         * <p>
         * Specifies whether your Amazon EC2 instance is configured for hibernation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataHibernationOptionsDetails.Builder} avoiding the need to create one manually
         * via {@link AwsEc2LaunchTemplateDataHibernationOptionsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2LaunchTemplateDataHibernationOptionsDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #hibernationOptions(AwsEc2LaunchTemplateDataHibernationOptionsDetails)}.
         * 
         * @param hibernationOptions
         *        a consumer that will call methods on {@link AwsEc2LaunchTemplateDataHibernationOptionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hibernationOptions(AwsEc2LaunchTemplateDataHibernationOptionsDetails)
         */
        default Builder hibernationOptions(Consumer<AwsEc2LaunchTemplateDataHibernationOptionsDetails.Builder> hibernationOptions) {
            return hibernationOptions(AwsEc2LaunchTemplateDataHibernationOptionsDetails.builder()
                    .applyMutation(hibernationOptions).build());
        }

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of an IAM instance profile.
         * </p>
         * 
         * @param iamInstanceProfile
         *        The name or Amazon Resource Name (ARN) of an IAM instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfile(AwsEc2LaunchTemplateDataIamInstanceProfileDetails iamInstanceProfile);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of an IAM instance profile.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataIamInstanceProfileDetails.Builder} avoiding the need to create one manually
         * via {@link AwsEc2LaunchTemplateDataIamInstanceProfileDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2LaunchTemplateDataIamInstanceProfileDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #iamInstanceProfile(AwsEc2LaunchTemplateDataIamInstanceProfileDetails)}.
         * 
         * @param iamInstanceProfile
         *        a consumer that will call methods on {@link AwsEc2LaunchTemplateDataIamInstanceProfileDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamInstanceProfile(AwsEc2LaunchTemplateDataIamInstanceProfileDetails)
         */
        default Builder iamInstanceProfile(Consumer<AwsEc2LaunchTemplateDataIamInstanceProfileDetails.Builder> iamInstanceProfile) {
            return iamInstanceProfile(AwsEc2LaunchTemplateDataIamInstanceProfileDetails.builder()
                    .applyMutation(iamInstanceProfile).build());
        }

        /**
         * <p>
         * The ID of the Amazon Machine Image (AMI).
         * </p>
         * 
         * @param imageId
         *        The ID of the Amazon Machine Image (AMI).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * Provides the options for specifying the instance initiated shutdown behavior.
         * </p>
         * 
         * @param instanceInitiatedShutdownBehavior
         *        Provides the options for specifying the instance initiated shutdown behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior);

        /**
         * <p>
         * Specifies the market (purchasing) option for an instance.
         * </p>
         * 
         * @param instanceMarketOptions
         *        Specifies the market (purchasing) option for an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMarketOptions(AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails instanceMarketOptions);

        /**
         * <p>
         * Specifies the market (purchasing) option for an instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails.Builder} avoiding the need to create one manually
         * via {@link AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceMarketOptions(AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails)}.
         * 
         * @param instanceMarketOptions
         *        a consumer that will call methods on
         *        {@link AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceMarketOptions(AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails)
         */
        default Builder instanceMarketOptions(
                Consumer<AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails.Builder> instanceMarketOptions) {
            return instanceMarketOptions(AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails.builder()
                    .applyMutation(instanceMarketOptions).build());
        }

        /**
         * <p>
         * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
         * instance types with these attributes. If you specify <code>InstanceRequirements</code>, you can't specify
         * <code>InstanceType</code>.
         * </p>
         * 
         * @param instanceRequirements
         *        The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
         *        instance types with these attributes. If you specify <code>InstanceRequirements</code>, you can't
         *        specify <code>InstanceType</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRequirements(AwsEc2LaunchTemplateDataInstanceRequirementsDetails instanceRequirements);

        /**
         * <p>
         * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify
         * instance types with these attributes. If you specify <code>InstanceRequirements</code>, you can't specify
         * <code>InstanceType</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataInstanceRequirementsDetails.Builder} avoiding the need to create one manually
         * via {@link AwsEc2LaunchTemplateDataInstanceRequirementsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2LaunchTemplateDataInstanceRequirementsDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceRequirements(AwsEc2LaunchTemplateDataInstanceRequirementsDetails)}.
         * 
         * @param instanceRequirements
         *        a consumer that will call methods on
         *        {@link AwsEc2LaunchTemplateDataInstanceRequirementsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceRequirements(AwsEc2LaunchTemplateDataInstanceRequirementsDetails)
         */
        default Builder instanceRequirements(
                Consumer<AwsEc2LaunchTemplateDataInstanceRequirementsDetails.Builder> instanceRequirements) {
            return instanceRequirements(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.builder()
                    .applyMutation(instanceRequirements).build());
        }

        /**
         * <p>
         * The instance type. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in the
         * <i>Amazon EC2 User Guide</i>. If you specify <code>InstanceType</code>, you can't specify
         * <code>InstanceRequirements</code>.
         * </p>
         * 
         * @param instanceType
         *        The instance type. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance types</a> in
         *        the <i>Amazon EC2 User Guide</i>. If you specify <code>InstanceType</code>, you can't specify
         *        <code>InstanceRequirements</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The ID of the kernel.
         * </p>
         * 
         * @param kernelId
         *        The ID of the kernel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The name of the key pair that allows users to connect to the instance.
         * </p>
         * 
         * @param keyName
         *        The name of the key pair that allows users to connect to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);

        /**
         * <p>
         * Specifies a license configuration for an instance.
         * </p>
         * 
         * @param licenseSet
         *        Specifies a license configuration for an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseSet(Collection<AwsEc2LaunchTemplateDataLicenseSetDetails> licenseSet);

        /**
         * <p>
         * Specifies a license configuration for an instance.
         * </p>
         * 
         * @param licenseSet
         *        Specifies a license configuration for an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseSet(AwsEc2LaunchTemplateDataLicenseSetDetails... licenseSet);

        /**
         * <p>
         * Specifies a license configuration for an instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataLicenseSetDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataLicenseSetDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataLicenseSetDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #licenseSet(List<AwsEc2LaunchTemplateDataLicenseSetDetails>)}.
         * 
         * @param licenseSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataLicenseSetDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licenseSet(java.util.Collection<AwsEc2LaunchTemplateDataLicenseSetDetails>)
         */
        Builder licenseSet(Consumer<AwsEc2LaunchTemplateDataLicenseSetDetails.Builder>... licenseSet);

        /**
         * <p>
         * The maintenance options of your instance.
         * </p>
         * 
         * @param maintenanceOptions
         *        The maintenance options of your instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceOptions(AwsEc2LaunchTemplateDataMaintenanceOptionsDetails maintenanceOptions);

        /**
         * <p>
         * The maintenance options of your instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataMaintenanceOptionsDetails.Builder} avoiding the need to create one manually
         * via {@link AwsEc2LaunchTemplateDataMaintenanceOptionsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2LaunchTemplateDataMaintenanceOptionsDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #maintenanceOptions(AwsEc2LaunchTemplateDataMaintenanceOptionsDetails)}.
         * 
         * @param maintenanceOptions
         *        a consumer that will call methods on {@link AwsEc2LaunchTemplateDataMaintenanceOptionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceOptions(AwsEc2LaunchTemplateDataMaintenanceOptionsDetails)
         */
        default Builder maintenanceOptions(Consumer<AwsEc2LaunchTemplateDataMaintenanceOptionsDetails.Builder> maintenanceOptions) {
            return maintenanceOptions(AwsEc2LaunchTemplateDataMaintenanceOptionsDetails.builder()
                    .applyMutation(maintenanceOptions).build());
        }

        /**
         * <p>
         * The metadata options for the instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and
         * user data</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param metadataOptions
         *        The metadata options for the instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance
         *        metadata and user data</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataOptions(AwsEc2LaunchTemplateDataMetadataOptionsDetails metadataOptions);

        /**
         * <p>
         * The metadata options for the instance. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and
         * user data</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataMetadataOptionsDetails.Builder} avoiding the need to create one manually via
         * {@link AwsEc2LaunchTemplateDataMetadataOptionsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2LaunchTemplateDataMetadataOptionsDetails.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #metadataOptions(AwsEc2LaunchTemplateDataMetadataOptionsDetails)}.
         * 
         * @param metadataOptions
         *        a consumer that will call methods on {@link AwsEc2LaunchTemplateDataMetadataOptionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataOptions(AwsEc2LaunchTemplateDataMetadataOptionsDetails)
         */
        default Builder metadataOptions(Consumer<AwsEc2LaunchTemplateDataMetadataOptionsDetails.Builder> metadataOptions) {
            return metadataOptions(AwsEc2LaunchTemplateDataMetadataOptionsDetails.builder().applyMutation(metadataOptions)
                    .build());
        }

        /**
         * <p>
         * The monitoring for the instance.
         * </p>
         * 
         * @param monitoring
         *        The monitoring for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoring(AwsEc2LaunchTemplateDataMonitoringDetails monitoring);

        /**
         * <p>
         * The monitoring for the instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataMonitoringDetails.Builder} avoiding the need to create one manually via
         * {@link AwsEc2LaunchTemplateDataMonitoringDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2LaunchTemplateDataMonitoringDetails.Builder#build()} is
         * called immediately and its result is passed to {@link #monitoring(AwsEc2LaunchTemplateDataMonitoringDetails)}.
         * 
         * @param monitoring
         *        a consumer that will call methods on {@link AwsEc2LaunchTemplateDataMonitoringDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoring(AwsEc2LaunchTemplateDataMonitoringDetails)
         */
        default Builder monitoring(Consumer<AwsEc2LaunchTemplateDataMonitoringDetails.Builder> monitoring) {
            return monitoring(AwsEc2LaunchTemplateDataMonitoringDetails.builder().applyMutation(monitoring).build());
        }

        /**
         * <p>
         * Specifies the parameters for a network interface that is attached to the instance.
         * </p>
         * 
         * @param networkInterfaceSet
         *        Specifies the parameters for a network interface that is attached to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceSet(Collection<AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails> networkInterfaceSet);

        /**
         * <p>
         * Specifies the parameters for a network interface that is attached to the instance.
         * </p>
         * 
         * @param networkInterfaceSet
         *        Specifies the parameters for a network interface that is attached to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceSet(AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails... networkInterfaceSet);

        /**
         * <p>
         * Specifies the parameters for a network interface that is attached to the instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #networkInterfaceSet(List<AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails>)}.
         * 
         * @param networkInterfaceSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterfaceSet(java.util.Collection<AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails>)
         */
        Builder networkInterfaceSet(Consumer<AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails.Builder>... networkInterfaceSet);

        /**
         * <p>
         * Specifies the placement of an instance.
         * </p>
         * 
         * @param placement
         *        Specifies the placement of an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placement(AwsEc2LaunchTemplateDataPlacementDetails placement);

        /**
         * <p>
         * Specifies the placement of an instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataPlacementDetails.Builder} avoiding the need to create one manually via
         * {@link AwsEc2LaunchTemplateDataPlacementDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEc2LaunchTemplateDataPlacementDetails.Builder#build()} is
         * called immediately and its result is passed to {@link #placement(AwsEc2LaunchTemplateDataPlacementDetails)}.
         * 
         * @param placement
         *        a consumer that will call methods on {@link AwsEc2LaunchTemplateDataPlacementDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placement(AwsEc2LaunchTemplateDataPlacementDetails)
         */
        default Builder placement(Consumer<AwsEc2LaunchTemplateDataPlacementDetails.Builder> placement) {
            return placement(AwsEc2LaunchTemplateDataPlacementDetails.builder().applyMutation(placement).build());
        }

        /**
         * <p>
         * The options for the instance hostname.
         * </p>
         * 
         * @param privateDnsNameOptions
         *        The options for the instance hostname.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsNameOptions(AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails privateDnsNameOptions);

        /**
         * <p>
         * The options for the instance hostname.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails.Builder} avoiding the need to create one manually
         * via {@link AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #privateDnsNameOptions(AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails)}.
         * 
         * @param privateDnsNameOptions
         *        a consumer that will call methods on
         *        {@link AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateDnsNameOptions(AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails)
         */
        default Builder privateDnsNameOptions(
                Consumer<AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails.Builder> privateDnsNameOptions) {
            return privateDnsNameOptions(AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails.builder()
                    .applyMutation(privateDnsNameOptions).build());
        }

        /**
         * <p>
         * The ID of the RAM disk.
         * </p>
         * 
         * @param ramDiskId
         *        The ID of the RAM disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramDiskId(String ramDiskId);

        /**
         * <p>
         * One or more security group IDs.
         * </p>
         * 
         * @param securityGroupIdSet
         *        One or more security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIdSet(Collection<String> securityGroupIdSet);

        /**
         * <p>
         * One or more security group IDs.
         * </p>
         * 
         * @param securityGroupIdSet
         *        One or more security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIdSet(String... securityGroupIdSet);

        /**
         * <p>
         * One or more security group names. For a nondefault VPC, you must use security group IDs instead. You cannot
         * specify both a security group ID and security name in the same request.
         * </p>
         * 
         * @param securityGroupSet
         *        One or more security group names. For a nondefault VPC, you must use security group IDs instead. You
         *        cannot specify both a security group ID and security name in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupSet(Collection<String> securityGroupSet);

        /**
         * <p>
         * One or more security group names. For a nondefault VPC, you must use security group IDs instead. You cannot
         * specify both a security group ID and security name in the same request.
         * </p>
         * 
         * @param securityGroupSet
         *        One or more security group names. For a nondefault VPC, you must use security group IDs instead. You
         *        cannot specify both a security group ID and security name in the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupSet(String... securityGroupSet);

        /**
         * <p>
         * The user data to make available to the instance.
         * </p>
         * 
         * @param userData
         *        The user data to make available to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);
    }

    static final class BuilderImpl implements Builder {
        private List<AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails> blockDeviceMappingSet = DefaultSdkAutoConstructList
                .getInstance();

        private AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails capacityReservationSpecification;

        private AwsEc2LaunchTemplateDataCpuOptionsDetails cpuOptions;

        private AwsEc2LaunchTemplateDataCreditSpecificationDetails creditSpecification;

        private Boolean disableApiStop;

        private Boolean disableApiTermination;

        private Boolean ebsOptimized;

        private List<AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails> elasticGpuSpecificationSet = DefaultSdkAutoConstructList
                .getInstance();

        private List<AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails> elasticInferenceAcceleratorSet = DefaultSdkAutoConstructList
                .getInstance();

        private AwsEc2LaunchTemplateDataEnclaveOptionsDetails enclaveOptions;

        private AwsEc2LaunchTemplateDataHibernationOptionsDetails hibernationOptions;

        private AwsEc2LaunchTemplateDataIamInstanceProfileDetails iamInstanceProfile;

        private String imageId;

        private String instanceInitiatedShutdownBehavior;

        private AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails instanceMarketOptions;

        private AwsEc2LaunchTemplateDataInstanceRequirementsDetails instanceRequirements;

        private String instanceType;

        private String kernelId;

        private String keyName;

        private List<AwsEc2LaunchTemplateDataLicenseSetDetails> licenseSet = DefaultSdkAutoConstructList.getInstance();

        private AwsEc2LaunchTemplateDataMaintenanceOptionsDetails maintenanceOptions;

        private AwsEc2LaunchTemplateDataMetadataOptionsDetails metadataOptions;

        private AwsEc2LaunchTemplateDataMonitoringDetails monitoring;

        private List<AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails> networkInterfaceSet = DefaultSdkAutoConstructList
                .getInstance();

        private AwsEc2LaunchTemplateDataPlacementDetails placement;

        private AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails privateDnsNameOptions;

        private String ramDiskId;

        private List<String> securityGroupIdSet = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupSet = DefaultSdkAutoConstructList.getInstance();

        private String userData;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2LaunchTemplateDataDetails model) {
            blockDeviceMappingSet(model.blockDeviceMappingSet);
            capacityReservationSpecification(model.capacityReservationSpecification);
            cpuOptions(model.cpuOptions);
            creditSpecification(model.creditSpecification);
            disableApiStop(model.disableApiStop);
            disableApiTermination(model.disableApiTermination);
            ebsOptimized(model.ebsOptimized);
            elasticGpuSpecificationSet(model.elasticGpuSpecificationSet);
            elasticInferenceAcceleratorSet(model.elasticInferenceAcceleratorSet);
            enclaveOptions(model.enclaveOptions);
            hibernationOptions(model.hibernationOptions);
            iamInstanceProfile(model.iamInstanceProfile);
            imageId(model.imageId);
            instanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            instanceMarketOptions(model.instanceMarketOptions);
            instanceRequirements(model.instanceRequirements);
            instanceType(model.instanceType);
            kernelId(model.kernelId);
            keyName(model.keyName);
            licenseSet(model.licenseSet);
            maintenanceOptions(model.maintenanceOptions);
            metadataOptions(model.metadataOptions);
            monitoring(model.monitoring);
            networkInterfaceSet(model.networkInterfaceSet);
            placement(model.placement);
            privateDnsNameOptions(model.privateDnsNameOptions);
            ramDiskId(model.ramDiskId);
            securityGroupIdSet(model.securityGroupIdSet);
            securityGroupSet(model.securityGroupSet);
            userData(model.userData);
        }

        public final List<AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails.Builder> getBlockDeviceMappingSet() {
            List<AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails.Builder> result = AwsEc2LaunchTemplateDataBlockDeviceMappingSetListCopier
                    .copyToBuilder(this.blockDeviceMappingSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappingSet(
                Collection<AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails.BuilderImpl> blockDeviceMappingSet) {
            this.blockDeviceMappingSet = AwsEc2LaunchTemplateDataBlockDeviceMappingSetListCopier
                    .copyFromBuilder(blockDeviceMappingSet);
        }

        @Override
        public final Builder blockDeviceMappingSet(
                Collection<AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails> blockDeviceMappingSet) {
            this.blockDeviceMappingSet = AwsEc2LaunchTemplateDataBlockDeviceMappingSetListCopier.copy(blockDeviceMappingSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappingSet(AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails... blockDeviceMappingSet) {
            blockDeviceMappingSet(Arrays.asList(blockDeviceMappingSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappingSet(
                Consumer<AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails.Builder>... blockDeviceMappingSet) {
            blockDeviceMappingSet(Stream.of(blockDeviceMappingSet)
                    .map(c -> AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails.Builder getCapacityReservationSpecification() {
            return capacityReservationSpecification != null ? capacityReservationSpecification.toBuilder() : null;
        }

        public final void setCapacityReservationSpecification(
                AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails.BuilderImpl capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification != null ? capacityReservationSpecification
                    .build() : null;
        }

        @Override
        public final Builder capacityReservationSpecification(
                AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification;
            return this;
        }

        public final AwsEc2LaunchTemplateDataCpuOptionsDetails.Builder getCpuOptions() {
            return cpuOptions != null ? cpuOptions.toBuilder() : null;
        }

        public final void setCpuOptions(AwsEc2LaunchTemplateDataCpuOptionsDetails.BuilderImpl cpuOptions) {
            this.cpuOptions = cpuOptions != null ? cpuOptions.build() : null;
        }

        @Override
        public final Builder cpuOptions(AwsEc2LaunchTemplateDataCpuOptionsDetails cpuOptions) {
            this.cpuOptions = cpuOptions;
            return this;
        }

        public final AwsEc2LaunchTemplateDataCreditSpecificationDetails.Builder getCreditSpecification() {
            return creditSpecification != null ? creditSpecification.toBuilder() : null;
        }

        public final void setCreditSpecification(
                AwsEc2LaunchTemplateDataCreditSpecificationDetails.BuilderImpl creditSpecification) {
            this.creditSpecification = creditSpecification != null ? creditSpecification.build() : null;
        }

        @Override
        public final Builder creditSpecification(AwsEc2LaunchTemplateDataCreditSpecificationDetails creditSpecification) {
            this.creditSpecification = creditSpecification;
            return this;
        }

        public final Boolean getDisableApiStop() {
            return disableApiStop;
        }

        public final void setDisableApiStop(Boolean disableApiStop) {
            this.disableApiStop = disableApiStop;
        }

        @Override
        public final Builder disableApiStop(Boolean disableApiStop) {
            this.disableApiStop = disableApiStop;
            return this;
        }

        public final Boolean getDisableApiTermination() {
            return disableApiTermination;
        }

        public final void setDisableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
        }

        @Override
        public final Builder disableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final List<AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails.Builder> getElasticGpuSpecificationSet() {
            List<AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails.Builder> result = AwsEc2LaunchTemplateDataElasticGpuSpecificationSetListCopier
                    .copyToBuilder(this.elasticGpuSpecificationSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElasticGpuSpecificationSet(
                Collection<AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails.BuilderImpl> elasticGpuSpecificationSet) {
            this.elasticGpuSpecificationSet = AwsEc2LaunchTemplateDataElasticGpuSpecificationSetListCopier
                    .copyFromBuilder(elasticGpuSpecificationSet);
        }

        @Override
        public final Builder elasticGpuSpecificationSet(
                Collection<AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails> elasticGpuSpecificationSet) {
            this.elasticGpuSpecificationSet = AwsEc2LaunchTemplateDataElasticGpuSpecificationSetListCopier
                    .copy(elasticGpuSpecificationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSpecificationSet(
                AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails... elasticGpuSpecificationSet) {
            elasticGpuSpecificationSet(Arrays.asList(elasticGpuSpecificationSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSpecificationSet(
                Consumer<AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails.Builder>... elasticGpuSpecificationSet) {
            elasticGpuSpecificationSet(Stream.of(elasticGpuSpecificationSet)
                    .map(c -> AwsEc2LaunchTemplateDataElasticGpuSpecificationSetDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails.Builder> getElasticInferenceAcceleratorSet() {
            List<AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails.Builder> result = AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetListCopier
                    .copyToBuilder(this.elasticInferenceAcceleratorSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElasticInferenceAcceleratorSet(
                Collection<AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails.BuilderImpl> elasticInferenceAcceleratorSet) {
            this.elasticInferenceAcceleratorSet = AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetListCopier
                    .copyFromBuilder(elasticInferenceAcceleratorSet);
        }

        @Override
        public final Builder elasticInferenceAcceleratorSet(
                Collection<AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails> elasticInferenceAcceleratorSet) {
            this.elasticInferenceAcceleratorSet = AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetListCopier
                    .copy(elasticInferenceAcceleratorSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticInferenceAcceleratorSet(
                AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails... elasticInferenceAcceleratorSet) {
            elasticInferenceAcceleratorSet(Arrays.asList(elasticInferenceAcceleratorSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticInferenceAcceleratorSet(
                Consumer<AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails.Builder>... elasticInferenceAcceleratorSet) {
            elasticInferenceAcceleratorSet(Stream.of(elasticInferenceAcceleratorSet)
                    .map(c -> AwsEc2LaunchTemplateDataElasticInferenceAcceleratorSetDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AwsEc2LaunchTemplateDataEnclaveOptionsDetails.Builder getEnclaveOptions() {
            return enclaveOptions != null ? enclaveOptions.toBuilder() : null;
        }

        public final void setEnclaveOptions(AwsEc2LaunchTemplateDataEnclaveOptionsDetails.BuilderImpl enclaveOptions) {
            this.enclaveOptions = enclaveOptions != null ? enclaveOptions.build() : null;
        }

        @Override
        public final Builder enclaveOptions(AwsEc2LaunchTemplateDataEnclaveOptionsDetails enclaveOptions) {
            this.enclaveOptions = enclaveOptions;
            return this;
        }

        public final AwsEc2LaunchTemplateDataHibernationOptionsDetails.Builder getHibernationOptions() {
            return hibernationOptions != null ? hibernationOptions.toBuilder() : null;
        }

        public final void setHibernationOptions(AwsEc2LaunchTemplateDataHibernationOptionsDetails.BuilderImpl hibernationOptions) {
            this.hibernationOptions = hibernationOptions != null ? hibernationOptions.build() : null;
        }

        @Override
        public final Builder hibernationOptions(AwsEc2LaunchTemplateDataHibernationOptionsDetails hibernationOptions) {
            this.hibernationOptions = hibernationOptions;
            return this;
        }

        public final AwsEc2LaunchTemplateDataIamInstanceProfileDetails.Builder getIamInstanceProfile() {
            return iamInstanceProfile != null ? iamInstanceProfile.toBuilder() : null;
        }

        public final void setIamInstanceProfile(AwsEc2LaunchTemplateDataIamInstanceProfileDetails.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        @Override
        public final Builder iamInstanceProfile(AwsEc2LaunchTemplateDataIamInstanceProfileDetails iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getInstanceInitiatedShutdownBehavior() {
            return instanceInitiatedShutdownBehavior;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        public final AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails.Builder getInstanceMarketOptions() {
            return instanceMarketOptions != null ? instanceMarketOptions.toBuilder() : null;
        }

        public final void setInstanceMarketOptions(
                AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails.BuilderImpl instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions != null ? instanceMarketOptions.build() : null;
        }

        @Override
        public final Builder instanceMarketOptions(AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions;
            return this;
        }

        public final AwsEc2LaunchTemplateDataInstanceRequirementsDetails.Builder getInstanceRequirements() {
            return instanceRequirements != null ? instanceRequirements.toBuilder() : null;
        }

        public final void setInstanceRequirements(
                AwsEc2LaunchTemplateDataInstanceRequirementsDetails.BuilderImpl instanceRequirements) {
            this.instanceRequirements = instanceRequirements != null ? instanceRequirements.build() : null;
        }

        @Override
        public final Builder instanceRequirements(AwsEc2LaunchTemplateDataInstanceRequirementsDetails instanceRequirements) {
            this.instanceRequirements = instanceRequirements;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getKernelId() {
            return kernelId;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final String getKeyName() {
            return keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final List<AwsEc2LaunchTemplateDataLicenseSetDetails.Builder> getLicenseSet() {
            List<AwsEc2LaunchTemplateDataLicenseSetDetails.Builder> result = AwsEc2LaunchTemplateDataLicenseSetListCopier
                    .copyToBuilder(this.licenseSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseSet(Collection<AwsEc2LaunchTemplateDataLicenseSetDetails.BuilderImpl> licenseSet) {
            this.licenseSet = AwsEc2LaunchTemplateDataLicenseSetListCopier.copyFromBuilder(licenseSet);
        }

        @Override
        public final Builder licenseSet(Collection<AwsEc2LaunchTemplateDataLicenseSetDetails> licenseSet) {
            this.licenseSet = AwsEc2LaunchTemplateDataLicenseSetListCopier.copy(licenseSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSet(AwsEc2LaunchTemplateDataLicenseSetDetails... licenseSet) {
            licenseSet(Arrays.asList(licenseSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSet(Consumer<AwsEc2LaunchTemplateDataLicenseSetDetails.Builder>... licenseSet) {
            licenseSet(Stream.of(licenseSet)
                    .map(c -> AwsEc2LaunchTemplateDataLicenseSetDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AwsEc2LaunchTemplateDataMaintenanceOptionsDetails.Builder getMaintenanceOptions() {
            return maintenanceOptions != null ? maintenanceOptions.toBuilder() : null;
        }

        public final void setMaintenanceOptions(AwsEc2LaunchTemplateDataMaintenanceOptionsDetails.BuilderImpl maintenanceOptions) {
            this.maintenanceOptions = maintenanceOptions != null ? maintenanceOptions.build() : null;
        }

        @Override
        public final Builder maintenanceOptions(AwsEc2LaunchTemplateDataMaintenanceOptionsDetails maintenanceOptions) {
            this.maintenanceOptions = maintenanceOptions;
            return this;
        }

        public final AwsEc2LaunchTemplateDataMetadataOptionsDetails.Builder getMetadataOptions() {
            return metadataOptions != null ? metadataOptions.toBuilder() : null;
        }

        public final void setMetadataOptions(AwsEc2LaunchTemplateDataMetadataOptionsDetails.BuilderImpl metadataOptions) {
            this.metadataOptions = metadataOptions != null ? metadataOptions.build() : null;
        }

        @Override
        public final Builder metadataOptions(AwsEc2LaunchTemplateDataMetadataOptionsDetails metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        public final AwsEc2LaunchTemplateDataMonitoringDetails.Builder getMonitoring() {
            return monitoring != null ? monitoring.toBuilder() : null;
        }

        public final void setMonitoring(AwsEc2LaunchTemplateDataMonitoringDetails.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        @Override
        public final Builder monitoring(AwsEc2LaunchTemplateDataMonitoringDetails monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final List<AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails.Builder> getNetworkInterfaceSet() {
            List<AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails.Builder> result = AwsEc2LaunchTemplateDataNetworkInterfaceSetListCopier
                    .copyToBuilder(this.networkInterfaceSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfaceSet(
                Collection<AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails.BuilderImpl> networkInterfaceSet) {
            this.networkInterfaceSet = AwsEc2LaunchTemplateDataNetworkInterfaceSetListCopier.copyFromBuilder(networkInterfaceSet);
        }

        @Override
        public final Builder networkInterfaceSet(
                Collection<AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails> networkInterfaceSet) {
            this.networkInterfaceSet = AwsEc2LaunchTemplateDataNetworkInterfaceSetListCopier.copy(networkInterfaceSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaceSet(AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails... networkInterfaceSet) {
            networkInterfaceSet(Arrays.asList(networkInterfaceSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaceSet(
                Consumer<AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails.Builder>... networkInterfaceSet) {
            networkInterfaceSet(Stream.of(networkInterfaceSet)
                    .map(c -> AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AwsEc2LaunchTemplateDataPlacementDetails.Builder getPlacement() {
            return placement != null ? placement.toBuilder() : null;
        }

        public final void setPlacement(AwsEc2LaunchTemplateDataPlacementDetails.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        @Override
        public final Builder placement(AwsEc2LaunchTemplateDataPlacementDetails placement) {
            this.placement = placement;
            return this;
        }

        public final AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails.Builder getPrivateDnsNameOptions() {
            return privateDnsNameOptions != null ? privateDnsNameOptions.toBuilder() : null;
        }

        public final void setPrivateDnsNameOptions(
                AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails.BuilderImpl privateDnsNameOptions) {
            this.privateDnsNameOptions = privateDnsNameOptions != null ? privateDnsNameOptions.build() : null;
        }

        @Override
        public final Builder privateDnsNameOptions(AwsEc2LaunchTemplateDataPrivateDnsNameOptionsDetails privateDnsNameOptions) {
            this.privateDnsNameOptions = privateDnsNameOptions;
            return this;
        }

        public final String getRamDiskId() {
            return ramDiskId;
        }

        public final void setRamDiskId(String ramDiskId) {
            this.ramDiskId = ramDiskId;
        }

        @Override
        public final Builder ramDiskId(String ramDiskId) {
            this.ramDiskId = ramDiskId;
            return this;
        }

        public final Collection<String> getSecurityGroupIdSet() {
            if (securityGroupIdSet instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIdSet;
        }

        public final void setSecurityGroupIdSet(Collection<String> securityGroupIdSet) {
            this.securityGroupIdSet = NonEmptyStringListCopier.copy(securityGroupIdSet);
        }

        @Override
        public final Builder securityGroupIdSet(Collection<String> securityGroupIdSet) {
            this.securityGroupIdSet = NonEmptyStringListCopier.copy(securityGroupIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIdSet(String... securityGroupIdSet) {
            securityGroupIdSet(Arrays.asList(securityGroupIdSet));
            return this;
        }

        public final Collection<String> getSecurityGroupSet() {
            if (securityGroupSet instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupSet;
        }

        public final void setSecurityGroupSet(Collection<String> securityGroupSet) {
            this.securityGroupSet = NonEmptyStringListCopier.copy(securityGroupSet);
        }

        @Override
        public final Builder securityGroupSet(Collection<String> securityGroupSet) {
            this.securityGroupSet = NonEmptyStringListCopier.copy(securityGroupSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupSet(String... securityGroupSet) {
            securityGroupSet(Arrays.asList(securityGroupSet));
            return this;
        }

        public final String getUserData() {
            return userData;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        @Override
        public AwsEc2LaunchTemplateDataDetails build() {
            return new AwsEc2LaunchTemplateDataDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
