/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A custom origin. A custom origin is any origin that is not an Amazon S3 bucket, with one exception. An Amazon S3
 * bucket that is <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/WebsiteHosting.html">configured with static
 * website hosting</a> is a custom origin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCloudFrontDistributionOriginCustomOriginConfig
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsCloudFrontDistributionOriginCustomOriginConfig.Builder, AwsCloudFrontDistributionOriginCustomOriginConfig> {
    private static final SdkField<Integer> HTTP_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HttpPort").getter(getter(AwsCloudFrontDistributionOriginCustomOriginConfig::httpPort))
            .setter(setter(Builder::httpPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpPort").build()).build();

    private static final SdkField<Integer> HTTPS_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HttpsPort").getter(getter(AwsCloudFrontDistributionOriginCustomOriginConfig::httpsPort))
            .setter(setter(Builder::httpsPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpsPort").build()).build();

    private static final SdkField<Integer> ORIGIN_KEEPALIVE_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("OriginKeepaliveTimeout")
            .getter(getter(AwsCloudFrontDistributionOriginCustomOriginConfig::originKeepaliveTimeout))
            .setter(setter(Builder::originKeepaliveTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginKeepaliveTimeout").build())
            .build();

    private static final SdkField<String> ORIGIN_PROTOCOL_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginProtocolPolicy")
            .getter(getter(AwsCloudFrontDistributionOriginCustomOriginConfig::originProtocolPolicy))
            .setter(setter(Builder::originProtocolPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginProtocolPolicy").build())
            .build();

    private static final SdkField<Integer> ORIGIN_READ_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("OriginReadTimeout").getter(getter(AwsCloudFrontDistributionOriginCustomOriginConfig::originReadTimeout))
            .setter(setter(Builder::originReadTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginReadTimeout").build()).build();

    private static final SdkField<AwsCloudFrontDistributionOriginSslProtocols> ORIGIN_SSL_PROTOCOLS_FIELD = SdkField
            .<AwsCloudFrontDistributionOriginSslProtocols> builder(MarshallingType.SDK_POJO).memberName("OriginSslProtocols")
            .getter(getter(AwsCloudFrontDistributionOriginCustomOriginConfig::originSslProtocols))
            .setter(setter(Builder::originSslProtocols)).constructor(AwsCloudFrontDistributionOriginSslProtocols::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginSslProtocols").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_PORT_FIELD,
            HTTPS_PORT_FIELD, ORIGIN_KEEPALIVE_TIMEOUT_FIELD, ORIGIN_PROTOCOL_POLICY_FIELD, ORIGIN_READ_TIMEOUT_FIELD,
            ORIGIN_SSL_PROTOCOLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer httpPort;

    private final Integer httpsPort;

    private final Integer originKeepaliveTimeout;

    private final String originProtocolPolicy;

    private final Integer originReadTimeout;

    private final AwsCloudFrontDistributionOriginSslProtocols originSslProtocols;

    private AwsCloudFrontDistributionOriginCustomOriginConfig(BuilderImpl builder) {
        this.httpPort = builder.httpPort;
        this.httpsPort = builder.httpsPort;
        this.originKeepaliveTimeout = builder.originKeepaliveTimeout;
        this.originProtocolPolicy = builder.originProtocolPolicy;
        this.originReadTimeout = builder.originReadTimeout;
        this.originSslProtocols = builder.originSslProtocols;
    }

    /**
     * <p>
     * The HTTP port that CloudFront uses to connect to the origin.
     * </p>
     * 
     * @return The HTTP port that CloudFront uses to connect to the origin.
     */
    public final Integer httpPort() {
        return httpPort;
    }

    /**
     * <p>
     * The HTTPS port that CloudFront uses to connect to the origin.
     * </p>
     * 
     * @return The HTTPS port that CloudFront uses to connect to the origin.
     */
    public final Integer httpsPort() {
        return httpsPort;
    }

    /**
     * <p>
     * Specifies how long, in seconds, CloudFront persists its connection to the origin.
     * </p>
     * 
     * @return Specifies how long, in seconds, CloudFront persists its connection to the origin.
     */
    public final Integer originKeepaliveTimeout() {
        return originKeepaliveTimeout;
    }

    /**
     * <p>
     * Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin.
     * </p>
     * 
     * @return Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin.
     */
    public final String originProtocolPolicy() {
        return originProtocolPolicy;
    }

    /**
     * <p>
     * Specifies how long, in seconds, CloudFront waits for a response from the origin.
     * </p>
     * 
     * @return Specifies how long, in seconds, CloudFront waits for a response from the origin.
     */
    public final Integer originReadTimeout() {
        return originReadTimeout;
    }

    /**
     * <p>
     * Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS.
     * </p>
     * 
     * @return Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS.
     */
    public final AwsCloudFrontDistributionOriginSslProtocols originSslProtocols() {
        return originSslProtocols;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(httpPort());
        hashCode = 31 * hashCode + Objects.hashCode(httpsPort());
        hashCode = 31 * hashCode + Objects.hashCode(originKeepaliveTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(originProtocolPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(originReadTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(originSslProtocols());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFrontDistributionOriginCustomOriginConfig)) {
            return false;
        }
        AwsCloudFrontDistributionOriginCustomOriginConfig other = (AwsCloudFrontDistributionOriginCustomOriginConfig) obj;
        return Objects.equals(httpPort(), other.httpPort()) && Objects.equals(httpsPort(), other.httpsPort())
                && Objects.equals(originKeepaliveTimeout(), other.originKeepaliveTimeout())
                && Objects.equals(originProtocolPolicy(), other.originProtocolPolicy())
                && Objects.equals(originReadTimeout(), other.originReadTimeout())
                && Objects.equals(originSslProtocols(), other.originSslProtocols());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCloudFrontDistributionOriginCustomOriginConfig").add("HttpPort", httpPort())
                .add("HttpsPort", httpsPort()).add("OriginKeepaliveTimeout", originKeepaliveTimeout())
                .add("OriginProtocolPolicy", originProtocolPolicy()).add("OriginReadTimeout", originReadTimeout())
                .add("OriginSslProtocols", originSslProtocols()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HttpPort":
            return Optional.ofNullable(clazz.cast(httpPort()));
        case "HttpsPort":
            return Optional.ofNullable(clazz.cast(httpsPort()));
        case "OriginKeepaliveTimeout":
            return Optional.ofNullable(clazz.cast(originKeepaliveTimeout()));
        case "OriginProtocolPolicy":
            return Optional.ofNullable(clazz.cast(originProtocolPolicy()));
        case "OriginReadTimeout":
            return Optional.ofNullable(clazz.cast(originReadTimeout()));
        case "OriginSslProtocols":
            return Optional.ofNullable(clazz.cast(originSslProtocols()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFrontDistributionOriginCustomOriginConfig, T> g) {
        return obj -> g.apply((AwsCloudFrontDistributionOriginCustomOriginConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCloudFrontDistributionOriginCustomOriginConfig> {
        /**
         * <p>
         * The HTTP port that CloudFront uses to connect to the origin.
         * </p>
         * 
         * @param httpPort
         *        The HTTP port that CloudFront uses to connect to the origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpPort(Integer httpPort);

        /**
         * <p>
         * The HTTPS port that CloudFront uses to connect to the origin.
         * </p>
         * 
         * @param httpsPort
         *        The HTTPS port that CloudFront uses to connect to the origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpsPort(Integer httpsPort);

        /**
         * <p>
         * Specifies how long, in seconds, CloudFront persists its connection to the origin.
         * </p>
         * 
         * @param originKeepaliveTimeout
         *        Specifies how long, in seconds, CloudFront persists its connection to the origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originKeepaliveTimeout(Integer originKeepaliveTimeout);

        /**
         * <p>
         * Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin.
         * </p>
         * 
         * @param originProtocolPolicy
         *        Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originProtocolPolicy(String originProtocolPolicy);

        /**
         * <p>
         * Specifies how long, in seconds, CloudFront waits for a response from the origin.
         * </p>
         * 
         * @param originReadTimeout
         *        Specifies how long, in seconds, CloudFront waits for a response from the origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originReadTimeout(Integer originReadTimeout);

        /**
         * <p>
         * Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS.
         * </p>
         * 
         * @param originSslProtocols
         *        Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originSslProtocols(AwsCloudFrontDistributionOriginSslProtocols originSslProtocols);

        /**
         * <p>
         * Specifies the minimum SSL/TLS protocol that CloudFront uses when connecting to your origin over HTTPS.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsCloudFrontDistributionOriginSslProtocols.Builder} avoiding the need to create one manually via
         * {@link AwsCloudFrontDistributionOriginSslProtocols#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCloudFrontDistributionOriginSslProtocols.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #originSslProtocols(AwsCloudFrontDistributionOriginSslProtocols)}.
         * 
         * @param originSslProtocols
         *        a consumer that will call methods on {@link AwsCloudFrontDistributionOriginSslProtocols.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originSslProtocols(AwsCloudFrontDistributionOriginSslProtocols)
         */
        default Builder originSslProtocols(Consumer<AwsCloudFrontDistributionOriginSslProtocols.Builder> originSslProtocols) {
            return originSslProtocols(AwsCloudFrontDistributionOriginSslProtocols.builder().applyMutation(originSslProtocols)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer httpPort;

        private Integer httpsPort;

        private Integer originKeepaliveTimeout;

        private String originProtocolPolicy;

        private Integer originReadTimeout;

        private AwsCloudFrontDistributionOriginSslProtocols originSslProtocols;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFrontDistributionOriginCustomOriginConfig model) {
            httpPort(model.httpPort);
            httpsPort(model.httpsPort);
            originKeepaliveTimeout(model.originKeepaliveTimeout);
            originProtocolPolicy(model.originProtocolPolicy);
            originReadTimeout(model.originReadTimeout);
            originSslProtocols(model.originSslProtocols);
        }

        public final Integer getHttpPort() {
            return httpPort;
        }

        public final void setHttpPort(Integer httpPort) {
            this.httpPort = httpPort;
        }

        @Override
        public final Builder httpPort(Integer httpPort) {
            this.httpPort = httpPort;
            return this;
        }

        public final Integer getHttpsPort() {
            return httpsPort;
        }

        public final void setHttpsPort(Integer httpsPort) {
            this.httpsPort = httpsPort;
        }

        @Override
        public final Builder httpsPort(Integer httpsPort) {
            this.httpsPort = httpsPort;
            return this;
        }

        public final Integer getOriginKeepaliveTimeout() {
            return originKeepaliveTimeout;
        }

        public final void setOriginKeepaliveTimeout(Integer originKeepaliveTimeout) {
            this.originKeepaliveTimeout = originKeepaliveTimeout;
        }

        @Override
        public final Builder originKeepaliveTimeout(Integer originKeepaliveTimeout) {
            this.originKeepaliveTimeout = originKeepaliveTimeout;
            return this;
        }

        public final String getOriginProtocolPolicy() {
            return originProtocolPolicy;
        }

        public final void setOriginProtocolPolicy(String originProtocolPolicy) {
            this.originProtocolPolicy = originProtocolPolicy;
        }

        @Override
        public final Builder originProtocolPolicy(String originProtocolPolicy) {
            this.originProtocolPolicy = originProtocolPolicy;
            return this;
        }

        public final Integer getOriginReadTimeout() {
            return originReadTimeout;
        }

        public final void setOriginReadTimeout(Integer originReadTimeout) {
            this.originReadTimeout = originReadTimeout;
        }

        @Override
        public final Builder originReadTimeout(Integer originReadTimeout) {
            this.originReadTimeout = originReadTimeout;
            return this;
        }

        public final AwsCloudFrontDistributionOriginSslProtocols.Builder getOriginSslProtocols() {
            return originSslProtocols != null ? originSslProtocols.toBuilder() : null;
        }

        public final void setOriginSslProtocols(AwsCloudFrontDistributionOriginSslProtocols.BuilderImpl originSslProtocols) {
            this.originSslProtocols = originSslProtocols != null ? originSslProtocols.build() : null;
        }

        @Override
        public final Builder originSslProtocols(AwsCloudFrontDistributionOriginSslProtocols originSslProtocols) {
            this.originSslProtocols = originSslProtocols;
            return this;
        }

        @Override
        public AwsCloudFrontDistributionOriginCustomOriginConfig build() {
            return new AwsCloudFrontDistributionOriginCustomOriginConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
