/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An array of <code>CopyAction</code> objects, each of which contains details of the copy operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsBackupBackupPlanRuleCopyActionsDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsBackupBackupPlanRuleCopyActionsDetails.Builder, AwsBackupBackupPlanRuleCopyActionsDetails> {
    private static final SdkField<String> DESTINATION_BACKUP_VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationBackupVaultArn")
            .getter(getter(AwsBackupBackupPlanRuleCopyActionsDetails::destinationBackupVaultArn))
            .setter(setter(Builder::destinationBackupVaultArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationBackupVaultArn").build())
            .build();

    private static final SdkField<AwsBackupBackupPlanLifecycleDetails> LIFECYCLE_FIELD = SdkField
            .<AwsBackupBackupPlanLifecycleDetails> builder(MarshallingType.SDK_POJO).memberName("Lifecycle")
            .getter(getter(AwsBackupBackupPlanRuleCopyActionsDetails::lifecycle)).setter(setter(Builder::lifecycle))
            .constructor(AwsBackupBackupPlanLifecycleDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DESTINATION_BACKUP_VAULT_ARN_FIELD, LIFECYCLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destinationBackupVaultArn;

    private final AwsBackupBackupPlanLifecycleDetails lifecycle;

    private AwsBackupBackupPlanRuleCopyActionsDetails(BuilderImpl builder) {
        this.destinationBackupVaultArn = builder.destinationBackupVaultArn;
        this.lifecycle = builder.lifecycle;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied backup.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied
     *         backup.
     */
    public final String destinationBackupVaultArn() {
        return destinationBackupVaultArn;
    }

    /**
     * <p>
     * Defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and
     * expires backups automatically according to the lifecycle that you define. If you do not specify a lifecycle,
     * Backup applies the lifecycle policy of the source backup to the destination backup.
     * </p>
     * <p>
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
     * </p>
     * 
     * @return Defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions
     *         and expires backups automatically according to the lifecycle that you define. If you do not specify a
     *         lifecycle, Backup applies the lifecycle policy of the source backup to the destination backup.</p>
     *         <p>
     *         Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
     */
    public final AwsBackupBackupPlanLifecycleDetails lifecycle() {
        return lifecycle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationBackupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycle());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsBackupBackupPlanRuleCopyActionsDetails)) {
            return false;
        }
        AwsBackupBackupPlanRuleCopyActionsDetails other = (AwsBackupBackupPlanRuleCopyActionsDetails) obj;
        return Objects.equals(destinationBackupVaultArn(), other.destinationBackupVaultArn())
                && Objects.equals(lifecycle(), other.lifecycle());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsBackupBackupPlanRuleCopyActionsDetails")
                .add("DestinationBackupVaultArn", destinationBackupVaultArn()).add("Lifecycle", lifecycle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationBackupVaultArn":
            return Optional.ofNullable(clazz.cast(destinationBackupVaultArn()));
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycle()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsBackupBackupPlanRuleCopyActionsDetails, T> g) {
        return obj -> g.apply((AwsBackupBackupPlanRuleCopyActionsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsBackupBackupPlanRuleCopyActionsDetails> {
        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied backup.
         * </p>
         * 
         * @param destinationBackupVaultArn
         *        An Amazon Resource Name (ARN) that uniquely identifies the destination backup vault for the copied
         *        backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationBackupVaultArn(String destinationBackupVaultArn);

        /**
         * <p>
         * Defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and
         * expires backups automatically according to the lifecycle that you define. If you do not specify a lifecycle,
         * Backup applies the lifecycle policy of the source backup to the destination backup.
         * </p>
         * <p>
         * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
         * </p>
         * 
         * @param lifecycle
         *        Defines when a protected resource is transitioned to cold storage and when it expires. Backup
         *        transitions and expires backups automatically according to the lifecycle that you define. If you do
         *        not specify a lifecycle, Backup applies the lifecycle policy of the source backup to the destination
         *        backup.</p>
         *        <p>
         *        Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycle(AwsBackupBackupPlanLifecycleDetails lifecycle);

        /**
         * <p>
         * Defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and
         * expires backups automatically according to the lifecycle that you define. If you do not specify a lifecycle,
         * Backup applies the lifecycle policy of the source backup to the destination backup.
         * </p>
         * <p>
         * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsBackupBackupPlanLifecycleDetails.Builder} avoiding the need to create one manually via
         * {@link AwsBackupBackupPlanLifecycleDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsBackupBackupPlanLifecycleDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #lifecycle(AwsBackupBackupPlanLifecycleDetails)}.
         * 
         * @param lifecycle
         *        a consumer that will call methods on {@link AwsBackupBackupPlanLifecycleDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycle(AwsBackupBackupPlanLifecycleDetails)
         */
        default Builder lifecycle(Consumer<AwsBackupBackupPlanLifecycleDetails.Builder> lifecycle) {
            return lifecycle(AwsBackupBackupPlanLifecycleDetails.builder().applyMutation(lifecycle).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String destinationBackupVaultArn;

        private AwsBackupBackupPlanLifecycleDetails lifecycle;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsBackupBackupPlanRuleCopyActionsDetails model) {
            destinationBackupVaultArn(model.destinationBackupVaultArn);
            lifecycle(model.lifecycle);
        }

        public final String getDestinationBackupVaultArn() {
            return destinationBackupVaultArn;
        }

        public final void setDestinationBackupVaultArn(String destinationBackupVaultArn) {
            this.destinationBackupVaultArn = destinationBackupVaultArn;
        }

        @Override
        public final Builder destinationBackupVaultArn(String destinationBackupVaultArn) {
            this.destinationBackupVaultArn = destinationBackupVaultArn;
            return this;
        }

        public final AwsBackupBackupPlanLifecycleDetails.Builder getLifecycle() {
            return lifecycle != null ? lifecycle.toBuilder() : null;
        }

        public final void setLifecycle(AwsBackupBackupPlanLifecycleDetails.BuilderImpl lifecycle) {
            this.lifecycle = lifecycle != null ? lifecycle.build() : null;
        }

        @Override
        public final Builder lifecycle(AwsBackupBackupPlanLifecycleDetails lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public AwsBackupBackupPlanRuleCopyActionsDetails build() {
            return new AwsBackupBackupPlanRuleCopyActionsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
