/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2LaunchTemplateDataInstanceRequirementsDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2LaunchTemplateDataInstanceRequirementsDetails> {
    private static final SdkField<AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails> ACCELERATOR_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AcceleratorCount").getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::acceleratorCount)).setter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.setter(Builder::acceleratorCount)).constructor(AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorCount").build()}).build();
    private static final SdkField<List<String>> ACCELERATOR_MANUFACTURERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AcceleratorManufacturers").getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::acceleratorManufacturers)).setter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.setter(Builder::acceleratorManufacturers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorManufacturers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ACCELERATOR_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AcceleratorNames").getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::acceleratorNames)).setter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.setter(Builder::acceleratorNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails> ACCELERATOR_TOTAL_MEMORY_MIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AcceleratorTotalMemoryMiB").getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::acceleratorTotalMemoryMiB)).setter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.setter(Builder::acceleratorTotalMemoryMiB)).constructor(AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorTotalMemoryMiB").build()}).build();
    private static final SdkField<List<String>> ACCELERATOR_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AcceleratorTypes").getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::acceleratorTypes)).setter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.setter(Builder::acceleratorTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BARE_METAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BareMetal").getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::bareMetal)).setter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.setter(Builder::bareMetal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BareMetal").build()}).build();
    private static final SdkField<AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails> BASELINE_EBS_BANDWIDTH_MBPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BaselineEbsBandwidthMbps").getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::baselineEbsBandwidthMbps)).setter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.setter(Builder::baselineEbsBandwidthMbps)).constructor(AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineEbsBandwidthMbps").build()}).build();
    private static final SdkField<String> BURSTABLE_PERFORMANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BurstablePerformance").getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::burstablePerformance)).setter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.setter(Builder::burstablePerformance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BurstablePerformance").build()}).build();
    private static final SdkField<List<String>> CPU_MANUFACTURERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CpuManufacturers").getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::cpuManufacturers)).setter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.setter(Builder::cpuManufacturers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuManufacturers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDED_INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludedInstanceTypes").getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::excludedInstanceTypes)).setter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.setter(Builder::excludedInstanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedInstanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INSTANCE_GENERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceGenerations").getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::instanceGenerations)).setter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.setter(Builder::instanceGenerations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGenerations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LOCAL_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalStorage").getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::localStorage)).setter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.setter(Builder::localStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalStorage").build()}).build();
    private static final SdkField<List<String>> LOCAL_STORAGE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LocalStorageTypes").getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::localStorageTypes)).setter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.setter(Builder::localStorageTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalStorageTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails> MEMORY_GI_B_PER_V_CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MemoryGiBPerVCpu").getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::memoryGiBPerVCpu)).setter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.setter(Builder::memoryGiBPerVCpu)).constructor(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryGiBPerVCpu").build()}).build();
    private static final SdkField<AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails> MEMORY_MIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MemoryMiB").getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::memoryMiB)).setter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.setter(Builder::memoryMiB)).constructor(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryMiB").build()}).build();
    private static final SdkField<AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails> NETWORK_INTERFACE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkInterfaceCount").getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::networkInterfaceCount)).setter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.setter(Builder::networkInterfaceCount)).constructor(AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceCount").build()}).build();
    private static final SdkField<Integer> ON_DEMAND_MAX_PRICE_PERCENTAGE_OVER_LOWEST_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OnDemandMaxPricePercentageOverLowestPrice").getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::onDemandMaxPricePercentageOverLowestPrice)).setter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.setter(Builder::onDemandMaxPricePercentageOverLowestPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandMaxPricePercentageOverLowestPrice").build()}).build();
    private static final SdkField<Boolean> REQUIRE_HIBERNATE_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequireHibernateSupport").getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::requireHibernateSupport)).setter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.setter(Builder::requireHibernateSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireHibernateSupport").build()}).build();
    private static final SdkField<Integer> SPOT_MAX_PRICE_PERCENTAGE_OVER_LOWEST_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SpotMaxPricePercentageOverLowestPrice").getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::spotMaxPricePercentageOverLowestPrice)).setter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.setter(Builder::spotMaxPricePercentageOverLowestPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotMaxPricePercentageOverLowestPrice").build()}).build();
    private static final SdkField<AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails> TOTAL_LOCAL_STORAGE_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TotalLocalStorageGB").getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::totalLocalStorageGB)).setter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.setter(Builder::totalLocalStorageGB)).constructor(AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalLocalStorageGB").build()}).build();
    private static final SdkField<AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails> V_CPU_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VCpuCount").getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::vCpuCount)).setter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails.setter(Builder::vCpuCount)).constructor(AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VCpuCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_COUNT_FIELD, ACCELERATOR_MANUFACTURERS_FIELD, ACCELERATOR_NAMES_FIELD, ACCELERATOR_TOTAL_MEMORY_MIB_FIELD, ACCELERATOR_TYPES_FIELD, BARE_METAL_FIELD, BASELINE_EBS_BANDWIDTH_MBPS_FIELD, BURSTABLE_PERFORMANCE_FIELD, CPU_MANUFACTURERS_FIELD, EXCLUDED_INSTANCE_TYPES_FIELD, INSTANCE_GENERATIONS_FIELD, LOCAL_STORAGE_FIELD, LOCAL_STORAGE_TYPES_FIELD, MEMORY_GI_B_PER_V_CPU_FIELD, MEMORY_MIB_FIELD, NETWORK_INTERFACE_COUNT_FIELD, ON_DEMAND_MAX_PRICE_PERCENTAGE_OVER_LOWEST_PRICE_FIELD, REQUIRE_HIBERNATE_SUPPORT_FIELD, SPOT_MAX_PRICE_PERCENTAGE_OVER_LOWEST_PRICE_FIELD, TOTAL_LOCAL_STORAGE_GB_FIELD, V_CPU_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails acceleratorCount;
    private final List<String> acceleratorManufacturers;
    private final List<String> acceleratorNames;
    private final AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails acceleratorTotalMemoryMiB;
    private final List<String> acceleratorTypes;
    private final String bareMetal;
    private final AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails baselineEbsBandwidthMbps;
    private final String burstablePerformance;
    private final List<String> cpuManufacturers;
    private final List<String> excludedInstanceTypes;
    private final List<String> instanceGenerations;
    private final String localStorage;
    private final List<String> localStorageTypes;
    private final AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails memoryGiBPerVCpu;
    private final AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails memoryMiB;
    private final AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails networkInterfaceCount;
    private final Integer onDemandMaxPricePercentageOverLowestPrice;
    private final Boolean requireHibernateSupport;
    private final Integer spotMaxPricePercentageOverLowestPrice;
    private final AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails totalLocalStorageGB;
    private final AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails vCpuCount;

    private AwsEc2LaunchTemplateDataInstanceRequirementsDetails(BuilderImpl builder) {
        this.acceleratorCount = builder.acceleratorCount;
        this.acceleratorManufacturers = builder.acceleratorManufacturers;
        this.acceleratorNames = builder.acceleratorNames;
        this.acceleratorTotalMemoryMiB = builder.acceleratorTotalMemoryMiB;
        this.acceleratorTypes = builder.acceleratorTypes;
        this.bareMetal = builder.bareMetal;
        this.baselineEbsBandwidthMbps = builder.baselineEbsBandwidthMbps;
        this.burstablePerformance = builder.burstablePerformance;
        this.cpuManufacturers = builder.cpuManufacturers;
        this.excludedInstanceTypes = builder.excludedInstanceTypes;
        this.instanceGenerations = builder.instanceGenerations;
        this.localStorage = builder.localStorage;
        this.localStorageTypes = builder.localStorageTypes;
        this.memoryGiBPerVCpu = builder.memoryGiBPerVCpu;
        this.memoryMiB = builder.memoryMiB;
        this.networkInterfaceCount = builder.networkInterfaceCount;
        this.onDemandMaxPricePercentageOverLowestPrice = builder.onDemandMaxPricePercentageOverLowestPrice;
        this.requireHibernateSupport = builder.requireHibernateSupport;
        this.spotMaxPricePercentageOverLowestPrice = builder.spotMaxPricePercentageOverLowestPrice;
        this.totalLocalStorageGB = builder.totalLocalStorageGB;
        this.vCpuCount = builder.vCpuCount;
    }

    public final AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails acceleratorCount() {
        return this.acceleratorCount;
    }

    public final boolean hasAcceleratorManufacturers() {
        return this.acceleratorManufacturers != null && !(this.acceleratorManufacturers instanceof SdkAutoConstructList);
    }

    public final List<String> acceleratorManufacturers() {
        return this.acceleratorManufacturers;
    }

    public final boolean hasAcceleratorNames() {
        return this.acceleratorNames != null && !(this.acceleratorNames instanceof SdkAutoConstructList);
    }

    public final List<String> acceleratorNames() {
        return this.acceleratorNames;
    }

    public final AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails acceleratorTotalMemoryMiB() {
        return this.acceleratorTotalMemoryMiB;
    }

    public final boolean hasAcceleratorTypes() {
        return this.acceleratorTypes != null && !(this.acceleratorTypes instanceof SdkAutoConstructList);
    }

    public final List<String> acceleratorTypes() {
        return this.acceleratorTypes;
    }

    public final String bareMetal() {
        return this.bareMetal;
    }

    public final AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails baselineEbsBandwidthMbps() {
        return this.baselineEbsBandwidthMbps;
    }

    public final String burstablePerformance() {
        return this.burstablePerformance;
    }

    public final boolean hasCpuManufacturers() {
        return this.cpuManufacturers != null && !(this.cpuManufacturers instanceof SdkAutoConstructList);
    }

    public final List<String> cpuManufacturers() {
        return this.cpuManufacturers;
    }

    public final boolean hasExcludedInstanceTypes() {
        return this.excludedInstanceTypes != null && !(this.excludedInstanceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> excludedInstanceTypes() {
        return this.excludedInstanceTypes;
    }

    public final boolean hasInstanceGenerations() {
        return this.instanceGenerations != null && !(this.instanceGenerations instanceof SdkAutoConstructList);
    }

    public final List<String> instanceGenerations() {
        return this.instanceGenerations;
    }

    public final String localStorage() {
        return this.localStorage;
    }

    public final boolean hasLocalStorageTypes() {
        return this.localStorageTypes != null && !(this.localStorageTypes instanceof SdkAutoConstructList);
    }

    public final List<String> localStorageTypes() {
        return this.localStorageTypes;
    }

    public final AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails memoryGiBPerVCpu() {
        return this.memoryGiBPerVCpu;
    }

    public final AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails memoryMiB() {
        return this.memoryMiB;
    }

    public final AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails networkInterfaceCount() {
        return this.networkInterfaceCount;
    }

    public final Integer onDemandMaxPricePercentageOverLowestPrice() {
        return this.onDemandMaxPricePercentageOverLowestPrice;
    }

    public final Boolean requireHibernateSupport() {
        return this.requireHibernateSupport;
    }

    public final Integer spotMaxPricePercentageOverLowestPrice() {
        return this.spotMaxPricePercentageOverLowestPrice;
    }

    public final AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails totalLocalStorageGB() {
        return this.totalLocalStorageGB;
    }

    public final AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails vCpuCount() {
        return this.vCpuCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAcceleratorManufacturers() ? this.acceleratorManufacturers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAcceleratorNames() ? this.acceleratorNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorTotalMemoryMiB());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAcceleratorTypes() ? this.acceleratorTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.bareMetal());
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineEbsBandwidthMbps());
        hashCode = 31 * hashCode + Objects.hashCode(this.burstablePerformance());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCpuManufacturers() ? this.cpuManufacturers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludedInstanceTypes() ? this.excludedInstanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceGenerations() ? this.instanceGenerations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.localStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocalStorageTypes() ? this.localStorageTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryGiBPerVCpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryMiB());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandMaxPricePercentageOverLowestPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireHibernateSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotMaxPricePercentageOverLowestPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalLocalStorageGB());
        hashCode = 31 * hashCode + Objects.hashCode(this.vCpuCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2LaunchTemplateDataInstanceRequirementsDetails)) {
            return false;
        }
        AwsEc2LaunchTemplateDataInstanceRequirementsDetails other = (AwsEc2LaunchTemplateDataInstanceRequirementsDetails)obj;
        return Objects.equals(this.acceleratorCount(), other.acceleratorCount()) && this.hasAcceleratorManufacturers() == other.hasAcceleratorManufacturers() && Objects.equals(this.acceleratorManufacturers(), other.acceleratorManufacturers()) && this.hasAcceleratorNames() == other.hasAcceleratorNames() && Objects.equals(this.acceleratorNames(), other.acceleratorNames()) && Objects.equals(this.acceleratorTotalMemoryMiB(), other.acceleratorTotalMemoryMiB()) && this.hasAcceleratorTypes() == other.hasAcceleratorTypes() && Objects.equals(this.acceleratorTypes(), other.acceleratorTypes()) && Objects.equals(this.bareMetal(), other.bareMetal()) && Objects.equals(this.baselineEbsBandwidthMbps(), other.baselineEbsBandwidthMbps()) && Objects.equals(this.burstablePerformance(), other.burstablePerformance()) && this.hasCpuManufacturers() == other.hasCpuManufacturers() && Objects.equals(this.cpuManufacturers(), other.cpuManufacturers()) && this.hasExcludedInstanceTypes() == other.hasExcludedInstanceTypes() && Objects.equals(this.excludedInstanceTypes(), other.excludedInstanceTypes()) && this.hasInstanceGenerations() == other.hasInstanceGenerations() && Objects.equals(this.instanceGenerations(), other.instanceGenerations()) && Objects.equals(this.localStorage(), other.localStorage()) && this.hasLocalStorageTypes() == other.hasLocalStorageTypes() && Objects.equals(this.localStorageTypes(), other.localStorageTypes()) && Objects.equals(this.memoryGiBPerVCpu(), other.memoryGiBPerVCpu()) && Objects.equals(this.memoryMiB(), other.memoryMiB()) && Objects.equals(this.networkInterfaceCount(), other.networkInterfaceCount()) && Objects.equals(this.onDemandMaxPricePercentageOverLowestPrice(), other.onDemandMaxPricePercentageOverLowestPrice()) && Objects.equals(this.requireHibernateSupport(), other.requireHibernateSupport()) && Objects.equals(this.spotMaxPricePercentageOverLowestPrice(), other.spotMaxPricePercentageOverLowestPrice()) && Objects.equals(this.totalLocalStorageGB(), other.totalLocalStorageGB()) && Objects.equals(this.vCpuCount(), other.vCpuCount());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEc2LaunchTemplateDataInstanceRequirementsDetails").add("AcceleratorCount", (Object)this.acceleratorCount()).add("AcceleratorManufacturers", this.hasAcceleratorManufacturers() ? this.acceleratorManufacturers() : null).add("AcceleratorNames", this.hasAcceleratorNames() ? this.acceleratorNames() : null).add("AcceleratorTotalMemoryMiB", (Object)this.acceleratorTotalMemoryMiB()).add("AcceleratorTypes", this.hasAcceleratorTypes() ? this.acceleratorTypes() : null).add("BareMetal", (Object)this.bareMetal()).add("BaselineEbsBandwidthMbps", (Object)this.baselineEbsBandwidthMbps()).add("BurstablePerformance", (Object)this.burstablePerformance()).add("CpuManufacturers", this.hasCpuManufacturers() ? this.cpuManufacturers() : null).add("ExcludedInstanceTypes", this.hasExcludedInstanceTypes() ? this.excludedInstanceTypes() : null).add("InstanceGenerations", this.hasInstanceGenerations() ? this.instanceGenerations() : null).add("LocalStorage", (Object)this.localStorage()).add("LocalStorageTypes", this.hasLocalStorageTypes() ? this.localStorageTypes() : null).add("MemoryGiBPerVCpu", (Object)this.memoryGiBPerVCpu()).add("MemoryMiB", (Object)this.memoryMiB()).add("NetworkInterfaceCount", (Object)this.networkInterfaceCount()).add("OnDemandMaxPricePercentageOverLowestPrice", (Object)this.onDemandMaxPricePercentageOverLowestPrice()).add("RequireHibernateSupport", (Object)this.requireHibernateSupport()).add("SpotMaxPricePercentageOverLowestPrice", (Object)this.spotMaxPricePercentageOverLowestPrice()).add("TotalLocalStorageGB", (Object)this.totalLocalStorageGB()).add("VCpuCount", (Object)this.vCpuCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceleratorCount": {
                return Optional.ofNullable(clazz.cast(this.acceleratorCount()));
            }
            case "AcceleratorManufacturers": {
                return Optional.ofNullable(clazz.cast(this.acceleratorManufacturers()));
            }
            case "AcceleratorNames": {
                return Optional.ofNullable(clazz.cast(this.acceleratorNames()));
            }
            case "AcceleratorTotalMemoryMiB": {
                return Optional.ofNullable(clazz.cast(this.acceleratorTotalMemoryMiB()));
            }
            case "AcceleratorTypes": {
                return Optional.ofNullable(clazz.cast(this.acceleratorTypes()));
            }
            case "BareMetal": {
                return Optional.ofNullable(clazz.cast(this.bareMetal()));
            }
            case "BaselineEbsBandwidthMbps": {
                return Optional.ofNullable(clazz.cast(this.baselineEbsBandwidthMbps()));
            }
            case "BurstablePerformance": {
                return Optional.ofNullable(clazz.cast(this.burstablePerformance()));
            }
            case "CpuManufacturers": {
                return Optional.ofNullable(clazz.cast(this.cpuManufacturers()));
            }
            case "ExcludedInstanceTypes": {
                return Optional.ofNullable(clazz.cast(this.excludedInstanceTypes()));
            }
            case "InstanceGenerations": {
                return Optional.ofNullable(clazz.cast(this.instanceGenerations()));
            }
            case "LocalStorage": {
                return Optional.ofNullable(clazz.cast(this.localStorage()));
            }
            case "LocalStorageTypes": {
                return Optional.ofNullable(clazz.cast(this.localStorageTypes()));
            }
            case "MemoryGiBPerVCpu": {
                return Optional.ofNullable(clazz.cast(this.memoryGiBPerVCpu()));
            }
            case "MemoryMiB": {
                return Optional.ofNullable(clazz.cast(this.memoryMiB()));
            }
            case "NetworkInterfaceCount": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceCount()));
            }
            case "OnDemandMaxPricePercentageOverLowestPrice": {
                return Optional.ofNullable(clazz.cast(this.onDemandMaxPricePercentageOverLowestPrice()));
            }
            case "RequireHibernateSupport": {
                return Optional.ofNullable(clazz.cast(this.requireHibernateSupport()));
            }
            case "SpotMaxPricePercentageOverLowestPrice": {
                return Optional.ofNullable(clazz.cast(this.spotMaxPricePercentageOverLowestPrice()));
            }
            case "TotalLocalStorageGB": {
                return Optional.ofNullable(clazz.cast(this.totalLocalStorageGB()));
            }
            case "VCpuCount": {
                return Optional.ofNullable(clazz.cast(this.vCpuCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2LaunchTemplateDataInstanceRequirementsDetails, T> g) {
        return obj -> g.apply((AwsEc2LaunchTemplateDataInstanceRequirementsDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails acceleratorCount;
        private List<String> acceleratorManufacturers = DefaultSdkAutoConstructList.getInstance();
        private List<String> acceleratorNames = DefaultSdkAutoConstructList.getInstance();
        private AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails acceleratorTotalMemoryMiB;
        private List<String> acceleratorTypes = DefaultSdkAutoConstructList.getInstance();
        private String bareMetal;
        private AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails baselineEbsBandwidthMbps;
        private String burstablePerformance;
        private List<String> cpuManufacturers = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludedInstanceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> instanceGenerations = DefaultSdkAutoConstructList.getInstance();
        private String localStorage;
        private List<String> localStorageTypes = DefaultSdkAutoConstructList.getInstance();
        private AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails memoryGiBPerVCpu;
        private AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails memoryMiB;
        private AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails networkInterfaceCount;
        private Integer onDemandMaxPricePercentageOverLowestPrice;
        private Boolean requireHibernateSupport;
        private Integer spotMaxPricePercentageOverLowestPrice;
        private AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails totalLocalStorageGB;
        private AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails vCpuCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2LaunchTemplateDataInstanceRequirementsDetails model) {
            this.acceleratorCount(model.acceleratorCount);
            this.acceleratorManufacturers(model.acceleratorManufacturers);
            this.acceleratorNames(model.acceleratorNames);
            this.acceleratorTotalMemoryMiB(model.acceleratorTotalMemoryMiB);
            this.acceleratorTypes(model.acceleratorTypes);
            this.bareMetal(model.bareMetal);
            this.baselineEbsBandwidthMbps(model.baselineEbsBandwidthMbps);
            this.burstablePerformance(model.burstablePerformance);
            this.cpuManufacturers(model.cpuManufacturers);
            this.excludedInstanceTypes(model.excludedInstanceTypes);
            this.instanceGenerations(model.instanceGenerations);
            this.localStorage(model.localStorage);
            this.localStorageTypes(model.localStorageTypes);
            this.memoryGiBPerVCpu(model.memoryGiBPerVCpu);
            this.memoryMiB(model.memoryMiB);
            this.networkInterfaceCount(model.networkInterfaceCount);
            this.onDemandMaxPricePercentageOverLowestPrice(model.onDemandMaxPricePercentageOverLowestPrice);
            this.requireHibernateSupport(model.requireHibernateSupport);
            this.spotMaxPricePercentageOverLowestPrice(model.spotMaxPricePercentageOverLowestPrice);
            this.totalLocalStorageGB(model.totalLocalStorageGB);
            this.vCpuCount(model.vCpuCount);
        }

        public final AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails.Builder getAcceleratorCount() {
            return this.acceleratorCount != null ? this.acceleratorCount.toBuilder() : null;
        }

        public final void setAcceleratorCount(AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails.BuilderImpl acceleratorCount) {
            this.acceleratorCount = acceleratorCount != null ? acceleratorCount.build() : null;
        }

        @Override
        public final Builder acceleratorCount(AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails acceleratorCount) {
            this.acceleratorCount = acceleratorCount;
            return this;
        }

        public final Collection<String> getAcceleratorManufacturers() {
            if (this.acceleratorManufacturers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.acceleratorManufacturers;
        }

        public final void setAcceleratorManufacturers(Collection<String> acceleratorManufacturers) {
            this.acceleratorManufacturers = NonEmptyStringListCopier.copy(acceleratorManufacturers);
        }

        @Override
        public final Builder acceleratorManufacturers(Collection<String> acceleratorManufacturers) {
            this.acceleratorManufacturers = NonEmptyStringListCopier.copy(acceleratorManufacturers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorManufacturers(String ... acceleratorManufacturers) {
            this.acceleratorManufacturers(Arrays.asList(acceleratorManufacturers));
            return this;
        }

        public final Collection<String> getAcceleratorNames() {
            if (this.acceleratorNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.acceleratorNames;
        }

        public final void setAcceleratorNames(Collection<String> acceleratorNames) {
            this.acceleratorNames = NonEmptyStringListCopier.copy(acceleratorNames);
        }

        @Override
        public final Builder acceleratorNames(Collection<String> acceleratorNames) {
            this.acceleratorNames = NonEmptyStringListCopier.copy(acceleratorNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorNames(String ... acceleratorNames) {
            this.acceleratorNames(Arrays.asList(acceleratorNames));
            return this;
        }

        public final AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails.Builder getAcceleratorTotalMemoryMiB() {
            return this.acceleratorTotalMemoryMiB != null ? this.acceleratorTotalMemoryMiB.toBuilder() : null;
        }

        public final void setAcceleratorTotalMemoryMiB(AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails.BuilderImpl acceleratorTotalMemoryMiB) {
            this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB != null ? acceleratorTotalMemoryMiB.build() : null;
        }

        @Override
        public final Builder acceleratorTotalMemoryMiB(AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails acceleratorTotalMemoryMiB) {
            this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
            return this;
        }

        public final Collection<String> getAcceleratorTypes() {
            if (this.acceleratorTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.acceleratorTypes;
        }

        public final void setAcceleratorTypes(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NonEmptyStringListCopier.copy(acceleratorTypes);
        }

        @Override
        public final Builder acceleratorTypes(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NonEmptyStringListCopier.copy(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypes(String ... acceleratorTypes) {
            this.acceleratorTypes(Arrays.asList(acceleratorTypes));
            return this;
        }

        public final String getBareMetal() {
            return this.bareMetal;
        }

        public final void setBareMetal(String bareMetal) {
            this.bareMetal = bareMetal;
        }

        @Override
        public final Builder bareMetal(String bareMetal) {
            this.bareMetal = bareMetal;
            return this;
        }

        public final AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails.Builder getBaselineEbsBandwidthMbps() {
            return this.baselineEbsBandwidthMbps != null ? this.baselineEbsBandwidthMbps.toBuilder() : null;
        }

        public final void setBaselineEbsBandwidthMbps(AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails.BuilderImpl baselineEbsBandwidthMbps) {
            this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps != null ? baselineEbsBandwidthMbps.build() : null;
        }

        @Override
        public final Builder baselineEbsBandwidthMbps(AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails baselineEbsBandwidthMbps) {
            this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps;
            return this;
        }

        public final String getBurstablePerformance() {
            return this.burstablePerformance;
        }

        public final void setBurstablePerformance(String burstablePerformance) {
            this.burstablePerformance = burstablePerformance;
        }

        @Override
        public final Builder burstablePerformance(String burstablePerformance) {
            this.burstablePerformance = burstablePerformance;
            return this;
        }

        public final Collection<String> getCpuManufacturers() {
            if (this.cpuManufacturers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cpuManufacturers;
        }

        public final void setCpuManufacturers(Collection<String> cpuManufacturers) {
            this.cpuManufacturers = NonEmptyStringListCopier.copy(cpuManufacturers);
        }

        @Override
        public final Builder cpuManufacturers(Collection<String> cpuManufacturers) {
            this.cpuManufacturers = NonEmptyStringListCopier.copy(cpuManufacturers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cpuManufacturers(String ... cpuManufacturers) {
            this.cpuManufacturers(Arrays.asList(cpuManufacturers));
            return this;
        }

        public final Collection<String> getExcludedInstanceTypes() {
            if (this.excludedInstanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludedInstanceTypes;
        }

        public final void setExcludedInstanceTypes(Collection<String> excludedInstanceTypes) {
            this.excludedInstanceTypes = NonEmptyStringListCopier.copy(excludedInstanceTypes);
        }

        @Override
        public final Builder excludedInstanceTypes(Collection<String> excludedInstanceTypes) {
            this.excludedInstanceTypes = NonEmptyStringListCopier.copy(excludedInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedInstanceTypes(String ... excludedInstanceTypes) {
            this.excludedInstanceTypes(Arrays.asList(excludedInstanceTypes));
            return this;
        }

        public final Collection<String> getInstanceGenerations() {
            if (this.instanceGenerations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceGenerations;
        }

        public final void setInstanceGenerations(Collection<String> instanceGenerations) {
            this.instanceGenerations = NonEmptyStringListCopier.copy(instanceGenerations);
        }

        @Override
        public final Builder instanceGenerations(Collection<String> instanceGenerations) {
            this.instanceGenerations = NonEmptyStringListCopier.copy(instanceGenerations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGenerations(String ... instanceGenerations) {
            this.instanceGenerations(Arrays.asList(instanceGenerations));
            return this;
        }

        public final String getLocalStorage() {
            return this.localStorage;
        }

        public final void setLocalStorage(String localStorage) {
            this.localStorage = localStorage;
        }

        @Override
        public final Builder localStorage(String localStorage) {
            this.localStorage = localStorage;
            return this;
        }

        public final Collection<String> getLocalStorageTypes() {
            if (this.localStorageTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.localStorageTypes;
        }

        public final void setLocalStorageTypes(Collection<String> localStorageTypes) {
            this.localStorageTypes = NonEmptyStringListCopier.copy(localStorageTypes);
        }

        @Override
        public final Builder localStorageTypes(Collection<String> localStorageTypes) {
            this.localStorageTypes = NonEmptyStringListCopier.copy(localStorageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localStorageTypes(String ... localStorageTypes) {
            this.localStorageTypes(Arrays.asList(localStorageTypes));
            return this;
        }

        public final AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails.Builder getMemoryGiBPerVCpu() {
            return this.memoryGiBPerVCpu != null ? this.memoryGiBPerVCpu.toBuilder() : null;
        }

        public final void setMemoryGiBPerVCpu(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails.BuilderImpl memoryGiBPerVCpu) {
            this.memoryGiBPerVCpu = memoryGiBPerVCpu != null ? memoryGiBPerVCpu.build() : null;
        }

        @Override
        public final Builder memoryGiBPerVCpu(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails memoryGiBPerVCpu) {
            this.memoryGiBPerVCpu = memoryGiBPerVCpu;
            return this;
        }

        public final AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails.Builder getMemoryMiB() {
            return this.memoryMiB != null ? this.memoryMiB.toBuilder() : null;
        }

        public final void setMemoryMiB(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails.BuilderImpl memoryMiB) {
            this.memoryMiB = memoryMiB != null ? memoryMiB.build() : null;
        }

        @Override
        public final Builder memoryMiB(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails memoryMiB) {
            this.memoryMiB = memoryMiB;
            return this;
        }

        public final AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails.Builder getNetworkInterfaceCount() {
            return this.networkInterfaceCount != null ? this.networkInterfaceCount.toBuilder() : null;
        }

        public final void setNetworkInterfaceCount(AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails.BuilderImpl networkInterfaceCount) {
            this.networkInterfaceCount = networkInterfaceCount != null ? networkInterfaceCount.build() : null;
        }

        @Override
        public final Builder networkInterfaceCount(AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails networkInterfaceCount) {
            this.networkInterfaceCount = networkInterfaceCount;
            return this;
        }

        public final Integer getOnDemandMaxPricePercentageOverLowestPrice() {
            return this.onDemandMaxPricePercentageOverLowestPrice;
        }

        public final void setOnDemandMaxPricePercentageOverLowestPrice(Integer onDemandMaxPricePercentageOverLowestPrice) {
            this.onDemandMaxPricePercentageOverLowestPrice = onDemandMaxPricePercentageOverLowestPrice;
        }

        @Override
        public final Builder onDemandMaxPricePercentageOverLowestPrice(Integer onDemandMaxPricePercentageOverLowestPrice) {
            this.onDemandMaxPricePercentageOverLowestPrice = onDemandMaxPricePercentageOverLowestPrice;
            return this;
        }

        public final Boolean getRequireHibernateSupport() {
            return this.requireHibernateSupport;
        }

        public final void setRequireHibernateSupport(Boolean requireHibernateSupport) {
            this.requireHibernateSupport = requireHibernateSupport;
        }

        @Override
        public final Builder requireHibernateSupport(Boolean requireHibernateSupport) {
            this.requireHibernateSupport = requireHibernateSupport;
            return this;
        }

        public final Integer getSpotMaxPricePercentageOverLowestPrice() {
            return this.spotMaxPricePercentageOverLowestPrice;
        }

        public final void setSpotMaxPricePercentageOverLowestPrice(Integer spotMaxPricePercentageOverLowestPrice) {
            this.spotMaxPricePercentageOverLowestPrice = spotMaxPricePercentageOverLowestPrice;
        }

        @Override
        public final Builder spotMaxPricePercentageOverLowestPrice(Integer spotMaxPricePercentageOverLowestPrice) {
            this.spotMaxPricePercentageOverLowestPrice = spotMaxPricePercentageOverLowestPrice;
            return this;
        }

        public final AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails.Builder getTotalLocalStorageGB() {
            return this.totalLocalStorageGB != null ? this.totalLocalStorageGB.toBuilder() : null;
        }

        public final void setTotalLocalStorageGB(AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails.BuilderImpl totalLocalStorageGB) {
            this.totalLocalStorageGB = totalLocalStorageGB != null ? totalLocalStorageGB.build() : null;
        }

        @Override
        public final Builder totalLocalStorageGB(AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails totalLocalStorageGB) {
            this.totalLocalStorageGB = totalLocalStorageGB;
            return this;
        }

        public final AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails.Builder getVCpuCount() {
            return this.vCpuCount != null ? this.vCpuCount.toBuilder() : null;
        }

        public final void setVCpuCount(AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails.BuilderImpl vCpuCount) {
            this.vCpuCount = vCpuCount != null ? vCpuCount.build() : null;
        }

        @Override
        public final Builder vCpuCount(AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails vCpuCount) {
            this.vCpuCount = vCpuCount;
            return this;
        }

        public AwsEc2LaunchTemplateDataInstanceRequirementsDetails build() {
            return new AwsEc2LaunchTemplateDataInstanceRequirementsDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2LaunchTemplateDataInstanceRequirementsDetails> {
        public Builder acceleratorCount(AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails var1);

        default public Builder acceleratorCount(Consumer<AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails.Builder> acceleratorCount) {
            return this.acceleratorCount((AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails)((AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails.Builder)AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails.builder().applyMutation(acceleratorCount)).build());
        }

        public Builder acceleratorManufacturers(Collection<String> var1);

        public Builder acceleratorManufacturers(String ... var1);

        public Builder acceleratorNames(Collection<String> var1);

        public Builder acceleratorNames(String ... var1);

        public Builder acceleratorTotalMemoryMiB(AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails var1);

        default public Builder acceleratorTotalMemoryMiB(Consumer<AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails.Builder> acceleratorTotalMemoryMiB) {
            return this.acceleratorTotalMemoryMiB((AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails)((AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails.Builder)AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails.builder().applyMutation(acceleratorTotalMemoryMiB)).build());
        }

        public Builder acceleratorTypes(Collection<String> var1);

        public Builder acceleratorTypes(String ... var1);

        public Builder bareMetal(String var1);

        public Builder baselineEbsBandwidthMbps(AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails var1);

        default public Builder baselineEbsBandwidthMbps(Consumer<AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails.Builder> baselineEbsBandwidthMbps) {
            return this.baselineEbsBandwidthMbps((AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails)((AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails.Builder)AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails.builder().applyMutation(baselineEbsBandwidthMbps)).build());
        }

        public Builder burstablePerformance(String var1);

        public Builder cpuManufacturers(Collection<String> var1);

        public Builder cpuManufacturers(String ... var1);

        public Builder excludedInstanceTypes(Collection<String> var1);

        public Builder excludedInstanceTypes(String ... var1);

        public Builder instanceGenerations(Collection<String> var1);

        public Builder instanceGenerations(String ... var1);

        public Builder localStorage(String var1);

        public Builder localStorageTypes(Collection<String> var1);

        public Builder localStorageTypes(String ... var1);

        public Builder memoryGiBPerVCpu(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails var1);

        default public Builder memoryGiBPerVCpu(Consumer<AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails.Builder> memoryGiBPerVCpu) {
            return this.memoryGiBPerVCpu((AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails)((AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails.Builder)AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails.builder().applyMutation(memoryGiBPerVCpu)).build());
        }

        public Builder memoryMiB(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails var1);

        default public Builder memoryMiB(Consumer<AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails.Builder> memoryMiB) {
            return this.memoryMiB((AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails)((AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails.Builder)AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails.builder().applyMutation(memoryMiB)).build());
        }

        public Builder networkInterfaceCount(AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails var1);

        default public Builder networkInterfaceCount(Consumer<AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails.Builder> networkInterfaceCount) {
            return this.networkInterfaceCount((AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails)((AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails.Builder)AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails.builder().applyMutation(networkInterfaceCount)).build());
        }

        public Builder onDemandMaxPricePercentageOverLowestPrice(Integer var1);

        public Builder requireHibernateSupport(Boolean var1);

        public Builder spotMaxPricePercentageOverLowestPrice(Integer var1);

        public Builder totalLocalStorageGB(AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails var1);

        default public Builder totalLocalStorageGB(Consumer<AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails.Builder> totalLocalStorageGB) {
            return this.totalLocalStorageGB((AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails)((AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails.Builder)AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails.builder().applyMutation(totalLocalStorageGB)).build());
        }

        public Builder vCpuCount(AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails var1);

        default public Builder vCpuCount(Consumer<AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails.Builder> vCpuCount) {
            return this.vCpuCount((AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails)((AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails.Builder)AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails.builder().applyMutation(vCpuCount)).build());
        }
    }
}

