/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VulnerabilityFixAvailable {
    YES("YES"),
    NO("NO"),
    PARTIAL("PARTIAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VulnerabilityFixAvailable> VALUE_MAP;
    private final String value;

    private VulnerabilityFixAvailable(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VulnerabilityFixAvailable fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VulnerabilityFixAvailable> knownValues() {
        EnumSet<VulnerabilityFixAvailable> knownValues = EnumSet.allOf(VulnerabilityFixAvailable.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VulnerabilityFixAvailable.class, VulnerabilityFixAvailable::toString);
    }
}

