/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableKeySchema;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableKeySchemaListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableProjection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsDynamoDbTableLocalSecondaryIndex
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsDynamoDbTableLocalSecondaryIndex> {
    private static final SdkField<String> INDEX_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexArn").getter(AwsDynamoDbTableLocalSecondaryIndex.getter(AwsDynamoDbTableLocalSecondaryIndex::indexArn)).setter(AwsDynamoDbTableLocalSecondaryIndex.setter(Builder::indexArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexArn").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexName").getter(AwsDynamoDbTableLocalSecondaryIndex.getter(AwsDynamoDbTableLocalSecondaryIndex::indexName)).setter(AwsDynamoDbTableLocalSecondaryIndex.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()}).build();
    private static final SdkField<List<AwsDynamoDbTableKeySchema>> KEY_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("KeySchema").getter(AwsDynamoDbTableLocalSecondaryIndex.getter(AwsDynamoDbTableLocalSecondaryIndex::keySchema)).setter(AwsDynamoDbTableLocalSecondaryIndex.setter(Builder::keySchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySchema").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsDynamoDbTableKeySchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AwsDynamoDbTableProjection> PROJECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Projection").getter(AwsDynamoDbTableLocalSecondaryIndex.getter(AwsDynamoDbTableLocalSecondaryIndex::projection)).setter(AwsDynamoDbTableLocalSecondaryIndex.setter(Builder::projection)).constructor(AwsDynamoDbTableProjection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Projection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ARN_FIELD, INDEX_NAME_FIELD, KEY_SCHEMA_FIELD, PROJECTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String indexArn;
    private final String indexName;
    private final List<AwsDynamoDbTableKeySchema> keySchema;
    private final AwsDynamoDbTableProjection projection;

    private AwsDynamoDbTableLocalSecondaryIndex(BuilderImpl builder) {
        this.indexArn = builder.indexArn;
        this.indexName = builder.indexName;
        this.keySchema = builder.keySchema;
        this.projection = builder.projection;
    }

    public final String indexArn() {
        return this.indexArn;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final boolean hasKeySchema() {
        return this.keySchema != null && !(this.keySchema instanceof SdkAutoConstructList);
    }

    public final List<AwsDynamoDbTableKeySchema> keySchema() {
        return this.keySchema;
    }

    public final AwsDynamoDbTableProjection projection() {
        return this.projection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeySchema() ? this.keySchema() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.projection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsDynamoDbTableLocalSecondaryIndex)) {
            return false;
        }
        AwsDynamoDbTableLocalSecondaryIndex other = (AwsDynamoDbTableLocalSecondaryIndex)obj;
        return Objects.equals(this.indexArn(), other.indexArn()) && Objects.equals(this.indexName(), other.indexName()) && this.hasKeySchema() == other.hasKeySchema() && Objects.equals(this.keySchema(), other.keySchema()) && Objects.equals(this.projection(), other.projection());
    }

    public final String toString() {
        return ToString.builder((String)"AwsDynamoDbTableLocalSecondaryIndex").add("IndexArn", (Object)this.indexArn()).add("IndexName", (Object)this.indexName()).add("KeySchema", this.hasKeySchema() ? this.keySchema() : null).add("Projection", (Object)this.projection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexArn": {
                return Optional.ofNullable(clazz.cast(this.indexArn()));
            }
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "KeySchema": {
                return Optional.ofNullable(clazz.cast(this.keySchema()));
            }
            case "Projection": {
                return Optional.ofNullable(clazz.cast(this.projection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsDynamoDbTableLocalSecondaryIndex, T> g) {
        return obj -> g.apply((AwsDynamoDbTableLocalSecondaryIndex)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String indexArn;
        private String indexName;
        private List<AwsDynamoDbTableKeySchema> keySchema = DefaultSdkAutoConstructList.getInstance();
        private AwsDynamoDbTableProjection projection;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsDynamoDbTableLocalSecondaryIndex model) {
            this.indexArn(model.indexArn);
            this.indexName(model.indexName);
            this.keySchema(model.keySchema);
            this.projection(model.projection);
        }

        public final String getIndexArn() {
            return this.indexArn;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        @Override
        @Transient
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        @Transient
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final List<AwsDynamoDbTableKeySchema.Builder> getKeySchema() {
            List<AwsDynamoDbTableKeySchema.Builder> result = AwsDynamoDbTableKeySchemaListCopier.copyToBuilder(this.keySchema);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeySchema(Collection<AwsDynamoDbTableKeySchema.BuilderImpl> keySchema) {
            this.keySchema = AwsDynamoDbTableKeySchemaListCopier.copyFromBuilder(keySchema);
        }

        @Override
        @Transient
        public final Builder keySchema(Collection<AwsDynamoDbTableKeySchema> keySchema) {
            this.keySchema = AwsDynamoDbTableKeySchemaListCopier.copy(keySchema);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder keySchema(AwsDynamoDbTableKeySchema ... keySchema) {
            this.keySchema(Arrays.asList(keySchema));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder keySchema(Consumer<AwsDynamoDbTableKeySchema.Builder> ... keySchema) {
            this.keySchema(Stream.of(keySchema).map(c -> (AwsDynamoDbTableKeySchema)((AwsDynamoDbTableKeySchema.Builder)AwsDynamoDbTableKeySchema.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AwsDynamoDbTableProjection.Builder getProjection() {
            return this.projection != null ? this.projection.toBuilder() : null;
        }

        public final void setProjection(AwsDynamoDbTableProjection.BuilderImpl projection) {
            this.projection = projection != null ? projection.build() : null;
        }

        @Override
        @Transient
        public final Builder projection(AwsDynamoDbTableProjection projection) {
            this.projection = projection;
            return this;
        }

        public AwsDynamoDbTableLocalSecondaryIndex build() {
            return new AwsDynamoDbTableLocalSecondaryIndex(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsDynamoDbTableLocalSecondaryIndex> {
        public Builder indexArn(String var1);

        public Builder indexName(String var1);

        public Builder keySchema(Collection<AwsDynamoDbTableKeySchema> var1);

        public Builder keySchema(AwsDynamoDbTableKeySchema ... var1);

        public Builder keySchema(Consumer<AwsDynamoDbTableKeySchema.Builder> ... var1);

        public Builder projection(AwsDynamoDbTableProjection var1);

        default public Builder projection(Consumer<AwsDynamoDbTableProjection.Builder> projection) {
            return this.projection((AwsDynamoDbTableProjection)((AwsDynamoDbTableProjection.Builder)AwsDynamoDbTableProjection.builder().applyMutation(projection)).build());
        }
    }
}

