/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MalwareType {
    ADWARE("ADWARE"),
    BLENDED_THREAT("BLENDED_THREAT"),
    BOTNET_AGENT("BOTNET_AGENT"),
    COIN_MINER("COIN_MINER"),
    EXPLOIT_KIT("EXPLOIT_KIT"),
    KEYLOGGER("KEYLOGGER"),
    MACRO("MACRO"),
    POTENTIALLY_UNWANTED("POTENTIALLY_UNWANTED"),
    SPYWARE("SPYWARE"),
    RANSOMWARE("RANSOMWARE"),
    REMOTE_ACCESS("REMOTE_ACCESS"),
    ROOTKIT("ROOTKIT"),
    TROJAN("TROJAN"),
    VIRUS("VIRUS"),
    WORM("WORM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MalwareType> VALUE_MAP;
    private final String value;

    private MalwareType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MalwareType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MalwareType> knownValues() {
        EnumSet<MalwareType> knownValues = EnumSet.allOf(MalwareType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MalwareType.class, MalwareType::toString);
    }
}

