/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsS3BucketLoggingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsS3BucketLoggingConfiguration> {
    private static final SdkField<String> DESTINATION_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationBucketName").getter(AwsS3BucketLoggingConfiguration.getter(AwsS3BucketLoggingConfiguration::destinationBucketName)).setter(AwsS3BucketLoggingConfiguration.setter(Builder::destinationBucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationBucketName").build()}).build();
    private static final SdkField<String> LOG_FILE_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogFilePrefix").getter(AwsS3BucketLoggingConfiguration.getter(AwsS3BucketLoggingConfiguration::logFilePrefix)).setter(AwsS3BucketLoggingConfiguration.setter(Builder::logFilePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFilePrefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_BUCKET_NAME_FIELD, LOG_FILE_PREFIX_FIELD));
    private static final long serialVersionUID = 1L;
    private final String destinationBucketName;
    private final String logFilePrefix;

    private AwsS3BucketLoggingConfiguration(BuilderImpl builder) {
        this.destinationBucketName = builder.destinationBucketName;
        this.logFilePrefix = builder.logFilePrefix;
    }

    public final String destinationBucketName() {
        return this.destinationBucketName;
    }

    public final String logFilePrefix() {
        return this.logFilePrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logFilePrefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketLoggingConfiguration)) {
            return false;
        }
        AwsS3BucketLoggingConfiguration other = (AwsS3BucketLoggingConfiguration)obj;
        return Objects.equals(this.destinationBucketName(), other.destinationBucketName()) && Objects.equals(this.logFilePrefix(), other.logFilePrefix());
    }

    public final String toString() {
        return ToString.builder((String)"AwsS3BucketLoggingConfiguration").add("DestinationBucketName", (Object)this.destinationBucketName()).add("LogFilePrefix", (Object)this.logFilePrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationBucketName": {
                return Optional.ofNullable(clazz.cast(this.destinationBucketName()));
            }
            case "LogFilePrefix": {
                return Optional.ofNullable(clazz.cast(this.logFilePrefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketLoggingConfiguration, T> g) {
        return obj -> g.apply((AwsS3BucketLoggingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationBucketName;
        private String logFilePrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketLoggingConfiguration model) {
            this.destinationBucketName(model.destinationBucketName);
            this.logFilePrefix(model.logFilePrefix);
        }

        public final String getDestinationBucketName() {
            return this.destinationBucketName;
        }

        public final void setDestinationBucketName(String destinationBucketName) {
            this.destinationBucketName = destinationBucketName;
        }

        @Override
        public final Builder destinationBucketName(String destinationBucketName) {
            this.destinationBucketName = destinationBucketName;
            return this;
        }

        public final String getLogFilePrefix() {
            return this.logFilePrefix;
        }

        public final void setLogFilePrefix(String logFilePrefix) {
            this.logFilePrefix = logFilePrefix;
        }

        @Override
        public final Builder logFilePrefix(String logFilePrefix) {
            this.logFilePrefix = logFilePrefix;
            return this;
        }

        public AwsS3BucketLoggingConfiguration build() {
            return new AwsS3BucketLoggingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsS3BucketLoggingConfiguration> {
        public Builder destinationBucketName(String var1);

        public Builder logFilePrefix(String var1);
    }
}

