/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ContainerDetails.getter(ContainerDetails::name)).setter(ContainerDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(ContainerDetails.getter(ContainerDetails::imageId)).setter(ContainerDetails.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()}).build();
    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageName").getter(ContainerDetails.getter(ContainerDetails::imageName)).setter(ContainerDetails.setter(Builder::imageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()}).build();
    private static final SdkField<String> LAUNCHED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchedAt").getter(ContainerDetails.getter(ContainerDetails::launchedAt)).setter(ContainerDetails.setter(Builder::launchedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IMAGE_ID_FIELD, IMAGE_NAME_FIELD, LAUNCHED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String imageId;
    private final String imageName;
    private final String launchedAt;

    private ContainerDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.imageId = builder.imageId;
        this.imageName = builder.imageName;
        this.launchedAt = builder.launchedAt;
    }

    public final String name() {
        return this.name;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final String imageName() {
        return this.imageName;
    }

    public final String launchedAt() {
        return this.launchedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDetails)) {
            return false;
        }
        ContainerDetails other = (ContainerDetails)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.imageName(), other.imageName()) && Objects.equals(this.launchedAt(), other.launchedAt());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerDetails").add("Name", (Object)this.name()).add("ImageId", (Object)this.imageId()).add("ImageName", (Object)this.imageName()).add("LaunchedAt", (Object)this.launchedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "ImageName": {
                return Optional.ofNullable(clazz.cast(this.imageName()));
            }
            case "LaunchedAt": {
                return Optional.ofNullable(clazz.cast(this.launchedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerDetails, T> g) {
        return obj -> g.apply((ContainerDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String imageId;
        private String imageName;
        private String launchedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerDetails model) {
            this.name(model.name);
            this.imageId(model.imageId);
            this.imageName(model.imageName);
            this.launchedAt(model.launchedAt);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getImageName() {
            return this.imageName;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final String getLaunchedAt() {
            return this.launchedAt;
        }

        public final void setLaunchedAt(String launchedAt) {
            this.launchedAt = launchedAt;
        }

        @Override
        public final Builder launchedAt(String launchedAt) {
            this.launchedAt = launchedAt;
            return this;
        }

        public ContainerDetails build() {
            return new ContainerDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerDetails> {
        public Builder name(String var1);

        public Builder imageId(String var1);

        public Builder imageName(String var1);

        public Builder launchedAt(String var1);
    }
}

