/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails> {
    private static final SdkField<String> CONTAINER_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerPath").getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails::containerPath)).setter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.setter(Builder::containerPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerPath").build()}).build();
    private static final SdkField<List<String>> MOUNT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MountOptions").getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails::mountOptions)).setter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.setter(Builder::mountOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Size").getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.getter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails::size)).setter(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_PATH_FIELD, MOUNT_OPTIONS_FIELD, SIZE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String containerPath;
    private final List<String> mountOptions;
    private final Integer size;

    private AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails(BuilderImpl builder) {
        this.containerPath = builder.containerPath;
        this.mountOptions = builder.mountOptions;
        this.size = builder.size;
    }

    public final String containerPath() {
        return this.containerPath;
    }

    public final boolean hasMountOptions() {
        return this.mountOptions != null && !(this.mountOptions instanceof SdkAutoConstructList);
    }

    public final List<String> mountOptions() {
        return this.mountOptions;
    }

    public final Integer size() {
        return this.size;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMountOptions() ? this.mountOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails other = (AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails)obj;
        return Objects.equals(this.containerPath(), other.containerPath()) && this.hasMountOptions() == other.hasMountOptions() && Objects.equals(this.mountOptions(), other.mountOptions()) && Objects.equals(this.size(), other.size());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails").add("ContainerPath", (Object)this.containerPath()).add("MountOptions", this.hasMountOptions() ? this.mountOptions() : null).add("Size", (Object)this.size()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerPath": {
                return Optional.ofNullable(clazz.cast(this.containerPath()));
            }
            case "MountOptions": {
                return Optional.ofNullable(clazz.cast(this.mountOptions()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerPath;
        private List<String> mountOptions = DefaultSdkAutoConstructList.getInstance();
        private Integer size;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails model) {
            this.containerPath(model.containerPath);
            this.mountOptions(model.mountOptions);
            this.size(model.size);
        }

        public final String getContainerPath() {
            return this.containerPath;
        }

        @Override
        public final Builder containerPath(String containerPath) {
            this.containerPath = containerPath;
            return this;
        }

        public final void setContainerPath(String containerPath) {
            this.containerPath = containerPath;
        }

        public final Collection<String> getMountOptions() {
            if (this.mountOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.mountOptions;
        }

        @Override
        public final Builder mountOptions(Collection<String> mountOptions) {
            this.mountOptions = NonEmptyStringListCopier.copy(mountOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountOptions(String ... mountOptions) {
            this.mountOptions(Arrays.asList(mountOptions));
            return this;
        }

        public final void setMountOptions(Collection<String> mountOptions) {
            this.mountOptions = NonEmptyStringListCopier.copy(mountOptions);
        }

        public final Integer getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails build() {
            return new AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersTmpfsDetails> {
        public Builder containerPath(String var1);

        public Builder mountOptions(Collection<String> var1);

        public Builder mountOptions(String ... var1);

        public Builder size(Integer var1);
    }
}

