/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.AwsApiCallAction;
import software.amazon.awssdk.services.securityhub.model.DnsRequestAction;
import software.amazon.awssdk.services.securityhub.model.NetworkConnectionAction;
import software.amazon.awssdk.services.securityhub.model.PortProbeAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Action
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Action> {
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionType").getter(Action.getter(Action::actionType)).setter(Action.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()}).build();
    private static final SdkField<NetworkConnectionAction> NETWORK_CONNECTION_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkConnectionAction").getter(Action.getter(Action::networkConnectionAction)).setter(Action.setter(Builder::networkConnectionAction)).constructor(NetworkConnectionAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConnectionAction").build()}).build();
    private static final SdkField<AwsApiCallAction> AWS_API_CALL_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AwsApiCallAction").getter(Action.getter(Action::awsApiCallAction)).setter(Action.setter(Builder::awsApiCallAction)).constructor(AwsApiCallAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsApiCallAction").build()}).build();
    private static final SdkField<DnsRequestAction> DNS_REQUEST_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DnsRequestAction").getter(Action.getter(Action::dnsRequestAction)).setter(Action.setter(Builder::dnsRequestAction)).constructor(DnsRequestAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsRequestAction").build()}).build();
    private static final SdkField<PortProbeAction> PORT_PROBE_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PortProbeAction").getter(Action.getter(Action::portProbeAction)).setter(Action.setter(Builder::portProbeAction)).constructor(PortProbeAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortProbeAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_TYPE_FIELD, NETWORK_CONNECTION_ACTION_FIELD, AWS_API_CALL_ACTION_FIELD, DNS_REQUEST_ACTION_FIELD, PORT_PROBE_ACTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String actionType;
    private final NetworkConnectionAction networkConnectionAction;
    private final AwsApiCallAction awsApiCallAction;
    private final DnsRequestAction dnsRequestAction;
    private final PortProbeAction portProbeAction;

    private Action(BuilderImpl builder) {
        this.actionType = builder.actionType;
        this.networkConnectionAction = builder.networkConnectionAction;
        this.awsApiCallAction = builder.awsApiCallAction;
        this.dnsRequestAction = builder.dnsRequestAction;
        this.portProbeAction = builder.portProbeAction;
    }

    public final String actionType() {
        return this.actionType;
    }

    public final NetworkConnectionAction networkConnectionAction() {
        return this.networkConnectionAction;
    }

    public final AwsApiCallAction awsApiCallAction() {
        return this.awsApiCallAction;
    }

    public final DnsRequestAction dnsRequestAction() {
        return this.dnsRequestAction;
    }

    public final PortProbeAction portProbeAction() {
        return this.portProbeAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionType());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConnectionAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsApiCallAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsRequestAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.portProbeAction());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action)obj;
        return Objects.equals(this.actionType(), other.actionType()) && Objects.equals(this.networkConnectionAction(), other.networkConnectionAction()) && Objects.equals(this.awsApiCallAction(), other.awsApiCallAction()) && Objects.equals(this.dnsRequestAction(), other.dnsRequestAction()) && Objects.equals(this.portProbeAction(), other.portProbeAction());
    }

    public final String toString() {
        return ToString.builder((String)"Action").add("ActionType", (Object)this.actionType()).add("NetworkConnectionAction", (Object)this.networkConnectionAction()).add("AwsApiCallAction", (Object)this.awsApiCallAction()).add("DnsRequestAction", (Object)this.dnsRequestAction()).add("PortProbeAction", (Object)this.portProbeAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActionType": {
                return Optional.ofNullable(clazz.cast(this.actionType()));
            }
            case "NetworkConnectionAction": {
                return Optional.ofNullable(clazz.cast(this.networkConnectionAction()));
            }
            case "AwsApiCallAction": {
                return Optional.ofNullable(clazz.cast(this.awsApiCallAction()));
            }
            case "DnsRequestAction": {
                return Optional.ofNullable(clazz.cast(this.dnsRequestAction()));
            }
            case "PortProbeAction": {
                return Optional.ofNullable(clazz.cast(this.portProbeAction()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionType;
        private NetworkConnectionAction networkConnectionAction;
        private AwsApiCallAction awsApiCallAction;
        private DnsRequestAction dnsRequestAction;
        private PortProbeAction portProbeAction;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            this.actionType(model.actionType);
            this.networkConnectionAction(model.networkConnectionAction);
            this.awsApiCallAction(model.awsApiCallAction);
            this.dnsRequestAction(model.dnsRequestAction);
            this.portProbeAction(model.portProbeAction);
        }

        public final String getActionType() {
            return this.actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public final NetworkConnectionAction.Builder getNetworkConnectionAction() {
            return this.networkConnectionAction != null ? this.networkConnectionAction.toBuilder() : null;
        }

        @Override
        public final Builder networkConnectionAction(NetworkConnectionAction networkConnectionAction) {
            this.networkConnectionAction = networkConnectionAction;
            return this;
        }

        public final void setNetworkConnectionAction(NetworkConnectionAction.BuilderImpl networkConnectionAction) {
            this.networkConnectionAction = networkConnectionAction != null ? networkConnectionAction.build() : null;
        }

        public final AwsApiCallAction.Builder getAwsApiCallAction() {
            return this.awsApiCallAction != null ? this.awsApiCallAction.toBuilder() : null;
        }

        @Override
        public final Builder awsApiCallAction(AwsApiCallAction awsApiCallAction) {
            this.awsApiCallAction = awsApiCallAction;
            return this;
        }

        public final void setAwsApiCallAction(AwsApiCallAction.BuilderImpl awsApiCallAction) {
            this.awsApiCallAction = awsApiCallAction != null ? awsApiCallAction.build() : null;
        }

        public final DnsRequestAction.Builder getDnsRequestAction() {
            return this.dnsRequestAction != null ? this.dnsRequestAction.toBuilder() : null;
        }

        @Override
        public final Builder dnsRequestAction(DnsRequestAction dnsRequestAction) {
            this.dnsRequestAction = dnsRequestAction;
            return this;
        }

        public final void setDnsRequestAction(DnsRequestAction.BuilderImpl dnsRequestAction) {
            this.dnsRequestAction = dnsRequestAction != null ? dnsRequestAction.build() : null;
        }

        public final PortProbeAction.Builder getPortProbeAction() {
            return this.portProbeAction != null ? this.portProbeAction.toBuilder() : null;
        }

        @Override
        public final Builder portProbeAction(PortProbeAction portProbeAction) {
            this.portProbeAction = portProbeAction;
            return this;
        }

        public final void setPortProbeAction(PortProbeAction.BuilderImpl portProbeAction) {
            this.portProbeAction = portProbeAction != null ? portProbeAction.build() : null;
        }

        public Action build() {
            return new Action(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Action> {
        public Builder actionType(String var1);

        public Builder networkConnectionAction(NetworkConnectionAction var1);

        default public Builder networkConnectionAction(Consumer<NetworkConnectionAction.Builder> networkConnectionAction) {
            return this.networkConnectionAction((NetworkConnectionAction)((NetworkConnectionAction.Builder)NetworkConnectionAction.builder().applyMutation(networkConnectionAction)).build());
        }

        public Builder awsApiCallAction(AwsApiCallAction var1);

        default public Builder awsApiCallAction(Consumer<AwsApiCallAction.Builder> awsApiCallAction) {
            return this.awsApiCallAction((AwsApiCallAction)((AwsApiCallAction.Builder)AwsApiCallAction.builder().applyMutation(awsApiCallAction)).build());
        }

        public Builder dnsRequestAction(DnsRequestAction var1);

        default public Builder dnsRequestAction(Consumer<DnsRequestAction.Builder> dnsRequestAction) {
            return this.dnsRequestAction((DnsRequestAction)((DnsRequestAction.Builder)DnsRequestAction.builder().applyMutation(dnsRequestAction)).build());
        }

        public Builder portProbeAction(PortProbeAction var1);

        default public Builder portProbeAction(Consumer<PortProbeAction.Builder> portProbeAction) {
            return this.portProbeAction((PortProbeAction)((PortProbeAction.Builder)PortProbeAction.builder().applyMutation(portProbeAction)).build());
        }
    }
}

