/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersDetections;
import software.amazon.awssdk.services.securityhub.model.CustomDataIdentifiersDetectionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomDataIdentifiersResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomDataIdentifiersResult> {
    private static final SdkField<List<CustomDataIdentifiersDetections>> DETECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Detections").getter(CustomDataIdentifiersResult.getter(CustomDataIdentifiersResult::detections)).setter(CustomDataIdentifiersResult.setter(Builder::detections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Detections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomDataIdentifiersDetections::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalCount").getter(CustomDataIdentifiersResult.getter(CustomDataIdentifiersResult::totalCount)).setter(CustomDataIdentifiersResult.setter(Builder::totalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTIONS_FIELD, TOTAL_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<CustomDataIdentifiersDetections> detections;
    private final Long totalCount;

    private CustomDataIdentifiersResult(BuilderImpl builder) {
        this.detections = builder.detections;
        this.totalCount = builder.totalCount;
    }

    public final boolean hasDetections() {
        return this.detections != null && !(this.detections instanceof SdkAutoConstructList);
    }

    public final List<CustomDataIdentifiersDetections> detections() {
        return this.detections;
    }

    public final Long totalCount() {
        return this.totalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetections() ? this.detections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomDataIdentifiersResult)) {
            return false;
        }
        CustomDataIdentifiersResult other = (CustomDataIdentifiersResult)obj;
        return this.hasDetections() == other.hasDetections() && Objects.equals(this.detections(), other.detections()) && Objects.equals(this.totalCount(), other.totalCount());
    }

    public final String toString() {
        return ToString.builder((String)"CustomDataIdentifiersResult").add("Detections", this.hasDetections() ? this.detections() : null).add("TotalCount", (Object)this.totalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Detections": {
                return Optional.ofNullable(clazz.cast(this.detections()));
            }
            case "TotalCount": {
                return Optional.ofNullable(clazz.cast(this.totalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomDataIdentifiersResult, T> g) {
        return obj -> g.apply((CustomDataIdentifiersResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CustomDataIdentifiersDetections> detections = DefaultSdkAutoConstructList.getInstance();
        private Long totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomDataIdentifiersResult model) {
            this.detections(model.detections);
            this.totalCount(model.totalCount);
        }

        public final Collection<CustomDataIdentifiersDetections.Builder> getDetections() {
            if (this.detections instanceof SdkAutoConstructList) {
                return null;
            }
            return this.detections != null ? (Collection)this.detections.stream().map(CustomDataIdentifiersDetections::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder detections(Collection<CustomDataIdentifiersDetections> detections) {
            this.detections = CustomDataIdentifiersDetectionsListCopier.copy(detections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detections(CustomDataIdentifiersDetections ... detections) {
            this.detections(Arrays.asList(detections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detections(Consumer<CustomDataIdentifiersDetections.Builder> ... detections) {
            this.detections(Stream.of(detections).map(c -> (CustomDataIdentifiersDetections)((CustomDataIdentifiersDetections.Builder)CustomDataIdentifiersDetections.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDetections(Collection<CustomDataIdentifiersDetections.BuilderImpl> detections) {
            this.detections = CustomDataIdentifiersDetectionsListCopier.copyFromBuilder(detections);
        }

        public final Long getTotalCount() {
            return this.totalCount;
        }

        @Override
        public final Builder totalCount(Long totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        public CustomDataIdentifiersResult build() {
            return new CustomDataIdentifiersResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomDataIdentifiersResult> {
        public Builder detections(Collection<CustomDataIdentifiersDetections> var1);

        public Builder detections(CustomDataIdentifiersDetections ... var1);

        public Builder detections(Consumer<CustomDataIdentifiersDetections.Builder> ... var1);

        public Builder totalCount(Long var1);
    }
}

