/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.StandardsInputParameterMapCopier;
import software.amazon.awssdk.services.securityhub.model.StandardsStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StandardsSubscription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StandardsSubscription> {
    private static final SdkField<String> STANDARDS_SUBSCRIPTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StandardsSubscriptionArn").getter(StandardsSubscription.getter(StandardsSubscription::standardsSubscriptionArn)).setter(StandardsSubscription.setter(Builder::standardsSubscriptionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsSubscriptionArn").build()}).build();
    private static final SdkField<String> STANDARDS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StandardsArn").getter(StandardsSubscription.getter(StandardsSubscription::standardsArn)).setter(StandardsSubscription.setter(Builder::standardsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsArn").build()}).build();
    private static final SdkField<Map<String, String>> STANDARDS_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("StandardsInput").getter(StandardsSubscription.getter(StandardsSubscription::standardsInput)).setter(StandardsSubscription.setter(Builder::standardsInput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsInput").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STANDARDS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StandardsStatus").getter(StandardsSubscription.getter(StandardsSubscription::standardsStatusAsString)).setter(StandardsSubscription.setter(Builder::standardsStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARDS_SUBSCRIPTION_ARN_FIELD, STANDARDS_ARN_FIELD, STANDARDS_INPUT_FIELD, STANDARDS_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String standardsSubscriptionArn;
    private final String standardsArn;
    private final Map<String, String> standardsInput;
    private final String standardsStatus;

    private StandardsSubscription(BuilderImpl builder) {
        this.standardsSubscriptionArn = builder.standardsSubscriptionArn;
        this.standardsArn = builder.standardsArn;
        this.standardsInput = builder.standardsInput;
        this.standardsStatus = builder.standardsStatus;
    }

    public final String standardsSubscriptionArn() {
        return this.standardsSubscriptionArn;
    }

    public final String standardsArn() {
        return this.standardsArn;
    }

    public final boolean hasStandardsInput() {
        return this.standardsInput != null && !(this.standardsInput instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> standardsInput() {
        return this.standardsInput;
    }

    public final StandardsStatus standardsStatus() {
        return StandardsStatus.fromValue(this.standardsStatus);
    }

    public final String standardsStatusAsString() {
        return this.standardsStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.standardsSubscriptionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStandardsInput() ? this.standardsInput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.standardsStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StandardsSubscription)) {
            return false;
        }
        StandardsSubscription other = (StandardsSubscription)obj;
        return Objects.equals(this.standardsSubscriptionArn(), other.standardsSubscriptionArn()) && Objects.equals(this.standardsArn(), other.standardsArn()) && this.hasStandardsInput() == other.hasStandardsInput() && Objects.equals(this.standardsInput(), other.standardsInput()) && Objects.equals(this.standardsStatusAsString(), other.standardsStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StandardsSubscription").add("StandardsSubscriptionArn", (Object)this.standardsSubscriptionArn()).add("StandardsArn", (Object)this.standardsArn()).add("StandardsInput", this.hasStandardsInput() ? this.standardsInput() : null).add("StandardsStatus", (Object)this.standardsStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StandardsSubscriptionArn": {
                return Optional.ofNullable(clazz.cast(this.standardsSubscriptionArn()));
            }
            case "StandardsArn": {
                return Optional.ofNullable(clazz.cast(this.standardsArn()));
            }
            case "StandardsInput": {
                return Optional.ofNullable(clazz.cast(this.standardsInput()));
            }
            case "StandardsStatus": {
                return Optional.ofNullable(clazz.cast(this.standardsStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StandardsSubscription, T> g) {
        return obj -> g.apply((StandardsSubscription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String standardsSubscriptionArn;
        private String standardsArn;
        private Map<String, String> standardsInput = DefaultSdkAutoConstructMap.getInstance();
        private String standardsStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(StandardsSubscription model) {
            this.standardsSubscriptionArn(model.standardsSubscriptionArn);
            this.standardsArn(model.standardsArn);
            this.standardsInput(model.standardsInput);
            this.standardsStatus(model.standardsStatus);
        }

        public final String getStandardsSubscriptionArn() {
            return this.standardsSubscriptionArn;
        }

        @Override
        public final Builder standardsSubscriptionArn(String standardsSubscriptionArn) {
            this.standardsSubscriptionArn = standardsSubscriptionArn;
            return this;
        }

        public final void setStandardsSubscriptionArn(String standardsSubscriptionArn) {
            this.standardsSubscriptionArn = standardsSubscriptionArn;
        }

        public final String getStandardsArn() {
            return this.standardsArn;
        }

        @Override
        public final Builder standardsArn(String standardsArn) {
            this.standardsArn = standardsArn;
            return this;
        }

        public final void setStandardsArn(String standardsArn) {
            this.standardsArn = standardsArn;
        }

        public final Map<String, String> getStandardsInput() {
            if (this.standardsInput instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.standardsInput;
        }

        @Override
        public final Builder standardsInput(Map<String, String> standardsInput) {
            this.standardsInput = StandardsInputParameterMapCopier.copy(standardsInput);
            return this;
        }

        public final void setStandardsInput(Map<String, String> standardsInput) {
            this.standardsInput = StandardsInputParameterMapCopier.copy(standardsInput);
        }

        public final String getStandardsStatus() {
            return this.standardsStatus;
        }

        @Override
        public final Builder standardsStatus(String standardsStatus) {
            this.standardsStatus = standardsStatus;
            return this;
        }

        @Override
        public final Builder standardsStatus(StandardsStatus standardsStatus) {
            this.standardsStatus(standardsStatus == null ? null : standardsStatus.toString());
            return this;
        }

        public final void setStandardsStatus(String standardsStatus) {
            this.standardsStatus = standardsStatus;
        }

        public StandardsSubscription build() {
            return new StandardsSubscription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StandardsSubscription> {
        public Builder standardsSubscriptionArn(String var1);

        public Builder standardsArn(String var1);

        public Builder standardsInput(Map<String, String> var1);

        public Builder standardsStatus(String var1);

        public Builder standardsStatus(StandardsStatus var1);
    }
}

