/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingFilters;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.SortCriteriaCopier;
import software.amazon.awssdk.services.securityhub.model.SortCriterion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFindingsRequest
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, GetFindingsRequest> {
    private static final SdkField<AwsSecurityFindingFilters> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filters").getter(GetFindingsRequest.getter(GetFindingsRequest::filters)).setter(GetFindingsRequest.setter(Builder::filters)).constructor(AwsSecurityFindingFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final SdkField<List<SortCriterion>> SORT_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SortCriteria").getter(GetFindingsRequest.getter(GetFindingsRequest::sortCriteria)).setter(GetFindingsRequest.setter(Builder::sortCriteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortCriteria").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SortCriterion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetFindingsRequest.getter(GetFindingsRequest::nextToken)).setter(GetFindingsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetFindingsRequest.getter(GetFindingsRequest::maxResults)).setter(GetFindingsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, SORT_CRITERIA_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final AwsSecurityFindingFilters filters;
    private final List<SortCriterion> sortCriteria;
    private final String nextToken;
    private final Integer maxResults;

    private GetFindingsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.sortCriteria = builder.sortCriteria;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public AwsSecurityFindingFilters filters() {
        return this.filters;
    }

    public boolean hasSortCriteria() {
        return this.sortCriteria != null && !(this.sortCriteria instanceof SdkAutoConstructList);
    }

    public List<SortCriterion> sortCriteria() {
        return this.sortCriteria;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingsRequest)) {
            return false;
        }
        GetFindingsRequest other = (GetFindingsRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.sortCriteria(), other.sortCriteria()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"GetFindingsRequest").add("Filters", (Object)this.filters()).add("SortCriteria", this.sortCriteria()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "SortCriteria": {
                return Optional.ofNullable(clazz.cast(this.sortCriteria()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFindingsRequest, T> g) {
        return obj -> g.apply((GetFindingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private AwsSecurityFindingFilters filters;
        private List<SortCriterion> sortCriteria = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingsRequest model) {
            super(model);
            this.filters(model.filters);
            this.sortCriteria(model.sortCriteria);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final AwsSecurityFindingFilters.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        @Override
        public final Builder filters(AwsSecurityFindingFilters filters) {
            this.filters = filters;
            return this;
        }

        public final void setFilters(AwsSecurityFindingFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        public final Collection<SortCriterion.Builder> getSortCriteria() {
            return this.sortCriteria != null ? (Collection)this.sortCriteria.stream().map(SortCriterion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sortCriteria(Collection<SortCriterion> sortCriteria) {
            this.sortCriteria = SortCriteriaCopier.copy(sortCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortCriteria(SortCriterion ... sortCriteria) {
            this.sortCriteria(Arrays.asList(sortCriteria));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortCriteria(Consumer<SortCriterion.Builder> ... sortCriteria) {
            this.sortCriteria(Stream.of(sortCriteria).map(c -> (SortCriterion)((SortCriterion.Builder)SortCriterion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSortCriteria(Collection<SortCriterion.BuilderImpl> sortCriteria) {
            this.sortCriteria = SortCriteriaCopier.copyFromBuilder(sortCriteria);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFindingsRequest build() {
            return new GetFindingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFindingsRequest> {
        public Builder filters(AwsSecurityFindingFilters var1);

        default public Builder filters(Consumer<AwsSecurityFindingFilters.Builder> filters) {
            return this.filters((AwsSecurityFindingFilters)((AwsSecurityFindingFilters.Builder)AwsSecurityFindingFilters.builder().applyMutation(filters)).build());
        }

        public Builder sortCriteria(Collection<SortCriterion> var1);

        public Builder sortCriteria(SortCriterion ... var1);

        public Builder sortCriteria(Consumer<SortCriterion.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

