/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.StandardsSubscriptionArnsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDisableStandardsRequest
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, BatchDisableStandardsRequest> {
    private static final SdkField<List<String>> STANDARDS_SUBSCRIPTION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StandardsSubscriptionArns").getter(BatchDisableStandardsRequest.getter(BatchDisableStandardsRequest::standardsSubscriptionArns)).setter(BatchDisableStandardsRequest.setter(Builder::standardsSubscriptionArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsSubscriptionArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARDS_SUBSCRIPTION_ARNS_FIELD));
    private final List<String> standardsSubscriptionArns;

    private BatchDisableStandardsRequest(BuilderImpl builder) {
        super(builder);
        this.standardsSubscriptionArns = builder.standardsSubscriptionArns;
    }

    public boolean hasStandardsSubscriptionArns() {
        return this.standardsSubscriptionArns != null && !(this.standardsSubscriptionArns instanceof SdkAutoConstructList);
    }

    public List<String> standardsSubscriptionArns() {
        return this.standardsSubscriptionArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.standardsSubscriptionArns());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDisableStandardsRequest)) {
            return false;
        }
        BatchDisableStandardsRequest other = (BatchDisableStandardsRequest)((Object)obj);
        return Objects.equals(this.standardsSubscriptionArns(), other.standardsSubscriptionArns());
    }

    public String toString() {
        return ToString.builder((String)"BatchDisableStandardsRequest").add("StandardsSubscriptionArns", this.standardsSubscriptionArns()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StandardsSubscriptionArns": {
                return Optional.ofNullable(clazz.cast(this.standardsSubscriptionArns()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDisableStandardsRequest, T> g) {
        return obj -> g.apply((BatchDisableStandardsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private List<String> standardsSubscriptionArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDisableStandardsRequest model) {
            super(model);
            this.standardsSubscriptionArns(model.standardsSubscriptionArns);
        }

        public final Collection<String> getStandardsSubscriptionArns() {
            return this.standardsSubscriptionArns;
        }

        @Override
        public final Builder standardsSubscriptionArns(Collection<String> standardsSubscriptionArns) {
            this.standardsSubscriptionArns = StandardsSubscriptionArnsCopier.copy(standardsSubscriptionArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standardsSubscriptionArns(String ... standardsSubscriptionArns) {
            this.standardsSubscriptionArns(Arrays.asList(standardsSubscriptionArns));
            return this;
        }

        public final void setStandardsSubscriptionArns(Collection<String> standardsSubscriptionArns) {
            this.standardsSubscriptionArns = StandardsSubscriptionArnsCopier.copy(standardsSubscriptionArns);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDisableStandardsRequest build() {
            return new BatchDisableStandardsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDisableStandardsRequest> {
        public Builder standardsSubscriptionArns(Collection<String> var1);

        public Builder standardsSubscriptionArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

