/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroup;
import software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroupsItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsCloudFrontDistributionOriginGroups
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsCloudFrontDistributionOriginGroups> {
    private static final SdkField<List<AwsCloudFrontDistributionOriginGroup>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Items").getter(AwsCloudFrontDistributionOriginGroups.getter(AwsCloudFrontDistributionOriginGroups::items)).setter(AwsCloudFrontDistributionOriginGroups.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsCloudFrontDistributionOriginGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AwsCloudFrontDistributionOriginGroup> items;

    private AwsCloudFrontDistributionOriginGroups(BuilderImpl builder) {
        this.items = builder.items;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<AwsCloudFrontDistributionOriginGroup> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFrontDistributionOriginGroups)) {
            return false;
        }
        AwsCloudFrontDistributionOriginGroups other = (AwsCloudFrontDistributionOriginGroups)obj;
        return this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items());
    }

    public final String toString() {
        return ToString.builder((String)"AwsCloudFrontDistributionOriginGroups").add("Items", this.hasItems() ? this.items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFrontDistributionOriginGroups, T> g) {
        return obj -> g.apply((AwsCloudFrontDistributionOriginGroups)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AwsCloudFrontDistributionOriginGroup> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFrontDistributionOriginGroups model) {
            this.items(model.items);
        }

        public final Collection<AwsCloudFrontDistributionOriginGroup.Builder> getItems() {
            if (this.items instanceof SdkAutoConstructList) {
                return null;
            }
            return this.items != null ? (Collection)this.items.stream().map(AwsCloudFrontDistributionOriginGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<AwsCloudFrontDistributionOriginGroup> items) {
            this.items = AwsCloudFrontDistributionOriginGroupsItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(AwsCloudFrontDistributionOriginGroup ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<AwsCloudFrontDistributionOriginGroup.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (AwsCloudFrontDistributionOriginGroup)((AwsCloudFrontDistributionOriginGroup.Builder)AwsCloudFrontDistributionOriginGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<AwsCloudFrontDistributionOriginGroup.BuilderImpl> items) {
            this.items = AwsCloudFrontDistributionOriginGroupsItemListCopier.copyFromBuilder(items);
        }

        public AwsCloudFrontDistributionOriginGroups build() {
            return new AwsCloudFrontDistributionOriginGroups(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsCloudFrontDistributionOriginGroups> {
        public Builder items(Collection<AwsCloudFrontDistributionOriginGroup> var1);

        public Builder items(AwsCloudFrontDistributionOriginGroup ... var1);

        public Builder items(Consumer<AwsCloudFrontDistributionOriginGroup.Builder> ... var1);
    }
}

