/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions;
import software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions;
import software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions;
import software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainVPCOptions;
import software.amazon.awssdk.services.securityhub.model.FieldMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsElasticsearchDomainDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsElasticsearchDomainDetails> {
    private static final SdkField<String> ACCESS_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessPolicies").getter(AwsElasticsearchDomainDetails.getter(AwsElasticsearchDomainDetails::accessPolicies)).setter(AwsElasticsearchDomainDetails.setter(Builder::accessPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPolicies").build()}).build();
    private static final SdkField<AwsElasticsearchDomainDomainEndpointOptions> DOMAIN_ENDPOINT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DomainEndpointOptions").getter(AwsElasticsearchDomainDetails.getter(AwsElasticsearchDomainDetails::domainEndpointOptions)).setter(AwsElasticsearchDomainDetails.setter(Builder::domainEndpointOptions)).constructor(AwsElasticsearchDomainDomainEndpointOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpointOptions").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(AwsElasticsearchDomainDetails.getter(AwsElasticsearchDomainDetails::domainId)).setter(AwsElasticsearchDomainDetails.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(AwsElasticsearchDomainDetails.getter(AwsElasticsearchDomainDetails::domainName)).setter(AwsElasticsearchDomainDetails.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Endpoint").getter(AwsElasticsearchDomainDetails.getter(AwsElasticsearchDomainDetails::endpoint)).setter(AwsElasticsearchDomainDetails.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<Map<String, String>> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Endpoints").getter(AwsElasticsearchDomainDetails.getter(AwsElasticsearchDomainDetails::endpoints)).setter(AwsElasticsearchDomainDetails.setter(Builder::endpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ELASTICSEARCH_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ElasticsearchVersion").getter(AwsElasticsearchDomainDetails.getter(AwsElasticsearchDomainDetails::elasticsearchVersion)).setter(AwsElasticsearchDomainDetails.setter(Builder::elasticsearchVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchVersion").build()}).build();
    private static final SdkField<AwsElasticsearchDomainEncryptionAtRestOptions> ENCRYPTION_AT_REST_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionAtRestOptions").getter(AwsElasticsearchDomainDetails.getter(AwsElasticsearchDomainDetails::encryptionAtRestOptions)).setter(AwsElasticsearchDomainDetails.setter(Builder::encryptionAtRestOptions)).constructor(AwsElasticsearchDomainEncryptionAtRestOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRestOptions").build()}).build();
    private static final SdkField<AwsElasticsearchDomainNodeToNodeEncryptionOptions> NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NodeToNodeEncryptionOptions").getter(AwsElasticsearchDomainDetails.getter(AwsElasticsearchDomainDetails::nodeToNodeEncryptionOptions)).setter(AwsElasticsearchDomainDetails.setter(Builder::nodeToNodeEncryptionOptions)).constructor(AwsElasticsearchDomainNodeToNodeEncryptionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeToNodeEncryptionOptions").build()}).build();
    private static final SdkField<AwsElasticsearchDomainVPCOptions> VPC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VPCOptions").getter(AwsElasticsearchDomainDetails.getter(AwsElasticsearchDomainDetails::vpcOptions)).setter(AwsElasticsearchDomainDetails.setter(Builder::vpcOptions)).constructor(AwsElasticsearchDomainVPCOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POLICIES_FIELD, DOMAIN_ENDPOINT_OPTIONS_FIELD, DOMAIN_ID_FIELD, DOMAIN_NAME_FIELD, ENDPOINT_FIELD, ENDPOINTS_FIELD, ELASTICSEARCH_VERSION_FIELD, ENCRYPTION_AT_REST_OPTIONS_FIELD, NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD, VPC_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accessPolicies;
    private final AwsElasticsearchDomainDomainEndpointOptions domainEndpointOptions;
    private final String domainId;
    private final String domainName;
    private final String endpoint;
    private final Map<String, String> endpoints;
    private final String elasticsearchVersion;
    private final AwsElasticsearchDomainEncryptionAtRestOptions encryptionAtRestOptions;
    private final AwsElasticsearchDomainNodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;
    private final AwsElasticsearchDomainVPCOptions vpcOptions;

    private AwsElasticsearchDomainDetails(BuilderImpl builder) {
        this.accessPolicies = builder.accessPolicies;
        this.domainEndpointOptions = builder.domainEndpointOptions;
        this.domainId = builder.domainId;
        this.domainName = builder.domainName;
        this.endpoint = builder.endpoint;
        this.endpoints = builder.endpoints;
        this.elasticsearchVersion = builder.elasticsearchVersion;
        this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
        this.nodeToNodeEncryptionOptions = builder.nodeToNodeEncryptionOptions;
        this.vpcOptions = builder.vpcOptions;
    }

    public String accessPolicies() {
        return this.accessPolicies;
    }

    public AwsElasticsearchDomainDomainEndpointOptions domainEndpointOptions() {
        return this.domainEndpointOptions;
    }

    public String domainId() {
        return this.domainId;
    }

    public String domainName() {
        return this.domainName;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public boolean hasEndpoints() {
        return this.endpoints != null && !(this.endpoints instanceof SdkAutoConstructMap);
    }

    public Map<String, String> endpoints() {
        return this.endpoints;
    }

    public String elasticsearchVersion() {
        return this.elasticsearchVersion;
    }

    public AwsElasticsearchDomainEncryptionAtRestOptions encryptionAtRestOptions() {
        return this.encryptionAtRestOptions;
    }

    public AwsElasticsearchDomainNodeToNodeEncryptionOptions nodeToNodeEncryptionOptions() {
        return this.nodeToNodeEncryptionOptions;
    }

    public AwsElasticsearchDomainVPCOptions vpcOptions() {
        return this.vpcOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainEndpointOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpoints() ? this.endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAtRestOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeToNodeEncryptionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElasticsearchDomainDetails)) {
            return false;
        }
        AwsElasticsearchDomainDetails other = (AwsElasticsearchDomainDetails)obj;
        return Objects.equals(this.accessPolicies(), other.accessPolicies()) && Objects.equals(this.domainEndpointOptions(), other.domainEndpointOptions()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.endpoint(), other.endpoint()) && this.hasEndpoints() == other.hasEndpoints() && Objects.equals(this.endpoints(), other.endpoints()) && Objects.equals(this.elasticsearchVersion(), other.elasticsearchVersion()) && Objects.equals(this.encryptionAtRestOptions(), other.encryptionAtRestOptions()) && Objects.equals(this.nodeToNodeEncryptionOptions(), other.nodeToNodeEncryptionOptions()) && Objects.equals(this.vpcOptions(), other.vpcOptions());
    }

    public String toString() {
        return ToString.builder((String)"AwsElasticsearchDomainDetails").add("AccessPolicies", (Object)this.accessPolicies()).add("DomainEndpointOptions", (Object)this.domainEndpointOptions()).add("DomainId", (Object)this.domainId()).add("DomainName", (Object)this.domainName()).add("Endpoint", (Object)this.endpoint()).add("Endpoints", this.hasEndpoints() ? this.endpoints() : null).add("ElasticsearchVersion", (Object)this.elasticsearchVersion()).add("EncryptionAtRestOptions", (Object)this.encryptionAtRestOptions()).add("NodeToNodeEncryptionOptions", (Object)this.nodeToNodeEncryptionOptions()).add("VPCOptions", (Object)this.vpcOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessPolicies": {
                return Optional.ofNullable(clazz.cast(this.accessPolicies()));
            }
            case "DomainEndpointOptions": {
                return Optional.ofNullable(clazz.cast(this.domainEndpointOptions()));
            }
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
            case "ElasticsearchVersion": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchVersion()));
            }
            case "EncryptionAtRestOptions": {
                return Optional.ofNullable(clazz.cast(this.encryptionAtRestOptions()));
            }
            case "NodeToNodeEncryptionOptions": {
                return Optional.ofNullable(clazz.cast(this.nodeToNodeEncryptionOptions()));
            }
            case "VPCOptions": {
                return Optional.ofNullable(clazz.cast(this.vpcOptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsElasticsearchDomainDetails, T> g) {
        return obj -> g.apply((AwsElasticsearchDomainDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessPolicies;
        private AwsElasticsearchDomainDomainEndpointOptions domainEndpointOptions;
        private String domainId;
        private String domainName;
        private String endpoint;
        private Map<String, String> endpoints = DefaultSdkAutoConstructMap.getInstance();
        private String elasticsearchVersion;
        private AwsElasticsearchDomainEncryptionAtRestOptions encryptionAtRestOptions;
        private AwsElasticsearchDomainNodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;
        private AwsElasticsearchDomainVPCOptions vpcOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElasticsearchDomainDetails model) {
            this.accessPolicies(model.accessPolicies);
            this.domainEndpointOptions(model.domainEndpointOptions);
            this.domainId(model.domainId);
            this.domainName(model.domainName);
            this.endpoint(model.endpoint);
            this.endpoints(model.endpoints);
            this.elasticsearchVersion(model.elasticsearchVersion);
            this.encryptionAtRestOptions(model.encryptionAtRestOptions);
            this.nodeToNodeEncryptionOptions(model.nodeToNodeEncryptionOptions);
            this.vpcOptions(model.vpcOptions);
        }

        public final String getAccessPolicies() {
            return this.accessPolicies;
        }

        @Override
        public final Builder accessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final void setAccessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
        }

        public final AwsElasticsearchDomainDomainEndpointOptions.Builder getDomainEndpointOptions() {
            return this.domainEndpointOptions != null ? this.domainEndpointOptions.toBuilder() : null;
        }

        @Override
        public final Builder domainEndpointOptions(AwsElasticsearchDomainDomainEndpointOptions domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        public final void setDomainEndpointOptions(AwsElasticsearchDomainDomainEndpointOptions.BuilderImpl domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions != null ? domainEndpointOptions.build() : null;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final Map<String, String> getEndpoints() {
            if (this.endpoints instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.endpoints;
        }

        @Override
        public final Builder endpoints(Map<String, String> endpoints) {
            this.endpoints = FieldMapCopier.copy(endpoints);
            return this;
        }

        public final void setEndpoints(Map<String, String> endpoints) {
            this.endpoints = FieldMapCopier.copy(endpoints);
        }

        public final String getElasticsearchVersion() {
            return this.elasticsearchVersion;
        }

        @Override
        public final Builder elasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
            return this;
        }

        public final void setElasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
        }

        public final AwsElasticsearchDomainEncryptionAtRestOptions.Builder getEncryptionAtRestOptions() {
            return this.encryptionAtRestOptions != null ? this.encryptionAtRestOptions.toBuilder() : null;
        }

        @Override
        public final Builder encryptionAtRestOptions(AwsElasticsearchDomainEncryptionAtRestOptions encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        public final void setEncryptionAtRestOptions(AwsElasticsearchDomainEncryptionAtRestOptions.BuilderImpl encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions != null ? encryptionAtRestOptions.build() : null;
        }

        public final AwsElasticsearchDomainNodeToNodeEncryptionOptions.Builder getNodeToNodeEncryptionOptions() {
            return this.nodeToNodeEncryptionOptions != null ? this.nodeToNodeEncryptionOptions.toBuilder() : null;
        }

        @Override
        public final Builder nodeToNodeEncryptionOptions(AwsElasticsearchDomainNodeToNodeEncryptionOptions nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
            return this;
        }

        public final void setNodeToNodeEncryptionOptions(AwsElasticsearchDomainNodeToNodeEncryptionOptions.BuilderImpl nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.build() : null;
        }

        public final AwsElasticsearchDomainVPCOptions.Builder getVpcOptions() {
            return this.vpcOptions != null ? this.vpcOptions.toBuilder() : null;
        }

        @Override
        public final Builder vpcOptions(AwsElasticsearchDomainVPCOptions vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final void setVpcOptions(AwsElasticsearchDomainVPCOptions.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        public AwsElasticsearchDomainDetails build() {
            return new AwsElasticsearchDomainDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsElasticsearchDomainDetails> {
        public Builder accessPolicies(String var1);

        public Builder domainEndpointOptions(AwsElasticsearchDomainDomainEndpointOptions var1);

        default public Builder domainEndpointOptions(Consumer<AwsElasticsearchDomainDomainEndpointOptions.Builder> domainEndpointOptions) {
            return this.domainEndpointOptions((AwsElasticsearchDomainDomainEndpointOptions)((AwsElasticsearchDomainDomainEndpointOptions.Builder)AwsElasticsearchDomainDomainEndpointOptions.builder().applyMutation(domainEndpointOptions)).build());
        }

        public Builder domainId(String var1);

        public Builder domainName(String var1);

        public Builder endpoint(String var1);

        public Builder endpoints(Map<String, String> var1);

        public Builder elasticsearchVersion(String var1);

        public Builder encryptionAtRestOptions(AwsElasticsearchDomainEncryptionAtRestOptions var1);

        default public Builder encryptionAtRestOptions(Consumer<AwsElasticsearchDomainEncryptionAtRestOptions.Builder> encryptionAtRestOptions) {
            return this.encryptionAtRestOptions((AwsElasticsearchDomainEncryptionAtRestOptions)((AwsElasticsearchDomainEncryptionAtRestOptions.Builder)AwsElasticsearchDomainEncryptionAtRestOptions.builder().applyMutation(encryptionAtRestOptions)).build());
        }

        public Builder nodeToNodeEncryptionOptions(AwsElasticsearchDomainNodeToNodeEncryptionOptions var1);

        default public Builder nodeToNodeEncryptionOptions(Consumer<AwsElasticsearchDomainNodeToNodeEncryptionOptions.Builder> nodeToNodeEncryptionOptions) {
            return this.nodeToNodeEncryptionOptions((AwsElasticsearchDomainNodeToNodeEncryptionOptions)((AwsElasticsearchDomainNodeToNodeEncryptionOptions.Builder)AwsElasticsearchDomainNodeToNodeEncryptionOptions.builder().applyMutation(nodeToNodeEncryptionOptions)).build());
        }

        public Builder vpcOptions(AwsElasticsearchDomainVPCOptions var1);

        default public Builder vpcOptions(Consumer<AwsElasticsearchDomainVPCOptions.Builder> vpcOptions) {
            return this.vpcOptions((AwsElasticsearchDomainVPCOptions)((AwsElasticsearchDomainVPCOptions.Builder)AwsElasticsearchDomainVPCOptions.builder().applyMutation(vpcOptions)).build());
        }
    }
}

