/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.services.securityhub.model.StandardsSubscription;
import software.amazon.awssdk.services.securityhub.model.StandardsSubscriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDisableStandardsResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, BatchDisableStandardsResponse> {
    private static final SdkField<List<StandardsSubscription>> STANDARDS_SUBSCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StandardsSubscriptions").getter(BatchDisableStandardsResponse.getter(BatchDisableStandardsResponse::standardsSubscriptions)).setter(BatchDisableStandardsResponse.setter(Builder::standardsSubscriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsSubscriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StandardsSubscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARDS_SUBSCRIPTIONS_FIELD));
    private final List<StandardsSubscription> standardsSubscriptions;

    private BatchDisableStandardsResponse(BuilderImpl builder) {
        super(builder);
        this.standardsSubscriptions = builder.standardsSubscriptions;
    }

    public boolean hasStandardsSubscriptions() {
        return this.standardsSubscriptions != null && !(this.standardsSubscriptions instanceof SdkAutoConstructList);
    }

    public List<StandardsSubscription> standardsSubscriptions() {
        return this.standardsSubscriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStandardsSubscriptions() ? this.standardsSubscriptions() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDisableStandardsResponse)) {
            return false;
        }
        BatchDisableStandardsResponse other = (BatchDisableStandardsResponse)((Object)obj);
        return this.hasStandardsSubscriptions() == other.hasStandardsSubscriptions() && Objects.equals(this.standardsSubscriptions(), other.standardsSubscriptions());
    }

    public String toString() {
        return ToString.builder((String)"BatchDisableStandardsResponse").add("StandardsSubscriptions", this.hasStandardsSubscriptions() ? this.standardsSubscriptions() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StandardsSubscriptions": {
                return Optional.ofNullable(clazz.cast(this.standardsSubscriptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDisableStandardsResponse, T> g) {
        return obj -> g.apply((BatchDisableStandardsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<StandardsSubscription> standardsSubscriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDisableStandardsResponse model) {
            super(model);
            this.standardsSubscriptions(model.standardsSubscriptions);
        }

        public final Collection<StandardsSubscription.Builder> getStandardsSubscriptions() {
            if (this.standardsSubscriptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.standardsSubscriptions != null ? (Collection)this.standardsSubscriptions.stream().map(StandardsSubscription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder standardsSubscriptions(Collection<StandardsSubscription> standardsSubscriptions) {
            this.standardsSubscriptions = StandardsSubscriptionsCopier.copy(standardsSubscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standardsSubscriptions(StandardsSubscription ... standardsSubscriptions) {
            this.standardsSubscriptions(Arrays.asList(standardsSubscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standardsSubscriptions(Consumer<StandardsSubscription.Builder> ... standardsSubscriptions) {
            this.standardsSubscriptions(Stream.of(standardsSubscriptions).map(c -> (StandardsSubscription)((StandardsSubscription.Builder)StandardsSubscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStandardsSubscriptions(Collection<StandardsSubscription.BuilderImpl> standardsSubscriptions) {
            this.standardsSubscriptions = StandardsSubscriptionsCopier.copyFromBuilder(standardsSubscriptions);
        }

        @Override
        public BatchDisableStandardsResponse build() {
            return new BatchDisableStandardsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDisableStandardsResponse> {
        public Builder standardsSubscriptions(Collection<StandardsSubscription> var1);

        public Builder standardsSubscriptions(StandardsSubscription ... var1);

        public Builder standardsSubscriptions(Consumer<StandardsSubscription.Builder> ... var1);
    }
}

