/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.ComplianceStatus;
import software.amazon.awssdk.services.securityhub.model.RelatedRequirementsListCopier;
import software.amazon.awssdk.services.securityhub.model.StatusReason;
import software.amazon.awssdk.services.securityhub.model.StatusReasonsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Compliance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Compliance> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Compliance.getter(Compliance::statusAsString)).setter(Compliance.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<String>> RELATED_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RelatedRequirements").getter(Compliance.getter(Compliance::relatedRequirements)).setter(Compliance.setter(Builder::relatedRequirements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedRequirements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StatusReason>> STATUS_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatusReasons").getter(Compliance.getter(Compliance::statusReasons)).setter(Compliance.setter(Builder::statusReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StatusReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, RELATED_REQUIREMENTS_FIELD, STATUS_REASONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final List<String> relatedRequirements;
    private final List<StatusReason> statusReasons;

    private Compliance(BuilderImpl builder) {
        this.status = builder.status;
        this.relatedRequirements = builder.relatedRequirements;
        this.statusReasons = builder.statusReasons;
    }

    public ComplianceStatus status() {
        return ComplianceStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public boolean hasRelatedRequirements() {
        return this.relatedRequirements != null && !(this.relatedRequirements instanceof SdkAutoConstructList);
    }

    public List<String> relatedRequirements() {
        return this.relatedRequirements;
    }

    public boolean hasStatusReasons() {
        return this.statusReasons != null && !(this.statusReasons instanceof SdkAutoConstructList);
    }

    public List<StatusReason> statusReasons() {
        return this.statusReasons;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedRequirements() ? this.relatedRequirements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusReasons() ? this.statusReasons() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Compliance)) {
            return false;
        }
        Compliance other = (Compliance)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasRelatedRequirements() == other.hasRelatedRequirements() && Objects.equals(this.relatedRequirements(), other.relatedRequirements()) && this.hasStatusReasons() == other.hasStatusReasons() && Objects.equals(this.statusReasons(), other.statusReasons());
    }

    public String toString() {
        return ToString.builder((String)"Compliance").add("Status", (Object)this.statusAsString()).add("RelatedRequirements", this.hasRelatedRequirements() ? this.relatedRequirements() : null).add("StatusReasons", this.hasStatusReasons() ? this.statusReasons() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "RelatedRequirements": {
                return Optional.ofNullable(clazz.cast(this.relatedRequirements()));
            }
            case "StatusReasons": {
                return Optional.ofNullable(clazz.cast(this.statusReasons()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Compliance, T> g) {
        return obj -> g.apply((Compliance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private List<String> relatedRequirements = DefaultSdkAutoConstructList.getInstance();
        private List<StatusReason> statusReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Compliance model) {
            this.status(model.status);
            this.relatedRequirements(model.relatedRequirements);
            this.statusReasons(model.statusReasons);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ComplianceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<String> getRelatedRequirements() {
            if (this.relatedRequirements instanceof SdkAutoConstructList) {
                return null;
            }
            return this.relatedRequirements;
        }

        @Override
        public final Builder relatedRequirements(Collection<String> relatedRequirements) {
            this.relatedRequirements = RelatedRequirementsListCopier.copy(relatedRequirements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedRequirements(String ... relatedRequirements) {
            this.relatedRequirements(Arrays.asList(relatedRequirements));
            return this;
        }

        public final void setRelatedRequirements(Collection<String> relatedRequirements) {
            this.relatedRequirements = RelatedRequirementsListCopier.copy(relatedRequirements);
        }

        public final Collection<StatusReason.Builder> getStatusReasons() {
            if (this.statusReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statusReasons != null ? (Collection)this.statusReasons.stream().map(StatusReason::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statusReasons(Collection<StatusReason> statusReasons) {
            this.statusReasons = StatusReasonsListCopier.copy(statusReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusReasons(StatusReason ... statusReasons) {
            this.statusReasons(Arrays.asList(statusReasons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusReasons(Consumer<StatusReason.Builder> ... statusReasons) {
            this.statusReasons(Stream.of(statusReasons).map(c -> (StatusReason)((StatusReason.Builder)StatusReason.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStatusReasons(Collection<StatusReason.BuilderImpl> statusReasons) {
            this.statusReasons = StatusReasonsListCopier.copyFromBuilder(statusReasons);
        }

        public Compliance build() {
            return new Compliance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Compliance> {
        public Builder status(String var1);

        public Builder status(ComplianceStatus var1);

        public Builder relatedRequirements(Collection<String> var1);

        public Builder relatedRequirements(String ... var1);

        public Builder statusReasons(Collection<StatusReason> var1);

        public Builder statusReasons(StatusReason ... var1);

        public Builder statusReasons(Consumer<StatusReason.Builder> ... var1);
    }
}

