/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.services.securityhub.model.StandardsControl;
import software.amazon.awssdk.services.securityhub.model.StandardsControlsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStandardsControlsResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, DescribeStandardsControlsResponse> {
    private static final SdkField<List<StandardsControl>> CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeStandardsControlsResponse.getter(DescribeStandardsControlsResponse::controls)).setter(DescribeStandardsControlsResponse.setter(Builder::controls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Controls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StandardsControl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeStandardsControlsResponse.getter(DescribeStandardsControlsResponse::nextToken)).setter(DescribeStandardsControlsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROLS_FIELD, NEXT_TOKEN_FIELD));
    private final List<StandardsControl> controls;
    private final String nextToken;

    private DescribeStandardsControlsResponse(BuilderImpl builder) {
        super(builder);
        this.controls = builder.controls;
        this.nextToken = builder.nextToken;
    }

    public boolean hasControls() {
        return this.controls != null && !(this.controls instanceof SdkAutoConstructList);
    }

    public List<StandardsControl> controls() {
        return this.controls;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.controls());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStandardsControlsResponse)) {
            return false;
        }
        DescribeStandardsControlsResponse other = (DescribeStandardsControlsResponse)((Object)obj);
        return Objects.equals(this.controls(), other.controls()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeStandardsControlsResponse").add("Controls", this.controls()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Controls": {
                return Optional.ofNullable(clazz.cast(this.controls()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStandardsControlsResponse, T> g) {
        return obj -> g.apply((DescribeStandardsControlsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<StandardsControl> controls = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStandardsControlsResponse model) {
            super(model);
            this.controls(model.controls);
            this.nextToken(model.nextToken);
        }

        public final Collection<StandardsControl.Builder> getControls() {
            return this.controls != null ? (Collection)this.controls.stream().map(StandardsControl::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder controls(Collection<StandardsControl> controls) {
            this.controls = StandardsControlsCopier.copy(controls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controls(StandardsControl ... controls) {
            this.controls(Arrays.asList(controls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controls(Consumer<StandardsControl.Builder> ... controls) {
            this.controls(Stream.of(controls).map(c -> (StandardsControl)((StandardsControl.Builder)StandardsControl.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setControls(Collection<StandardsControl.BuilderImpl> controls) {
            this.controls = StandardsControlsCopier.copyFromBuilder(controls);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeStandardsControlsResponse build() {
            return new DescribeStandardsControlsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStandardsControlsResponse> {
        public Builder controls(Collection<StandardsControl> var1);

        public Builder controls(StandardsControl ... var1);

        public Builder controls(Consumer<StandardsControl.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

