/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsCloudFrontDistributionOriginItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsCloudFrontDistributionOriginItem> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsCloudFrontDistributionOriginItem.getter(AwsCloudFrontDistributionOriginItem::domainName)).setter(AwsCloudFrontDistributionOriginItem.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsCloudFrontDistributionOriginItem.getter(AwsCloudFrontDistributionOriginItem::id)).setter(AwsCloudFrontDistributionOriginItem.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ORIGIN_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AwsCloudFrontDistributionOriginItem.getter(AwsCloudFrontDistributionOriginItem::originPath)).setter(AwsCloudFrontDistributionOriginItem.setter(Builder::originPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, ID_FIELD, ORIGIN_PATH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final String id;
    private final String originPath;

    private AwsCloudFrontDistributionOriginItem(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.id = builder.id;
        this.originPath = builder.originPath;
    }

    public String domainName() {
        return this.domainName;
    }

    public String id() {
        return this.id;
    }

    public String originPath() {
        return this.originPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.originPath());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFrontDistributionOriginItem)) {
            return false;
        }
        AwsCloudFrontDistributionOriginItem other = (AwsCloudFrontDistributionOriginItem)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.originPath(), other.originPath());
    }

    public String toString() {
        return ToString.builder((String)"AwsCloudFrontDistributionOriginItem").add("DomainName", (Object)this.domainName()).add("Id", (Object)this.id()).add("OriginPath", (Object)this.originPath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "OriginPath": {
                return Optional.ofNullable(clazz.cast(this.originPath()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFrontDistributionOriginItem, T> g) {
        return obj -> g.apply((AwsCloudFrontDistributionOriginItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String id;
        private String originPath;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFrontDistributionOriginItem model) {
            this.domainName(model.domainName);
            this.id(model.id);
            this.originPath(model.originPath);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getOriginPath() {
            return this.originPath;
        }

        @Override
        public final Builder originPath(String originPath) {
            this.originPath = originPath;
            return this;
        }

        public final void setOriginPath(String originPath) {
            this.originPath = originPath;
        }

        public AwsCloudFrontDistributionOriginItem build() {
            return new AwsCloudFrontDistributionOriginItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsCloudFrontDistributionOriginItem> {
        public Builder domainName(String var1);

        public Builder id(String var1);

        public Builder originPath(String var1);
    }
}

